/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.mojang.logging.LogUtils;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.optifine.ChunkOF;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorConstructor;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClientChunkCache
extends ChunkSource {
    static final Logger f_104407_ = LogUtils.getLogger();
    private final LevelChunk f_104408_;
    private final LevelLightEngine f_104409_;
    volatile Storage f_104410_;
    final ClientLevel f_104411_;

    public ClientChunkCache(ClientLevel clientWorldIn, int viewDistance) {
        this.f_104411_ = clientWorldIn;
        this.f_104408_ = new EmptyLevelChunk((Level)clientWorldIn, new ChunkPos(0, 0), clientWorldIn.m_5962_().m_175515_(Registry.f_122885_).m_206081_(Biomes.f_48202_));
        this.f_104409_ = new LevelLightEngine((LightChunkGetter)this, true, clientWorldIn.m_6042_().m_63935_());
        this.f_104410_ = new Storage(this, ClientChunkCache.m_104448_((int)viewDistance));
    }

    public LevelLightEngine m_7827_() {
        return this.f_104409_;
    }

    private static boolean m_104438_(@Nullable LevelChunk chunkIn, int x, int z) {
        if (chunkIn == null) {
            return false;
        }
        ChunkPos chunkpos = chunkIn.m_7697_();
        return chunkpos.f_45578_ == x && chunkpos.f_45579_ == z;
    }

    public void m_104455_(int x, int z) {
        int i2;
        LevelChunk levelchunk;
        if (this.f_104410_.m_104500_(x, z) && ClientChunkCache.m_104438_((LevelChunk)(levelchunk = this.f_104410_.m_104479_(i2 = this.f_104410_.m_104481_(x, z))), (int)x, (int)z)) {
            if (Reflector.ChunkEvent_Unload_Constructor.exists()) {
                Reflector.postForgeBusEvent((ReflectorConstructor)Reflector.ChunkEvent_Unload_Constructor, (Object[])new Object[]{levelchunk});
            }
            levelchunk.m_62913_(false);
            this.f_104410_.m_104487_(i2, levelchunk, (LevelChunk)null);
        }
    }

    @Nullable
    public LevelChunk m_7587_(int chunkX, int chunkZ, ChunkStatus requiredStatus, boolean load) {
        LevelChunk levelchunk;
        if (this.f_104410_.m_104500_(chunkX, chunkZ) && ClientChunkCache.m_104438_((LevelChunk)(levelchunk = this.f_104410_.m_104479_(this.f_104410_.m_104481_(chunkX, chunkZ))), (int)chunkX, (int)chunkZ)) {
            return levelchunk;
        }
        return load ? this.f_104408_ : null;
    }

    public BlockGetter m_7653_() {
        return this.f_104411_;
    }

    @Nullable
    public LevelChunk m_194116_(int xIn, int zIn, FriendlyByteBuf bufIn, CompoundTag tagIn, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumerIn) {
        if (!this.f_104410_.m_104500_(xIn, zIn)) {
            f_104407_.warn("Ignoring chunk since it's not in the view range: {}, {}", (Object)xIn, (Object)zIn);
            return null;
        }
        int i2 = this.f_104410_.m_104481_(xIn, zIn);
        LevelChunk levelchunk = (LevelChunk)this.f_104410_.f_104466_.get(i2);
        ChunkPos chunkpos = new ChunkPos(xIn, zIn);
        if (!ClientChunkCache.m_104438_((LevelChunk)levelchunk, (int)xIn, (int)zIn)) {
            if (levelchunk != null) {
                levelchunk.m_62913_(false);
            }
            levelchunk = new ChunkOF((Level)this.f_104411_, chunkpos);
            levelchunk.m_187971_(bufIn, tagIn, consumerIn);
            this.f_104410_.m_104484_(i2, levelchunk);
        } else {
            levelchunk.m_187971_(bufIn, tagIn, consumerIn);
        }
        this.f_104411_.m_171649_(chunkpos);
        if (Reflector.ChunkEvent_Load_Constructor.exists()) {
            Reflector.postForgeBusEvent((ReflectorConstructor)Reflector.ChunkEvent_Load_Constructor, (Object[])new Object[]{levelchunk});
        }
        levelchunk.m_62913_(true);
        return levelchunk;
    }

    public void m_201698_(BooleanSupplier p_201698_1_, boolean p_201698_2_) {
    }

    public void m_104459_(int x, int z) {
        this.f_104410_.f_104469_ = x;
        this.f_104410_.f_104470_ = z;
    }

    public void m_104416_(int viewDistance) {
        int i2 = this.f_104410_.f_104467_;
        int j2 = ClientChunkCache.m_104448_((int)viewDistance);
        if (i2 != j2) {
            Storage clientchunkcache$storage = new Storage(this, j2);
            clientchunkcache$storage.f_104469_ = this.f_104410_.f_104469_;
            clientchunkcache$storage.f_104470_ = this.f_104410_.f_104470_;
            for (int k2 = 0; k2 < this.f_104410_.f_104466_.length(); ++k2) {
                LevelChunk levelchunk = (LevelChunk)this.f_104410_.f_104466_.get(k2);
                if (levelchunk == null) continue;
                ChunkPos chunkpos = levelchunk.m_7697_();
                if (!clientchunkcache$storage.m_104500_(chunkpos.f_45578_, chunkpos.f_45579_)) continue;
                clientchunkcache$storage.m_104484_(clientchunkcache$storage.m_104481_(chunkpos.f_45578_, chunkpos.f_45579_), levelchunk);
            }
            this.f_104410_ = clientchunkcache$storage;
        }
    }

    private static int m_104448_(int distanceIn) {
        return Math.max(2, distanceIn) + 3;
    }

    public String m_6754_() {
        return this.f_104410_.f_104466_.length() + ", " + this.m_142061_();
    }

    public int m_142061_() {
        return this.f_104410_.f_104471_;
    }

    public void m_6506_(LightLayer type, SectionPos pos) {
        Minecraft.m_91087_().f_91060_.m_109770_(pos.m_123170_(), pos.m_123206_(), pos.m_123222_());
    }
}

