/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Camera;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.HitResult;
import net.optifine.EmissiveTextures;

/*
 * Exception performing whole class analysis ignored.
 */
public class BlockEntityRenderDispatcher
implements ResourceManagerReloadListener {
    private Map<BlockEntityType<?>, BlockEntityRenderer<?>> f_112251_ = ImmutableMap.of();
    private final Font f_112253_;
    private final EntityModelSet f_173556_;
    public Level f_112248_;
    public Camera f_112249_;
    public HitResult f_112250_;
    private final Supplier<BlockRenderDispatcher> f_173557_;
    public static BlockEntity tileEntityRendered;
    private BlockEntityRendererProvider.Context context;

    public BlockEntityRenderDispatcher(Font fontIn, EntityModelSet modelSetIn, Supplier<BlockRenderDispatcher> renderDispatcherIn) {
        this.f_112253_ = fontIn;
        this.f_173556_ = modelSetIn;
        this.f_173557_ = renderDispatcherIn;
    }

    @Nullable
    public <E extends BlockEntity> BlockEntityRenderer<E> m_112265_(E tileEntityIn) {
        return (BlockEntityRenderer)this.f_112251_.get(tileEntityIn.m_58903_());
    }

    public void m_173564_(Level worldIn, Camera cameraIn, HitResult hitResultIn) {
        if (this.f_112248_ != worldIn) {
            this.m_112257_(worldIn);
        }
        this.f_112249_ = cameraIn;
        this.f_112250_ = hitResultIn;
    }

    public <E extends BlockEntity> void m_112267_(E tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn) {
        BlockEntityRenderer blockentityrenderer = this.m_112265_(tileEntityIn);
        if (blockentityrenderer != null && tileEntityIn.m_58898_() && tileEntityIn.m_58903_().m_155262_(tileEntityIn.m_58900_()) && blockentityrenderer.m_142756_(tileEntityIn, this.f_112249_.m_90583_())) {
            BlockEntityRenderDispatcher.m_112278_(tileEntityIn, () -> BlockEntityRenderDispatcher.m_112284_((BlockEntityRenderer)blockentityrenderer, (BlockEntity)tileEntityIn, (float)partialTicks, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn));
        }
    }

    private static <T extends BlockEntity> void m_112284_(BlockEntityRenderer<T> rendererIn, T tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn) {
        Level level = tileEntityIn.m_58904_();
        int i2 = level != null ? LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)tileEntityIn.m_58899_()) : 0xF000F0;
        BlockEntity tileEntityRenderedPrev = tileEntityRendered;
        tileEntityRendered = tileEntityIn;
        if (EmissiveTextures.isActive()) {
            EmissiveTextures.beginRender();
        }
        rendererIn.m_6922_(tileEntityIn, partialTicks, matrixStackIn, bufferIn, i2, OverlayTexture.f_118083_);
        if (EmissiveTextures.isActive()) {
            if (EmissiveTextures.hasEmissive()) {
                EmissiveTextures.beginRenderEmissive();
                rendererIn.m_6922_(tileEntityIn, partialTicks, matrixStackIn, bufferIn, LightTexture.MAX_BRIGHTNESS, OverlayTexture.f_118083_);
                EmissiveTextures.endRenderEmissive();
            }
            EmissiveTextures.endRender();
        }
        tileEntityRendered = tileEntityRenderedPrev;
    }

    public <E extends BlockEntity> boolean m_112272_(E tileEntityIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockEntityRenderer blockentityrenderer = this.m_112265_(tileEntityIn);
        if (blockentityrenderer == null) {
            return true;
        }
        BlockEntityRenderDispatcher.m_112278_(tileEntityIn, () -> {
            BlockEntity tileEntityRenderedPrev = tileEntityRendered;
            tileEntityRendered = tileEntityIn;
            blockentityrenderer.m_6922_(tileEntityIn, 0.0f, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            tileEntityRendered = tileEntityRenderedPrev;
        });
        return false;
    }

    private static void m_112278_(BlockEntity tileEntityIn, Runnable runnableIn) {
        try {
            runnableIn.run();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering Block Entity");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block Entity Details");
            tileEntityIn.m_58886_(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    public void m_112257_(@Nullable Level worldIn) {
        this.f_112248_ = worldIn;
        if (worldIn == null) {
            this.f_112249_ = null;
        }
    }

    public void m_6213_(ResourceManager resourceManager) {
        BlockEntityRendererProvider.Context blockentityrendererprovider$context;
        this.context = blockentityrendererprovider$context = new BlockEntityRendererProvider.Context(this, (BlockRenderDispatcher)this.f_173557_.get(), this.f_173556_, this.f_112253_);
        this.f_112251_ = BlockEntityRenderers.m_173598_((BlockEntityRendererProvider.Context)blockentityrendererprovider$context);
    }

    public BlockEntityRenderer getRenderer(BlockEntityType type) {
        return (BlockEntityRenderer)this.f_112251_.get(type);
    }

    public BlockEntityRendererProvider.Context getContext() {
        return this.context;
    }

    public Map<BlockEntityType, BlockEntityRenderer> getBlockEntityRenderMap() {
        if (this.f_112251_ instanceof ImmutableMap) {
            this.f_112251_ = new HashMap(this.f_112251_);
        }
        return this.f_112251_;
    }

    public synchronized <T extends BlockEntity> void setSpecialRendererInternal(BlockEntityType<T> tileEntityType, BlockEntityRenderer<? super T> specialRenderer) {
        this.f_112251_.put(tileEntityType, specialRenderer);
    }
}

