/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.levelgen.DebugLevelSource;

class RenderChunk {
    private final Map<BlockPos, BlockEntity> f_200441_;
    @Nullable
    private final List<PalettedContainer<BlockState>> f_200442_;
    private final boolean f_200443_;
    private final LevelChunk f_200444_;

    RenderChunk(LevelChunk chunkIn) {
        this.f_200444_ = chunkIn;
        this.f_200443_ = chunkIn.m_62953_().m_46659_();
        this.f_200441_ = ImmutableMap.copyOf((Map)chunkIn.m_62954_());
        if (chunkIn instanceof EmptyLevelChunk) {
            this.f_200442_ = null;
        } else {
            LevelChunkSection[] alevelchunksection = chunkIn.m_7103_();
            this.f_200442_ = new ArrayList(alevelchunksection.length);
            for (LevelChunkSection levelchunksection : alevelchunksection) {
                this.f_200442_.add(levelchunksection.m_188008_() ? null : levelchunksection.m_63019_().m_199931_());
            }
        }
    }

    @Nullable
    public BlockEntity m_200451_(BlockPos posIn) {
        return (BlockEntity)this.f_200441_.get(posIn);
    }

    public BlockState m_200453_(BlockPos posIn) {
        int i2 = posIn.m_123341_();
        int j2 = posIn.m_123342_();
        int k2 = posIn.m_123343_();
        if (this.f_200443_) {
            BlockState blockstate = null;
            if (j2 == 60) {
                blockstate = Blocks.f_50375_.m_49966_();
            }
            if (j2 == 70) {
                blockstate = DebugLevelSource.m_64148_((int)i2, (int)k2);
            }
            return blockstate == null ? Blocks.f_50016_.m_49966_() : blockstate;
        }
        if (this.f_200442_ == null) {
            return Blocks.f_50016_.m_49966_();
        }
        try {
            PalettedContainer palettedcontainer;
            int l2 = this.f_200444_.m_151564_(j2);
            if (l2 >= 0 && l2 < this.f_200442_.size() && (palettedcontainer = (PalettedContainer)this.f_200442_.get(l2)) != null) {
                return (BlockState)palettedcontainer.m_63087_(i2 & 0xF, j2 & 0xF, k2 & 0xF);
            }
            return Blocks.f_50016_.m_49966_();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Getting block state");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being got");
            crashreportcategory.m_128165_("Location", () -> CrashReportCategory.m_178942_((LevelHeightAccessor)this.f_200444_, (int)i2, (int)j2, (int)k2));
            throw new ReportedException(crashreport);
        }
    }

    public LevelChunk getChunk() {
        return this.f_200444_;
    }
}

