/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.optifine.Config;
import net.optifine.DynamicLights;
import net.optifine.EmissiveTextures;
import net.optifine.player.PlayerItemsLayer;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorConstructor;
import net.optifine.reflect.ReflectorForge;
import net.optifine.reflect.ReflectorMethod;
import net.optifine.shaders.Shaders;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityRenderDispatcher
implements ResourceManagerReloadListener {
    private static final RenderType f_114361_ = RenderType.m_110485_((ResourceLocation)new ResourceLocation("textures/misc/shadow.png"));
    private Map<EntityType<?>, EntityRenderer<?>> f_114362_ = ImmutableMap.of();
    private Map<String, EntityRenderer<? extends Player>> f_114363_ = ImmutableMap.of();
    public final TextureManager f_114357_;
    private Level f_114366_;
    public Camera f_114358_;
    private Quaternion f_114367_;
    public Entity f_114359_;
    private final ItemRenderer f_173995_;
    private final Font f_114365_;
    public final Options f_114360_;
    private final EntityModelSet f_173996_;
    private boolean f_114368_ = true;
    private boolean f_114369_;
    private EntityRenderer entityRenderer = null;
    private Entity renderedEntity = null;
    private EntityRendererProvider.Context context = null;

    public <E extends Entity> int m_114394_(E entityIn, float partialTicks) {
        int combinedLight = this.m_114382_(entityIn).m_114505_(entityIn, partialTicks);
        if (Config.isDynamicLights()) {
            combinedLight = DynamicLights.getCombinedLight(entityIn, (int)combinedLight);
        }
        return combinedLight;
    }

    public EntityRenderDispatcher(TextureManager textureManagerIn, ItemRenderer itemRendererIn, Font fontIn, Options optionsIn, EntityModelSet entityModelsIn) {
        this.f_114357_ = textureManagerIn;
        this.f_173995_ = itemRendererIn;
        this.f_114365_ = fontIn;
        this.f_114360_ = optionsIn;
        this.f_173996_ = entityModelsIn;
    }

    public <T extends Entity> EntityRenderer<? super T> m_114382_(T entityIn) {
        if (entityIn instanceof AbstractClientPlayer) {
            String s = ((AbstractClientPlayer)entityIn).m_108564_();
            EntityRenderer entityrenderer = (EntityRenderer)this.f_114363_.get(s);
            return entityrenderer != null ? entityrenderer : (EntityRenderer)this.f_114363_.get("default");
        }
        return (EntityRenderer)this.f_114362_.get(entityIn.m_6095_());
    }

    public void m_114408_(Level worldIn, Camera activeRenderInfoIn, Entity entityIn) {
        this.f_114366_ = worldIn;
        this.f_114358_ = activeRenderInfoIn;
        this.f_114367_ = activeRenderInfoIn.m_90591_();
        this.f_114359_ = entityIn;
    }

    public void m_114412_(Quaternion quaternionIn) {
        this.f_114367_ = quaternionIn;
    }

    public void m_114468_(boolean renderShadowIn) {
        this.f_114368_ = renderShadowIn;
    }

    public void m_114473_(boolean debugBoundingBoxIn) {
        this.f_114369_ = debugBoundingBoxIn;
    }

    public boolean m_114377_() {
        return this.f_114369_;
    }

    public <E extends Entity> boolean m_114397_(E entityIn, Frustum frustumIn, double camX, double camY, double camZ) {
        EntityRenderer entityrenderer = this.m_114382_(entityIn);
        return entityrenderer.m_5523_(entityIn, frustumIn, camX, camY, camZ);
    }

    public <E extends Entity> void m_114384_(E entityIn, double xIn, double yIn, double zIn, float rotationYawIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (this.f_114358_ == null) {
            return;
        }
        EntityRenderer entityrenderer = this.m_114382_(entityIn);
        try {
            double d1;
            float f2;
            Vec3 vec3 = entityrenderer.m_7860_(entityIn, partialTicks);
            double d2 = xIn + vec3.m_7096_();
            double d3 = yIn + vec3.m_7098_();
            double d0 = zIn + vec3.m_7094_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(d2, d3, d0);
            EntityRenderer entityRendererPrev = this.entityRenderer;
            Entity renderedEntityPrev = this.renderedEntity;
            this.entityRenderer = entityrenderer;
            this.renderedEntity = entityIn;
            if (EmissiveTextures.isActive()) {
                EmissiveTextures.beginRender();
            }
            entityrenderer.m_7392_(entityIn, rotationYawIn, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            if (EmissiveTextures.isActive()) {
                if (EmissiveTextures.hasEmissive()) {
                    EmissiveTextures.beginRenderEmissive();
                    entityrenderer.m_7392_(entityIn, rotationYawIn, partialTicks, matrixStackIn, bufferIn, LightTexture.MAX_BRIGHTNESS);
                    EmissiveTextures.endRenderEmissive();
                }
                EmissiveTextures.endRender();
            }
            this.entityRenderer = entityRendererPrev;
            this.renderedEntity = renderedEntityPrev;
            if (entityIn.m_6051_()) {
                this.m_114453_(matrixStackIn, bufferIn, entityIn);
            }
            matrixStackIn.m_85837_(-vec3.m_7096_(), -vec3.m_7098_(), -vec3.m_7094_());
            if (this.f_114360_.f_92042_ && this.f_114368_ && entityrenderer.f_114477_ > 0.0f && !entityIn.m_20145_() && (f2 = (float)((1.0 - (d1 = this.m_114378_(entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20189_())) / 256.0) * (double)entityrenderer.f_114478_)) > 0.0f) {
                EntityRenderDispatcher.m_114457_((PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, entityIn, (float)f2, (float)partialTicks, (LevelReader)this.f_114366_, (float)entityrenderer.f_114477_);
            }
            if (this.f_114369_ && !entityIn.m_20145_() && !Minecraft.m_91087_().m_91299_()) {
                EntityRenderDispatcher.m_114441_((PoseStack)matrixStackIn, (VertexConsumer)bufferIn.m_6299_(RenderType.m_110504_()), entityIn, (float)partialTicks);
            }
            matrixStackIn.m_85849_();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering entity in world");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Entity being rendered");
            entityIn.m_7976_(crashreportcategory);
            CrashReportCategory crashreportcategory1 = crashreport.m_127514_("Renderer details");
            crashreportcategory1.m_128159_("Assigned renderer", (Object)entityrenderer);
            crashreportcategory1.m_128159_("Location", (Object)CrashReportCategory.m_178937_((LevelHeightAccessor)this.f_114366_, (double)xIn, (double)yIn, (double)zIn));
            crashreportcategory1.m_128159_("Rotation", (Object)Float.valueOf(rotationYawIn));
            crashreportcategory1.m_128159_("Delta", (Object)Float.valueOf(partialTicks));
            throw new ReportedException(crashreport);
        }
    }

    private static void m_114441_(PoseStack matrixStackIn, VertexConsumer bufferIn, Entity entityIn, float partialTicks) {
        if (Shaders.isShadowPass) {
            return;
        }
        AABB aabb = entityIn.m_142469_().m_82386_(-entityIn.m_20185_(), -entityIn.m_20186_(), -entityIn.m_20189_());
        LevelRenderer.m_109646_((PoseStack)matrixStackIn, (VertexConsumer)bufferIn, (AABB)aabb, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean multipart = entityIn instanceof EnderDragon;
        if (Reflector.IForgeEntity_isMultipartEntity.exists() && Reflector.IForgeEntity_getParts.exists()) {
            multipart = Reflector.callBoolean((Object)entityIn, (ReflectorMethod)Reflector.IForgeEntity_isMultipartEntity, (Object[])new Object[0]);
        }
        if (multipart) {
            EnderDragonPart[] parts;
            double d0 = -Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
            double d1 = -Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
            double d2 = -Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
            for (EnderDragonPart enderdragonpart : parts = Reflector.IForgeEntity_getParts.exists() ? (Entity[])Reflector.call((Object)entityIn, (ReflectorMethod)Reflector.IForgeEntity_getParts, (Object[])new Object[0]) : ((EnderDragon)entityIn).m_31156_()) {
                matrixStackIn.m_85836_();
                double d3 = d0 + Mth.m_14139_((double)partialTicks, (double)enderdragonpart.f_19790_, (double)enderdragonpart.m_20185_());
                double d4 = d1 + Mth.m_14139_((double)partialTicks, (double)enderdragonpart.f_19791_, (double)enderdragonpart.m_20186_());
                double d5 = d2 + Mth.m_14139_((double)partialTicks, (double)enderdragonpart.f_19792_, (double)enderdragonpart.m_20189_());
                matrixStackIn.m_85837_(d3, d4, d5);
                LevelRenderer.m_109646_((PoseStack)matrixStackIn, (VertexConsumer)bufferIn, (AABB)enderdragonpart.m_142469_().m_82386_(-enderdragonpart.m_20185_(), -enderdragonpart.m_20186_(), -enderdragonpart.m_20189_()), (float)0.25f, (float)1.0f, (float)0.0f, (float)1.0f);
                matrixStackIn.m_85849_();
            }
        }
        if (entityIn instanceof LivingEntity) {
            float f2 = 0.01f;
            LevelRenderer.m_109608_((PoseStack)matrixStackIn, (VertexConsumer)bufferIn, (double)aabb.f_82288_, (double)(entityIn.m_20192_() - 0.01f), (double)aabb.f_82290_, (double)aabb.f_82291_, (double)(entityIn.m_20192_() + 0.01f), (double)aabb.f_82293_, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        Vec3 vec3 = entityIn.m_20252_(partialTicks);
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
        Matrix3f matrix3f = matrixStackIn.m_85850_().m_85864_();
        bufferIn.m_85982_(matrix4f, 0.0f, entityIn.m_20192_(), 0.0f).m_6122_(0, 0, 255, 255).m_85977_(matrix3f, (float)vec3.f_82479_, (float)vec3.f_82480_, (float)vec3.f_82481_).m_5752_();
        bufferIn.m_85982_(matrix4f, (float)(vec3.f_82479_ * 2.0), (float)((double)entityIn.m_20192_() + vec3.f_82480_ * 2.0), (float)(vec3.f_82481_ * 2.0)).m_6122_(0, 0, 255, 255).m_85977_(matrix3f, (float)vec3.f_82479_, (float)vec3.f_82480_, (float)vec3.f_82481_).m_5752_();
    }

    private void m_114453_(PoseStack matrixStackIn, MultiBufferSource bufferIn, Entity entityIn) {
        TextureAtlasSprite textureatlassprite = ModelBakery.f_119219_.m_119204_();
        TextureAtlasSprite textureatlassprite1 = ModelBakery.f_119220_.m_119204_();
        matrixStackIn.m_85836_();
        float f2 = entityIn.m_20205_() * 1.4f;
        matrixStackIn.m_85841_(f2, f2, f2);
        float f1 = 0.5f;
        float f22 = 0.0f;
        float f3 = entityIn.m_20206_() / f2;
        float f4 = 0.0f;
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-this.f_114358_.m_90590_()));
        matrixStackIn.m_85837_(0.0, 0.0, (double)(-0.3f + (float)((int)f3) * 0.02f));
        float f5 = 0.0f;
        int i2 = 0;
        VertexConsumer vertexconsumer = bufferIn.m_6299_(Sheets.m_110790_());
        if (Config.isMultiTexture()) {
            vertexconsumer.setRenderBlocks(true);
        }
        PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
        while (f3 > 0.0f) {
            TextureAtlasSprite textureatlassprite2 = i2 % 2 == 0 ? textureatlassprite : textureatlassprite1;
            vertexconsumer.setSprite(textureatlassprite2);
            float f6 = textureatlassprite2.m_118409_();
            float f7 = textureatlassprite2.m_118411_();
            float f8 = textureatlassprite2.m_118410_();
            float f9 = textureatlassprite2.m_118412_();
            if (i2 / 2 % 2 == 0) {
                float f10 = f8;
                f8 = f6;
                f6 = f10;
            }
            EntityRenderDispatcher.m_114414_((PoseStack.Pose)posestack$pose, (VertexConsumer)vertexconsumer, (float)(f1 - 0.0f), (float)(0.0f - f4), (float)f5, (float)f8, (float)f9);
            EntityRenderDispatcher.m_114414_((PoseStack.Pose)posestack$pose, (VertexConsumer)vertexconsumer, (float)(-f1 - 0.0f), (float)(0.0f - f4), (float)f5, (float)f6, (float)f9);
            EntityRenderDispatcher.m_114414_((PoseStack.Pose)posestack$pose, (VertexConsumer)vertexconsumer, (float)(-f1 - 0.0f), (float)(1.4f - f4), (float)f5, (float)f6, (float)f7);
            EntityRenderDispatcher.m_114414_((PoseStack.Pose)posestack$pose, (VertexConsumer)vertexconsumer, (float)(f1 - 0.0f), (float)(1.4f - f4), (float)f5, (float)f8, (float)f7);
            f3 -= 0.45f;
            f4 -= 0.45f;
            f1 *= 0.9f;
            f5 += 0.03f;
            ++i2;
        }
        matrixStackIn.m_85849_();
    }

    private static void m_114414_(PoseStack.Pose matrixEntryIn, VertexConsumer bufferIn, float x, float y, float z, float texU, float texV) {
        bufferIn.m_85982_(matrixEntryIn.m_85861_(), x, y, z).m_6122_(255, 255, 255, 255).m_7421_(texU, texV).m_7122_(0, 10).m_85969_(240).m_85977_(matrixEntryIn.m_85864_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void m_114457_(PoseStack matrixStackIn, MultiBufferSource bufferIn, Entity entityIn, float weightIn, float partialTicks, LevelReader worldIn, float sizeIn) {
        Mob mob;
        if (Config.isShaders() && Shaders.shouldSkipDefaultShadow) {
            return;
        }
        float f2 = sizeIn;
        if (entityIn instanceof Mob && (mob = (Mob)entityIn).m_6162_()) {
            f2 = sizeIn * 0.5f;
        }
        double d2 = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
        double d0 = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
        double d1 = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
        int i2 = Mth.m_14107_((double)(d2 - (double)f2));
        int j2 = Mth.m_14107_((double)(d2 + (double)f2));
        int k2 = Mth.m_14107_((double)(d0 - (double)f2));
        int l2 = Mth.m_14107_((double)d0);
        int i1 = Mth.m_14107_((double)(d1 - (double)f2));
        int j1 = Mth.m_14107_((double)(d1 + (double)f2));
        PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
        VertexConsumer vertexconsumer = bufferIn.m_6299_(f_114361_);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)new BlockPos(i2, k2, i1), (BlockPos)new BlockPos(j2, l2, j1))) {
            EntityRenderDispatcher.m_114431_((PoseStack.Pose)posestack$pose, (VertexConsumer)vertexconsumer, (LevelReader)worldIn, (BlockPos)blockpos, (double)d2, (double)d0, (double)d1, (float)f2, (float)weightIn);
        }
    }

    private static void m_114431_(PoseStack.Pose matrixEntryIn, VertexConsumer bufferIn, LevelReader worldIn, BlockPos blockPosIn, double xIn, double yIn, double zIn, float sizeIn, float weightIn) {
        float f2;
        VoxelShape voxelshape;
        BlockPos blockpos = blockPosIn.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        if (blockstate.m_60799_() != RenderShape.INVISIBLE && worldIn.m_46803_(blockPosIn) > 3 && blockstate.m_60838_((BlockGetter)worldIn, blockpos) && !(voxelshape = blockstate.m_60808_((BlockGetter)worldIn, blockPosIn.m_7495_())).m_83281_() && (f2 = (float)(((double)weightIn - (yIn - (double)blockPosIn.m_123342_()) / 2.0) * 0.5 * (double)worldIn.m_46863_(blockPosIn))) >= 0.0f) {
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            AABB aabb = voxelshape.m_83215_();
            double d0 = (double)blockPosIn.m_123341_() + aabb.f_82288_;
            double d1 = (double)blockPosIn.m_123341_() + aabb.f_82291_;
            double d2 = (double)blockPosIn.m_123342_() + aabb.f_82289_;
            double d3 = (double)blockPosIn.m_123343_() + aabb.f_82290_;
            double d4 = (double)blockPosIn.m_123343_() + aabb.f_82293_;
            float f1 = (float)(d0 - xIn);
            float f22 = (float)(d1 - xIn);
            float f3 = (float)(d2 - yIn);
            float f4 = (float)(d3 - zIn);
            float f5 = (float)(d4 - zIn);
            float f6 = -f1 / 2.0f / sizeIn + 0.5f;
            float f7 = -f22 / 2.0f / sizeIn + 0.5f;
            float f8 = -f4 / 2.0f / sizeIn + 0.5f;
            float f9 = -f5 / 2.0f / sizeIn + 0.5f;
            EntityRenderDispatcher.m_114422_((PoseStack.Pose)matrixEntryIn, (VertexConsumer)bufferIn, (float)f2, (float)f1, (float)f3, (float)f4, (float)f6, (float)f8);
            EntityRenderDispatcher.m_114422_((PoseStack.Pose)matrixEntryIn, (VertexConsumer)bufferIn, (float)f2, (float)f1, (float)f3, (float)f5, (float)f6, (float)f9);
            EntityRenderDispatcher.m_114422_((PoseStack.Pose)matrixEntryIn, (VertexConsumer)bufferIn, (float)f2, (float)f22, (float)f3, (float)f5, (float)f7, (float)f9);
            EntityRenderDispatcher.m_114422_((PoseStack.Pose)matrixEntryIn, (VertexConsumer)bufferIn, (float)f2, (float)f22, (float)f3, (float)f4, (float)f7, (float)f8);
        }
    }

    private static void m_114422_(PoseStack.Pose matrixEntryIn, VertexConsumer bufferIn, float alphaIn, float xIn, float yIn, float zIn, float texU, float texV) {
        bufferIn.m_85982_(matrixEntryIn.m_85861_(), xIn, yIn, zIn).m_85950_(1.0f, 1.0f, 1.0f, alphaIn).m_7421_(texU, texV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(matrixEntryIn.m_85864_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public void m_114406_(@Nullable Level worldIn) {
        this.f_114366_ = worldIn;
        if (worldIn == null) {
            this.f_114358_ = null;
        }
    }

    public double m_114471_(Entity entityIn) {
        return this.f_114358_.m_90583_().m_82557_(entityIn.m_20182_());
    }

    public double m_114378_(double x, double y, double z) {
        return this.f_114358_.m_90583_().m_82531_(x, y, z);
    }

    public Quaternion m_114470_() {
        return this.f_114367_;
    }

    public void m_6213_(ResourceManager resourceManager) {
        EntityRendererProvider.Context entityrendererprovider$context;
        this.context = entityrendererprovider$context = new EntityRendererProvider.Context(this, this.f_173995_, resourceManager, this.f_173996_, this.f_114365_);
        this.f_114362_ = EntityRenderers.m_174049_((EntityRendererProvider.Context)entityrendererprovider$context);
        this.f_114363_ = EntityRenderers.m_174051_((EntityRendererProvider.Context)entityrendererprovider$context);
        EntityRenderDispatcher.registerPlayerItems((Map)this.f_114363_);
        ReflectorForge.postModLoaderEvent((ReflectorConstructor)Reflector.EntityRenderersEvent_AddLayers_Constructor, (Object[])new Object[]{this.f_114362_, this.f_114363_});
    }

    private static void registerPlayerItems(Map<String, EntityRenderer> renderPlayerMap) {
        boolean registered = false;
        for (EntityRenderer renderer : renderPlayerMap.values()) {
            if (!(renderer instanceof PlayerRenderer)) continue;
            PlayerRenderer renderPlayer = (PlayerRenderer)renderer;
            renderPlayer.removeLayers(PlayerItemsLayer.class);
            renderPlayer.m_115326_((RenderLayer)new PlayerItemsLayer(renderPlayer));
            registered = true;
        }
        if (!registered) {
            Config.warn((String)"PlayerItemsLayer not registered");
        }
    }

    public Map<EntityType, EntityRenderer> getEntityRenderMap() {
        if (this.f_114362_ instanceof ImmutableMap) {
            this.f_114362_ = new HashMap(this.f_114362_);
        }
        return this.f_114362_;
    }

    public EntityRendererProvider.Context getContext() {
        return this.context;
    }

    public Entity getRenderedEntity() {
        return this.renderedEntity;
    }

    public EntityRenderer getEntityRenderer() {
        return this.entityRenderer;
    }

    public void setRenderedEntity(Entity renderedEntity) {
        this.renderedEntity = renderedEntity;
    }

    public Map<String, EntityRenderer> getSkinMap() {
        return Collections.unmodifiableMap(this.f_114363_);
    }
}

