/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorConstructor;
import net.optifine.shaders.Shaders;

public class ItemFrameRenderer<T extends ItemFrame>
extends EntityRenderer<T> {
    private static final ModelResourceLocation f_115044_ = new ModelResourceLocation("item_frame", "map=false");
    private static final ModelResourceLocation f_115045_ = new ModelResourceLocation("item_frame", "map=true");
    private static final ModelResourceLocation f_174201_ = new ModelResourceLocation("glow_item_frame", "map=false");
    private static final ModelResourceLocation f_174202_ = new ModelResourceLocation("glow_item_frame", "map=true");
    public static final int f_174199_ = 5;
    public static final int f_174200_ = 30;
    private final Minecraft f_115046_ = Minecraft.m_91087_();
    private final ItemRenderer f_115047_;
    private static double itemRenderDistanceSq = 4096.0;
    private static boolean renderItemFrame = false;

    public ItemFrameRenderer(EntityRendererProvider.Context contextIn) {
        super(contextIn);
        this.f_115047_ = contextIn.m_174025_();
    }

    protected int m_6086_(T entityIn, BlockPos partialTicks) {
        return entityIn.m_6095_() == EntityType.f_147033_ ? Math.max(5, super.m_6086_(entityIn, partialTicks)) : super.m_6086_(entityIn, partialTicks);
    }

    public void m_7392_(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.m_85836_();
        Direction direction = entityIn.m_6350_();
        Vec3 vec3 = this.m_7860_(entityIn, partialTicks);
        matrixStackIn.m_85837_(-vec3.m_7096_(), -vec3.m_7098_(), -vec3.m_7094_());
        double d0 = 0.46875;
        matrixStackIn.m_85837_((double)direction.m_122429_() * 0.46875, (double)direction.m_122430_() * 0.46875, (double)direction.m_122431_() * 0.46875);
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(entityIn.m_146909_()));
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityIn.m_146908_()));
        boolean flag = entityIn.m_20145_();
        ItemStack itemstack = entityIn.m_31822_();
        if (!flag) {
            BlockRenderDispatcher blockrenderdispatcher = this.f_115046_.m_91289_();
            ModelManager modelmanager = blockrenderdispatcher.m_110907_().m_110881_();
            ModelResourceLocation modelresourcelocation = this.m_174212_(entityIn, itemstack);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(-0.5, -0.5, -0.5);
            blockrenderdispatcher.m_110937_().m_111067_(matrixStackIn.m_85850_(), bufferIn.m_6299_(Sheets.m_110789_()), (BlockState)null, modelmanager.m_119422_(modelresourcelocation), 1.0f, 1.0f, 1.0f, packedLightIn, OverlayTexture.f_118083_);
            matrixStackIn.m_85849_();
        }
        if (!itemstack.m_41619_()) {
            boolean flag1 = itemstack.m_41720_() instanceof MapItem;
            if (flag) {
                matrixStackIn.m_85837_(0.0, 0.0, 0.5);
            } else {
                matrixStackIn.m_85837_(0.0, 0.0, 0.4375);
            }
            int j2 = flag1 ? entityIn.m_31823_() % 4 * 2 : entityIn.m_31823_();
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_((float)j2 * 360.0f / 8.0f));
            if (!Reflector.postForgeBusEvent((ReflectorConstructor)Reflector.RenderItemInFrameEvent_Constructor, (Object[])new Object[]{entityIn, this, matrixStackIn, bufferIn, packedLightIn})) {
                if (flag1) {
                    matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                    float f2 = 0.0078125f;
                    matrixStackIn.m_85841_(0.0078125f, 0.0078125f, 0.0078125f);
                    matrixStackIn.m_85837_(-64.0, -64.0, 0.0);
                    Integer integer = MapItem.m_151131_((ItemStack)itemstack);
                    MapItemSavedData mapitemsaveddata = MapItem.m_151128_((Integer)integer, (Level)((ItemFrame)entityIn).f_19853_);
                    matrixStackIn.m_85837_(0.0, 0.0, -1.0);
                    if (mapitemsaveddata != null) {
                        int i2 = this.m_174208_(entityIn, 15728850, packedLightIn);
                        this.f_115046_.f_91063_.m_109151_().m_168771_(matrixStackIn, bufferIn, integer.intValue(), mapitemsaveddata, true, i2);
                    }
                } else {
                    int k2 = this.m_174208_(entityIn, 0xF000F0, packedLightIn);
                    matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
                    renderItemFrame = true;
                    if (this.isRenderItem(entityIn)) {
                        this.f_115047_.m_174269_(itemstack, ItemTransforms.TransformType.FIXED, k2, OverlayTexture.f_118083_, matrixStackIn, bufferIn, entityIn.m_142049_());
                    }
                    renderItemFrame = false;
                }
            }
        }
        matrixStackIn.m_85849_();
    }

    private int m_174208_(T itemFrameIn, int lightGlowIn, int lightIn) {
        return itemFrameIn.m_6095_() == EntityType.f_147033_ ? lightGlowIn : lightIn;
    }

    private ModelResourceLocation m_174212_(T itemFrameIn, ItemStack itemStackIn) {
        boolean flag;
        boolean bl = flag = itemFrameIn.m_6095_() == EntityType.f_147033_;
        if (itemStackIn.m_41720_() instanceof MapItem) {
            return flag ? f_174202_ : f_115045_;
        }
        return flag ? f_174201_ : f_115044_;
    }

    public Vec3 m_7860_(T entityIn, float partialTicks) {
        return new Vec3((double)((float)entityIn.m_6350_().m_122429_() * 0.3f), -0.25, (double)((float)entityIn.m_6350_().m_122431_() * 0.3f));
    }

    public ResourceLocation m_5478_(T entity) {
        return TextureAtlas.f_118259_;
    }

    protected boolean m_6512_(T entity) {
        if (Minecraft.m_91404_() && !entity.m_31822_().m_41619_() && entity.m_31822_().m_41788_() && this.f_114476_.f_114359_ == entity) {
            double d0 = this.f_114476_.m_114471_(entity);
            float f2 = entity.m_20163_() ? 32.0f : 64.0f;
            return d0 < (double)(f2 * f2);
        }
        return false;
    }

    protected void m_7649_(T entityIn, Component displayNameIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7649_(entityIn, entityIn.m_31822_().m_41786_(), matrixStackIn, bufferIn, packedLightIn);
    }

    private boolean isRenderItem(ItemFrame itemFrame) {
        Entity viewEntity;
        double distSq;
        if (Shaders.isShadowPass) {
            return false;
        }
        return Config.zoomMode || !((distSq = itemFrame.m_20275_((viewEntity = this.f_115046_.m_91288_()).m_20185_(), viewEntity.m_20186_(), viewEntity.m_20189_())) > itemRenderDistanceSq);
    }

    public static void updateItemRenderDistance() {
        Minecraft mc = Minecraft.m_91087_();
        double fov = Config.limit((double)mc.f_91066_.f_92068_, (double)1.0, (double)120.0);
        double itemRenderDistance = Math.max(6.0 * (double)mc.m_91268_().m_85444_() / fov, 16.0);
        itemRenderDistanceSq = itemRenderDistance * itemRenderDistance;
    }

    public static boolean isRenderItemFrame() {
        return renderItemFrame;
    }
}

