/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.RenderProperties;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.CustomItems;
import net.optifine.EmissiveTextures;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorConstructor;
import net.optifine.reflect.ReflectorMethod;
import net.optifine.render.VertexBuilderWrapper;
import net.optifine.shaders.Shaders;

/*
 * Exception performing whole class analysis ignored.
 */
public class ItemRenderer
implements ResourceManagerReloadListener {
    public static final ResourceLocation f_115092_ = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final Set<Item> f_115094_ = Sets.newHashSet((Object[])new Item[]{Items.f_41852_});
    private static final int f_174221_ = 8;
    private static final int f_174222_ = 8;
    public static final int f_174218_ = 200;
    public static final float f_174219_ = 0.5f;
    public static final float f_174220_ = 0.75f;
    public float f_115093_;
    private final ItemModelShaper f_115095_;
    private final TextureManager f_115096_;
    private final ItemColors f_115097_;
    private final BlockEntityWithoutLevelRenderer f_174223_;
    public ModelManager modelManager = null;
    private static boolean renderItemGui = false;

    public ItemRenderer(TextureManager textureManagerIn, ModelManager modelManagerIn, ItemColors itemColorsIn, BlockEntityWithoutLevelRenderer blockEntityRendererIn) {
        this.f_115096_ = textureManagerIn;
        this.modelManager = modelManagerIn;
        this.f_115095_ = Reflector.ItemModelMesherForge_Constructor.exists() ? (ItemModelShaper)Reflector.newInstance((ReflectorConstructor)Reflector.ItemModelMesherForge_Constructor, (Object[])new Object[]{this.modelManager}) : new ItemModelShaper(modelManagerIn);
        this.f_174223_ = blockEntityRendererIn;
        for (Item item : Registry.f_122827_) {
            if (f_115094_.contains(item)) continue;
            this.f_115095_.m_109396_(item, new ModelResourceLocation(Registry.f_122827_.m_7981_((Object)item), "inventory"));
        }
        this.f_115097_ = itemColorsIn;
    }

    public ItemModelShaper m_115103_() {
        return this.f_115095_;
    }

    public void m_115189_(BakedModel modelIn, ItemStack stack, int combinedLightIn, int combinedOverlayIn, PoseStack matrixStackIn, VertexConsumer bufferIn) {
        if (Config.isMultiTexture()) {
            bufferIn.setRenderBlocks(true);
        }
        Random random = new Random();
        long i2 = 42L;
        for (Direction direction : Direction.f_122346_) {
            random.setSeed(42L);
            this.m_115162_(matrixStackIn, bufferIn, modelIn.m_6840_((BlockState)null, direction, random), stack, combinedLightIn, combinedOverlayIn);
        }
        random.setSeed(42L);
        this.m_115162_(matrixStackIn, bufferIn, modelIn.m_6840_((BlockState)null, (Direction)null, random), stack, combinedLightIn, combinedOverlayIn);
    }

    public void m_115143_(ItemStack itemStackIn, ItemTransforms.TransformType transformTypeIn, boolean leftHand, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BakedModel modelIn) {
        if (!itemStackIn.m_41619_()) {
            boolean flag;
            matrixStackIn.m_85836_();
            boolean bl = flag = transformTypeIn == ItemTransforms.TransformType.GUI || transformTypeIn == ItemTransforms.TransformType.GROUND || transformTypeIn == ItemTransforms.TransformType.FIXED;
            if (flag) {
                if (itemStackIn.m_150930_(Items.f_42713_)) {
                    modelIn = this.f_115095_.m_109393_().m_119422_(new ModelResourceLocation("minecraft:trident#inventory"));
                } else if (itemStackIn.m_150930_(Items.f_151059_)) {
                    modelIn = this.f_115095_.m_109393_().m_119422_(new ModelResourceLocation("minecraft:spyglass#inventory"));
                }
            }
            if (Reflector.ForgeHooksClient_handleCameraTransforms.exists()) {
                modelIn = (BakedModel)Reflector.ForgeHooksClient_handleCameraTransforms.call(new Object[]{matrixStackIn, modelIn, transformTypeIn, leftHand});
            } else {
                modelIn.m_7442_().m_111808_(transformTypeIn).m_111763_(leftHand, matrixStackIn);
            }
            matrixStackIn.m_85837_(-0.5, -0.5, -0.5);
            if (!(modelIn.m_7521_() || itemStackIn.m_150930_(Items.f_42713_) && !flag)) {
                Block block;
                boolean flag1 = transformTypeIn != ItemTransforms.TransformType.GUI && !transformTypeIn.m_111841_() && itemStackIn.m_41720_() instanceof BlockItem ? !((block = ((BlockItem)itemStackIn.m_41720_()).m_40614_()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                if (modelIn.isLayered()) {
                    Reflector.ForgeHooksClient_drawItemLayered.call(new Object[]{this, modelIn, itemStackIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, flag1});
                } else {
                    VertexConsumer vertexconsumer;
                    RenderType rendertype = ItemBlockRenderTypes.m_109279_((ItemStack)itemStackIn, (boolean)flag1);
                    if (itemStackIn.m_150930_(Items.f_42522_) && itemStackIn.m_41790_()) {
                        matrixStackIn.m_85836_();
                        PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
                        if (transformTypeIn == ItemTransforms.TransformType.GUI) {
                            posestack$pose.m_85861_().m_27630_(0.5f);
                        } else if (transformTypeIn.m_111841_()) {
                            posestack$pose.m_85861_().m_27630_(0.75f);
                        }
                        vertexconsumer = flag1 ? ItemRenderer.m_115207_((MultiBufferSource)bufferIn, (RenderType)rendertype, (PoseStack.Pose)posestack$pose) : ItemRenderer.m_115180_((MultiBufferSource)bufferIn, (RenderType)rendertype, (PoseStack.Pose)posestack$pose);
                        matrixStackIn.m_85849_();
                    } else {
                        vertexconsumer = flag1 ? ItemRenderer.m_115222_((MultiBufferSource)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.m_41790_()) : ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.m_41790_());
                    }
                    if (Config.isCustomItems()) {
                        modelIn = CustomItems.getCustomItemModel((ItemStack)itemStackIn, (BakedModel)modelIn, (ResourceLocation)ItemOverrides.lastModelLocation, (boolean)false);
                        ItemOverrides.lastModelLocation = null;
                    }
                    if (EmissiveTextures.isActive()) {
                        EmissiveTextures.beginRender();
                    }
                    this.m_115189_(modelIn, itemStackIn, combinedLightIn, combinedOverlayIn, matrixStackIn, vertexconsumer);
                    if (EmissiveTextures.isActive()) {
                        if (EmissiveTextures.hasEmissive()) {
                            EmissiveTextures.beginRenderEmissive();
                            VertexConsumer vertexBuilderEmissive = vertexconsumer instanceof VertexBuilderWrapper ? ((VertexBuilderWrapper)vertexconsumer).getVertexBuilder() : vertexconsumer;
                            this.m_115189_(modelIn, itemStackIn, LightTexture.MAX_BRIGHTNESS, combinedOverlayIn, matrixStackIn, vertexBuilderEmissive);
                            EmissiveTextures.endRenderEmissive();
                        }
                        EmissiveTextures.endRender();
                    }
                }
            } else if (Reflector.MinecraftForgeClient.exists()) {
                RenderProperties.get((ItemStack)itemStackIn).getItemStackRenderer().m_108829_(itemStackIn, transformTypeIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            } else {
                this.f_174223_.m_108829_(itemStackIn, transformTypeIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            }
            matrixStackIn.m_85849_();
        }
    }

    public static VertexConsumer m_115184_(MultiBufferSource bufferIn, RenderType renderTypeIn, boolean isItemIn, boolean hasEffectIn) {
        if (Shaders.isShadowPass) {
            hasEffectIn = false;
        }
        if (EmissiveTextures.isRenderEmissive()) {
            hasEffectIn = false;
        }
        return hasEffectIn ? VertexMultiConsumer.m_86168_((VertexConsumer)bufferIn.m_6299_(isItemIn ? RenderType.m_110481_() : RenderType.m_110484_()), (VertexConsumer)bufferIn.m_6299_(renderTypeIn)) : bufferIn.m_6299_(renderTypeIn);
    }

    public static VertexConsumer m_115180_(MultiBufferSource bufferIn, RenderType renderTypeIn, PoseStack.Pose entryIn) {
        return VertexMultiConsumer.m_86168_((VertexConsumer)new SheetedDecalTextureGenerator(bufferIn.m_6299_(RenderType.m_110490_()), entryIn.m_85861_(), entryIn.m_85864_()), (VertexConsumer)bufferIn.m_6299_(renderTypeIn));
    }

    public static VertexConsumer m_115207_(MultiBufferSource bufferIn, RenderType renderTypeIn, PoseStack.Pose entryIn) {
        return VertexMultiConsumer.m_86168_((VertexConsumer)new SheetedDecalTextureGenerator(bufferIn.m_6299_(RenderType.m_110493_()), entryIn.m_85861_(), entryIn.m_85864_()), (VertexConsumer)bufferIn.m_6299_(renderTypeIn));
    }

    public static VertexConsumer m_115211_(MultiBufferSource bufferIn, RenderType renderTypeIn, boolean isItemIn, boolean glintIn) {
        if (Shaders.isShadowPass) {
            glintIn = false;
        }
        if (EmissiveTextures.isRenderEmissive()) {
            glintIn = false;
        }
        if (glintIn) {
            return Minecraft.m_91085_() && renderTypeIn == Sheets.m_110791_() ? VertexMultiConsumer.m_86168_((VertexConsumer)bufferIn.m_6299_(RenderType.m_110487_()), (VertexConsumer)bufferIn.m_6299_(renderTypeIn)) : VertexMultiConsumer.m_86168_((VertexConsumer)bufferIn.m_6299_(isItemIn ? RenderType.m_110490_() : RenderType.m_110496_()), (VertexConsumer)bufferIn.m_6299_(renderTypeIn));
        }
        return bufferIn.m_6299_(renderTypeIn);
    }

    public static VertexConsumer m_115222_(MultiBufferSource bufferIn, RenderType renderTypeIn, boolean isItemIn, boolean hasEffectIn) {
        if (Shaders.isShadowPass) {
            hasEffectIn = false;
        }
        if (EmissiveTextures.isRenderEmissive()) {
            hasEffectIn = false;
        }
        return hasEffectIn ? VertexMultiConsumer.m_86168_((VertexConsumer)bufferIn.m_6299_(isItemIn ? RenderType.m_110493_() : RenderType.m_110499_()), (VertexConsumer)bufferIn.m_6299_(renderTypeIn)) : bufferIn.m_6299_(renderTypeIn);
    }

    private void m_115162_(PoseStack matrixStackIn, VertexConsumer bufferIn, List<BakedQuad> quadsIn, ItemStack itemStackIn, int combinedLightIn, int combinedOverlayIn) {
        boolean flag = !itemStackIn.m_41619_();
        PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
        boolean emissiveActive = EmissiveTextures.isActive();
        int listSize = quadsIn.size();
        int baseColorMul = listSize > 0 && Config.isCustomColors() ? CustomColors.getColorFromItemStack((ItemStack)itemStackIn, (int)-1, (int)-1) : -1;
        for (int ix = 0; ix < listSize; ++ix) {
            BakedQuad bakedquad = quadsIn.get(ix);
            if (emissiveActive && (bakedquad = EmissiveTextures.getEmissiveQuad((BakedQuad)bakedquad)) == null) continue;
            int i2 = baseColorMul;
            if (flag && bakedquad.m_111304_()) {
                i2 = this.f_115097_.m_92676_(itemStackIn, bakedquad.m_111305_());
                if (Config.isCustomColors()) {
                    i2 = CustomColors.getColorFromItemStack((ItemStack)itemStackIn, (int)bakedquad.m_111305_(), (int)i2);
                }
            }
            float f2 = (float)(i2 >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i2 >> 8 & 0xFF) / 255.0f;
            float f22 = (float)(i2 & 0xFF) / 255.0f;
            if (Reflector.ForgeHooksClient.exists()) {
                bufferIn.putBulkData(posestack$pose, bakedquad, f2, f1, f22, combinedLightIn, combinedOverlayIn, true);
                continue;
            }
            bufferIn.m_85987_(posestack$pose, bakedquad, f2, f1, f22, combinedLightIn, combinedOverlayIn);
        }
    }

    public BakedModel m_174264_(ItemStack stack, @Nullable Level worldIn, @Nullable LivingEntity entityIn, int seedIn) {
        BakedModel bakedmodel = stack.m_150930_(Items.f_42713_) ? this.f_115095_.m_109393_().m_119422_(new ModelResourceLocation("minecraft:trident_in_hand#inventory")) : (stack.m_150930_(Items.f_151059_) ? this.f_115095_.m_109393_().m_119422_(new ModelResourceLocation("minecraft:spyglass_in_hand#inventory")) : this.f_115095_.m_109406_(stack));
        ClientLevel clientlevel = worldIn instanceof ClientLevel ? (ClientLevel)worldIn : null;
        ItemOverrides.lastModelLocation = null;
        BakedModel bakedmodel1 = bakedmodel.m_7343_().m_173464_(bakedmodel, stack, clientlevel, entityIn, seedIn);
        if (Config.isCustomItems()) {
            bakedmodel1 = CustomItems.getCustomItemModel((ItemStack)stack, (BakedModel)bakedmodel1, (ResourceLocation)ItemOverrides.lastModelLocation, (boolean)true);
        }
        return bakedmodel1 == null ? this.f_115095_.m_109393_().m_119409_() : bakedmodel1;
    }

    public void m_174269_(ItemStack itemStackIn, ItemTransforms.TransformType transformTypeIn, int combinedLightIn, int combinedOverlayIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int seedIn) {
        this.m_174242_((LivingEntity)null, itemStackIn, transformTypeIn, false, matrixStackIn, bufferIn, (Level)null, combinedLightIn, combinedOverlayIn, seedIn);
    }

    public void m_174242_(@Nullable LivingEntity livingEntityIn, ItemStack itemStackIn, ItemTransforms.TransformType transformTypeIn, boolean leftHand, PoseStack matrixStackIn, MultiBufferSource bufferIn, @Nullable Level worldIn, int combinedLightIn, int combinedOverlayIn, int seedIn) {
        if (!itemStackIn.m_41619_()) {
            BakedModel bakedmodel = this.m_174264_(itemStackIn, worldIn, livingEntityIn, seedIn);
            this.m_115143_(itemStackIn, transformTypeIn, leftHand, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, bakedmodel);
        }
    }

    public void m_115123_(ItemStack stack, int x, int y) {
        this.m_115127_(stack, x, y, this.m_174264_(stack, (Level)null, (LivingEntity)null, 0));
    }

    protected void m_115127_(ItemStack stack, int x, int y, BakedModel bakedmodel) {
        boolean flag;
        renderItemGui = true;
        this.f_115096_.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)x, (double)y, (double)(100.0f + this.f_115093_));
        posestack.m_85837_(8.0, 8.0, 0.0);
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        PoseStack posestack1 = new PoseStack();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !bakedmodel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        this.m_115143_(stack, ItemTransforms.TransformType.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
        multibuffersource$buffersource.m_109911_();
        RenderSystem.m_69482_();
        if (flag) {
            Lighting.m_84931_();
        }
        posestack.m_85849_();
        RenderSystem.m_157182_();
        renderItemGui = false;
    }

    public void m_115203_(ItemStack stack, int xPosition, int yPosition) {
        this.m_174277_((LivingEntity)Minecraft.m_91087_().f_91074_, stack, xPosition, yPosition, 0);
    }

    public void m_174253_(ItemStack stack, int x, int y, int seedIn) {
        this.m_174277_((LivingEntity)Minecraft.m_91087_().f_91074_, stack, x, y, seedIn);
    }

    public void m_174258_(ItemStack itemIn, int x, int y, int seedIn, int zLevelIn) {
        this.m_174235_((LivingEntity)Minecraft.m_91087_().f_91074_, itemIn, x, y, seedIn, zLevelIn);
    }

    public void m_115218_(ItemStack itemIn, int x, int y) {
        this.m_174277_((LivingEntity)null, itemIn, x, y, 0);
    }

    public void m_174229_(LivingEntity entityIn, ItemStack itemIn, int x, int y, int seedIn) {
        this.m_174277_(entityIn, itemIn, x, y, seedIn);
    }

    private void m_174277_(@Nullable LivingEntity entityIn, ItemStack itemIn, int x, int y, int seedIn) {
        this.m_174235_(entityIn, itemIn, x, y, seedIn, 0);
    }

    private void m_174235_(@Nullable LivingEntity entityIn, ItemStack itemIn, int x, int y, int seedIn, int zLevelIn) {
        if (!itemIn.m_41619_()) {
            BakedModel bakedmodel = this.m_174264_(itemIn, (Level)null, entityIn, seedIn);
            this.f_115093_ = bakedmodel.m_7539_() ? this.f_115093_ + 50.0f + (float)zLevelIn : this.f_115093_ + 50.0f;
            try {
                this.m_115127_(itemIn, x, y, bakedmodel);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Item being rendered");
                crashreportcategory.m_128165_("Item Type", () -> String.valueOf(itemIn.m_41720_()));
                crashreportcategory.m_128165_("Registry Name", () -> String.valueOf(Reflector.call((Object)itemIn.m_41720_(), (ReflectorMethod)Reflector.ForgeRegistryEntry_getRegistryName, (Object[])new Object[0])));
                crashreportcategory.m_128165_("Item Damage", () -> String.valueOf(itemIn.m_41773_()));
                crashreportcategory.m_128165_("Item NBT", () -> String.valueOf(itemIn.m_41783_()));
                crashreportcategory.m_128165_("Item Foil", () -> String.valueOf(itemIn.m_41790_()));
                throw new ReportedException(crashreport);
            }
            this.f_115093_ = bakedmodel.m_7539_() ? this.f_115093_ - 50.0f - (float)zLevelIn : this.f_115093_ - 50.0f;
        }
    }

    public void m_115169_(Font fr, ItemStack stack, int xPosition, int yPosition) {
        this.m_115174_(fr, stack, xPosition, yPosition, (String)null);
    }

    public void m_115174_(Font fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text) {
        if (!stack.m_41619_()) {
            LocalPlayer localplayer;
            float f2;
            PoseStack posestack = new PoseStack();
            if (stack.m_41613_() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.m_41613_()) : text;
                posestack.m_85837_(0.0, 0.0, (double)(this.f_115093_ + 200.0f));
                MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                fr.m_92811_(s, (float)(xPosition + 19 - 2 - fr.m_92895_(s)), (float)(yPosition + 6 + 3), 0xFFFFFF, true, posestack.m_85850_().m_85861_(), (MultiBufferSource)multibuffersource$buffersource, false, 0, 0xF000F0);
                multibuffersource$buffersource.m_109911_();
            }
            if (stack.m_150947_()) {
                RenderSystem.m_69465_();
                RenderSystem.m_69472_();
                RenderSystem.m_69461_();
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                int i2 = stack.m_150948_();
                int j2 = stack.m_150949_();
                if (Config.isCustomColors()) {
                    float dmg = stack.m_41773_();
                    float maxDmg = stack.m_41776_();
                    float durability = Math.max(0.0f, (maxDmg - dmg) / maxDmg);
                    j2 = CustomColors.getDurabilityColor((float)durability, (int)j2);
                }
                this.m_115152_(bufferbuilder, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                this.m_115152_(bufferbuilder, xPosition + 2, yPosition + 13, i2, 1, j2 >> 16 & 0xFF, j2 >> 8 & 0xFF, j2 & 0xFF, 255);
                RenderSystem.m_69478_();
                RenderSystem.m_69493_();
                RenderSystem.m_69482_();
            }
            float f3 = f2 = (localplayer = Minecraft.m_91087_().f_91074_) == null ? 0.0f : localplayer.m_36335_().m_41521_(stack.m_41720_(), Minecraft.m_91087_().m_91296_());
            if (f2 > 0.0f) {
                RenderSystem.m_69465_();
                RenderSystem.m_69472_();
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                Tesselator tesselator1 = Tesselator.m_85913_();
                BufferBuilder bufferbuilder1 = tesselator1.m_85915_();
                this.m_115152_(bufferbuilder1, xPosition, yPosition + Mth.m_14143_((float)(16.0f * (1.0f - f2))), 16, Mth.m_14167_((float)(16.0f * f2)), 255, 255, 255, 127);
                RenderSystem.m_69493_();
                RenderSystem.m_69482_();
            }
        }
    }

    private void m_115152_(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        renderer.m_5483_((double)(x + 0), (double)(y + 0), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)(x + 0), (double)(y + height), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)(x + width), (double)(y + 0), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)renderer);
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.f_115095_.m_109403_();
    }

    public static boolean isRenderItemGui() {
        return renderItemGui;
    }

    public BlockEntityWithoutLevelRenderer getBlockEntityRenderer() {
        return this.f_174223_;
    }
}

