/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.multipart.MultiPart;
import net.minecraft.client.renderer.blockentity.BellRenderer;
import net.minecraft.client.renderer.blockentity.ConduitRenderer;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorMethod;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModelBakery {
    public static final Material f_119219_ = new Material(TextureAtlas.f_118259_, new ResourceLocation("block/fire_0"));
    public static final Material f_119220_ = new Material(TextureAtlas.f_118259_, new ResourceLocation("block/fire_1"));
    public static final Material f_119221_ = new Material(TextureAtlas.f_118259_, new ResourceLocation("block/lava_flow"));
    public static final Material f_119222_ = new Material(TextureAtlas.f_118259_, new ResourceLocation("block/water_flow"));
    public static final Material f_119223_ = new Material(TextureAtlas.f_118259_, new ResourceLocation("block/water_overlay"));
    public static final Material f_119224_ = new Material(TextureAtlas.f_118259_, new ResourceLocation("entity/banner_base"));
    public static final Material f_119225_ = new Material(TextureAtlas.f_118259_, new ResourceLocation("entity/shield_base"));
    public static final Material f_119226_ = new Material(TextureAtlas.f_118259_, new ResourceLocation("entity/shield_base_nopattern"));
    public static final int f_174875_ = 10;
    public static final List<ResourceLocation> f_119227_ = IntStream.range(0, 10).mapToObj(indexIn -> new ResourceLocation("block/destroy_stage_" + indexIn)).collect(Collectors.toList());
    public static final List<ResourceLocation> f_119228_ = f_119227_.stream().map(locationIn -> new ResourceLocation("textures/" + locationIn.m_135815_() + ".png")).collect(Collectors.toList());
    public static final List<RenderType> f_119229_ = f_119228_.stream().map(RenderType::m_110494_).collect(Collectors.toList());
    private static final Set<Material> f_119234_ = (Set)Util.m_137469_((Object)Sets.newHashSet(), setIn -> {
        setIn.add(f_119222_);
        setIn.add(f_119221_);
        setIn.add(f_119223_);
        setIn.add(f_119219_);
        setIn.add(f_119220_);
        setIn.add(BellRenderer.f_112227_);
        setIn.add(ConduitRenderer.f_112378_);
        setIn.add(ConduitRenderer.f_112379_);
        setIn.add(ConduitRenderer.f_112380_);
        setIn.add(ConduitRenderer.f_112381_);
        setIn.add(ConduitRenderer.f_112382_);
        setIn.add(ConduitRenderer.f_112383_);
        setIn.add(EnchantTableRenderer.f_112405_);
        setIn.add(f_119224_);
        setIn.add(f_119225_);
        setIn.add(f_119226_);
        for (ResourceLocation resourcelocation : f_119227_) {
            setIn.add(new Material(TextureAtlas.f_118259_, resourcelocation));
        }
        setIn.add(new Material(TextureAtlas.f_118259_, InventoryMenu.f_39693_));
        setIn.add(new Material(TextureAtlas.f_118259_, InventoryMenu.f_39694_));
        setIn.add(new Material(TextureAtlas.f_118259_, InventoryMenu.f_39695_));
        setIn.add(new Material(TextureAtlas.f_118259_, InventoryMenu.f_39696_));
        setIn.add(new Material(TextureAtlas.f_118259_, InventoryMenu.f_39697_));
        Sheets.m_110780_(setIn::add);
    });
    static final int f_174876_ = -1;
    private static final int f_174877_ = 0;
    private static final Logger f_119235_ = LogUtils.getLogger();
    private static final String f_174878_ = "builtin/";
    private static final String f_174879_ = "builtin/generated";
    private static final String f_174880_ = "builtin/entity";
    private static final String f_174881_ = "missing";
    public static final ModelResourceLocation f_119230_ = new ModelResourceLocation("builtin/missing", "missing");
    private static final String f_119236_ = f_119230_.toString();
    @VisibleForTesting
    public static final String f_119231_ = ("{    'textures': {       'particle': '" + MissingTextureAtlasSprite.m_118071_().m_135815_() + "',       'missingno': '" + MissingTextureAtlasSprite.m_118071_().m_135815_() + "'    },    'elements': [         {  'from': [ 0, 0, 0 ],            'to': [ 16, 16, 16 ],            'faces': {                'down':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'down',  'texture': '#missingno' },                'up':    { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'up',    'texture': '#missingno' },                'north': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'north', 'texture': '#missingno' },                'south': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'south', 'texture': '#missingno' },                'west':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'west',  'texture': '#missingno' },                'east':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'east',  'texture': '#missingno' }            }        }    ]}").replace('\'', '\"');
    private static final Map<String, String> f_119237_ = Maps.newHashMap((Map)ImmutableMap.of((Object)"missing", (Object)f_119231_));
    private static final Splitter f_119238_ = Splitter.on((char)',');
    private static final Splitter f_119239_ = Splitter.on((char)'=').limit(2);
    public static final BlockModel f_119232_ = (BlockModel)Util.m_137469_((Object)BlockModel.m_111463_((String)"{\"gui_light\": \"front\"}"), modelIn -> {
        modelIn.f_111416_ = "generation marker";
    });
    public static final BlockModel f_119233_ = (BlockModel)Util.m_137469_((Object)BlockModel.m_111463_((String)"{\"gui_light\": \"side\"}"), modelIn -> {
        modelIn.f_111416_ = "block entity marker";
    });
    private static final StateDefinition<Block, BlockState> f_119240_ = new StateDefinition.Builder((Object)Blocks.f_50016_).m_61104_(new Property[]{BooleanProperty.m_61465_((String)"map")}).m_61101_(Block::m_49966_, BlockState::new);
    private static final ItemModelGenerator f_119241_ = new ItemModelGenerator();
    private static final Map<ResourceLocation, StateDefinition<Block, BlockState>> f_119242_ = ImmutableMap.of((Object)new ResourceLocation("item_frame"), (Object)f_119240_, (Object)new ResourceLocation("glow_item_frame"), (Object)f_119240_);
    private final ResourceManager f_119243_;
    @Nullable
    private AtlasSet f_119244_;
    private final BlockColors f_119209_;
    private final Set<ResourceLocation> f_119210_ = Sets.newHashSet();
    private final BlockModelDefinition.Context f_119211_ = new BlockModelDefinition.Context();
    private final Map<ResourceLocation, UnbakedModel> f_119212_ = Maps.newHashMap();
    private final Map<Triple<ResourceLocation, Transformation, Boolean>, BakedModel> f_119213_ = Maps.newHashMap();
    private final Map<ResourceLocation, UnbakedModel> f_119214_ = Maps.newHashMap();
    private final Map<ResourceLocation, BakedModel> f_119215_ = Maps.newHashMap();
    private Map<ResourceLocation, Pair<TextureAtlas, TextureAtlas.Preparations>> f_119216_;
    private int f_119217_ = 1;
    private final Object2IntMap<BlockState> f_119218_ = (Object2IntMap)Util.m_137469_((Object)new Object2IntOpenHashMap(), mapIn -> mapIn.defaultReturnValue(-1));
    public Map<ResourceLocation, UnbakedModel> mapUnbakedModels;

    public ModelBakery(ResourceManager resourceManagerIn, BlockColors blockColorsIn, ProfilerFiller profilerIn, int maxMipmapLevel) {
        this(resourceManagerIn, blockColorsIn, true);
        this.processLoading(profilerIn, maxMipmapLevel);
    }

    protected ModelBakery(ResourceManager resourceManagerIn, BlockColors blockColorsIn, boolean vanillaBakery) {
        this.f_119243_ = resourceManagerIn;
        this.f_119209_ = blockColorsIn;
    }

    protected void processLoading(ProfilerFiller profilerIn, int maxMipmapLevel) {
        Reflector.ModelLoaderRegistry_onModelLoadingStart.callVoid(new Object[0]);
        profilerIn.m_6180_("missing_model");
        try {
            this.f_119212_.put(f_119230_, this.m_119364_((ResourceLocation)f_119230_));
            this.m_119306_(f_119230_);
        }
        catch (IOException ioexception) {
            f_119235_.error("Error loading missing model, should never happen :(", (Throwable)ioexception);
            throw new RuntimeException(ioexception);
        }
        profilerIn.m_6182_("static_definitions");
        f_119242_.forEach((locationIn, definitionIn) -> definitionIn.m_61056_().forEach(stateIn -> this.m_119306_(BlockModelShaper.m_110889_((ResourceLocation)locationIn, (BlockState)stateIn))));
        profilerIn.m_6182_("blocks");
        for (Block block : Registry.f_122824_) {
            block.m_49965_().m_61056_().forEach(stateIn -> this.m_119306_(BlockModelShaper.m_110895_((BlockState)stateIn)));
        }
        profilerIn.m_6182_("items");
        for (ResourceLocation resourcelocation : Registry.f_122827_.m_6566_()) {
            this.m_119306_(new ModelResourceLocation(resourcelocation, "inventory"));
        }
        profilerIn.m_6182_("special");
        this.m_119306_(new ModelResourceLocation("minecraft:trident_in_hand#inventory"));
        this.m_119306_(new ModelResourceLocation("minecraft:spyglass_in_hand#inventory"));
        for (ResourceLocation rl : this.getSpecialModels()) {
            this.addModelToCache(rl);
        }
        profilerIn.m_6182_("textures");
        this.mapUnbakedModels = this.f_119212_;
        TextureUtils.registerCustomModels((ModelBakery)this);
        LinkedHashSet set = Sets.newLinkedHashSet();
        Set set1 = this.f_119214_.values().stream().flatMap(modelIn -> modelIn.m_5500_(arg_0 -> this.m_119341_(arg_0), set).stream()).collect(Collectors.toSet());
        set1.addAll(f_119234_);
        Reflector.call((ReflectorMethod)Reflector.ForgeHooksClient_gatherFluidTextures, (Object[])new Object[]{set1});
        set.stream().filter(pairIn -> !((String)pairIn.getSecond()).equals(f_119236_)).forEach(pairIn -> f_119235_.warn("Unable to resolve texture reference: {} in {}", pairIn.getFirst(), pairIn.getSecond()));
        Map<ResourceLocation, List<Material>> map = set1.stream().collect(Collectors.groupingBy(Material::m_119193_));
        profilerIn.m_6182_("stitching");
        this.f_119216_ = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, List<Material>> entry : map.entrySet()) {
            TextureAtlas textureatlas = new TextureAtlas(entry.getKey());
            TextureAtlas.Preparations textureatlas$preparations = textureatlas.m_118307_(this.f_119243_, entry.getValue().stream().map(Material::m_119203_), profilerIn, maxMipmapLevel);
            this.f_119216_.put(entry.getKey(), Pair.of((Object)textureatlas, (Object)textureatlas$preparations));
        }
        profilerIn.m_7238_();
    }

    public AtlasSet m_119298_(TextureManager resourceManagerIn, ProfilerFiller profilerIn) {
        profilerIn.m_6180_("atlas");
        for (Pair pair : this.f_119216_.values()) {
            TextureAtlas textureatlas = (TextureAtlas)pair.getFirst();
            TextureAtlas.Preparations textureatlas$preparations = (TextureAtlas.Preparations)pair.getSecond();
            textureatlas.m_118312_(textureatlas$preparations);
            resourceManagerIn.m_118495_(textureatlas.m_118330_(), (AbstractTexture)textureatlas);
            resourceManagerIn.m_174784_(textureatlas.m_118330_());
            textureatlas.m_118322_(textureatlas$preparations);
        }
        this.f_119244_ = new AtlasSet((Collection)this.f_119216_.values().stream().map(Pair::getFirst).collect(Collectors.toList()));
        profilerIn.m_6182_("baking");
        this.f_119214_.keySet().forEach(locationIn -> {
            BakedModel bakedmodel = null;
            try {
                bakedmodel = this.m_119349_(locationIn, (ModelState)BlockModelRotation.X0_Y0);
            }
            catch (Exception exception) {
                f_119235_.warn("Unable to bake model: '{}': {}", locationIn, (Object)exception);
            }
            if (bakedmodel != null) {
                this.f_119215_.put(locationIn, bakedmodel);
            }
        });
        profilerIn.m_7238_();
        return this.f_119244_;
    }

    private static Predicate<BlockState> m_119273_(StateDefinition<Block, BlockState> containerIn, String variantIn) {
        HashMap map = Maps.newHashMap();
        for (String s : f_119238_.split((CharSequence)variantIn)) {
            Iterator iterator = f_119239_.split((CharSequence)s).iterator();
            if (!iterator.hasNext()) continue;
            String s1 = (String)iterator.next();
            Property property = containerIn.m_61081_(s1);
            if (property != null && iterator.hasNext()) {
                String s2 = (String)iterator.next();
                Comparable comparable = ModelBakery.m_119276_((Property)property, (String)s2);
                if (comparable == null) {
                    throw new RuntimeException("Unknown value: '" + s2 + "' for blockstate property: '" + s1 + "' " + property.m_6908_());
                }
                map.put(property, comparable);
                continue;
            }
            if (s1.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + s1 + "'");
        }
        Block block = (Block)containerIn.m_61091_();
        return stateIn -> {
            if (stateIn != null && stateIn.m_60713_(block)) {
                for (Map.Entry entry : map.entrySet()) {
                    if (Objects.equals(stateIn.m_61143_((Property)entry.getKey()), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    @Nullable
    static <T extends Comparable<T>> T m_119276_(Property<T> property, String value) {
        return (T)property.m_6215_(value).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnbakedModel m_119341_(ResourceLocation modelLocation) {
        if (this.f_119212_.containsKey(modelLocation)) {
            return (UnbakedModel)this.f_119212_.get(modelLocation);
        }
        if (this.f_119210_.contains(modelLocation)) {
            throw new IllegalStateException("Circular reference while loading " + modelLocation);
        }
        this.f_119210_.add(modelLocation);
        UnbakedModel unbakedmodel = (UnbakedModel)this.f_119212_.get(f_119230_);
        while (!this.f_119210_.isEmpty()) {
            ResourceLocation resourcelocation = (ResourceLocation)this.f_119210_.iterator().next();
            try {
                if (this.f_119212_.containsKey(resourcelocation)) continue;
                this.m_119362_(resourcelocation);
            }
            catch (BlockStateDefinitionException modelbakery$blockstatedefinitionexception) {
                f_119235_.warn(modelbakery$blockstatedefinitionexception.getMessage());
                this.f_119212_.put(resourcelocation, unbakedmodel);
            }
            catch (Exception exception) {
                f_119235_.warn("Unable to load model: '{}' referenced from: {}: {}", (Object)resourcelocation, (Object)modelLocation);
                f_119235_.warn(exception.getClass().getName() + ": " + exception.getMessage());
                this.f_119212_.put(resourcelocation, unbakedmodel);
            }
            finally {
                this.f_119210_.remove(resourcelocation);
            }
        }
        return this.f_119212_.getOrDefault(modelLocation, unbakedmodel);
    }

    private void m_119362_(ResourceLocation blockstateLocation) throws Exception {
        if (!(blockstateLocation instanceof ModelResourceLocation)) {
            this.m_119352_(blockstateLocation, (UnbakedModel)this.m_119364_(blockstateLocation));
        } else {
            ModelResourceLocation modelresourcelocation = (ModelResourceLocation)blockstateLocation;
            if (Objects.equals(modelresourcelocation.m_119448_(), "inventory")) {
                ResourceLocation resourcelocation2 = new ResourceLocation(blockstateLocation.m_135827_(), "item/" + blockstateLocation.m_135815_());
                String path = blockstateLocation.m_135815_();
                if (path.startsWith("optifine/") || path.startsWith("item/")) {
                    resourcelocation2 = blockstateLocation;
                }
                BlockModel blockmodel = this.m_119364_(resourcelocation2);
                this.m_119352_((ResourceLocation)modelresourcelocation, (UnbakedModel)blockmodel);
                this.f_119212_.put(resourcelocation2, blockmodel);
            } else {
                ResourceLocation resourcelocation = new ResourceLocation(blockstateLocation.m_135827_(), blockstateLocation.m_135815_());
                StateDefinition statedefinition = Optional.ofNullable((StateDefinition)f_119242_.get(resourcelocation)).orElseGet(() -> ((Block)Registry.f_122824_.m_7745_(resourcelocation)).m_49965_());
                this.f_119211_.m_111552_(statedefinition);
                ImmutableList list = ImmutableList.copyOf((Collection)this.f_119209_.m_92575_((Block)statedefinition.m_61091_()));
                ImmutableList immutablelist = statedefinition.m_61056_();
                HashMap map = Maps.newHashMap();
                immutablelist.forEach(stateIn -> map.put(BlockModelShaper.m_110889_((ResourceLocation)resourcelocation, (BlockState)stateIn), stateIn));
                HashMap map1 = Maps.newHashMap();
                ResourceLocation resourcelocation1 = new ResourceLocation(blockstateLocation.m_135827_(), "blockstates/" + blockstateLocation.m_135815_() + ".json");
                UnbakedModel unbakedmodel = (UnbakedModel)this.f_119212_.get(f_119230_);
                ModelGroupKey modelbakery$modelgroupkey = new ModelGroupKey((List)ImmutableList.of((Object)unbakedmodel), (List)ImmutableList.of());
                Pair pair = Pair.of((Object)unbakedmodel, () -> modelbakery$modelgroupkey);
                try {
                    List list1;
                    try {
                        list1 = this.f_119243_.m_7396_(resourcelocation1).stream().map(resourceIn -> {
                            try {
                                Pair pair2;
                                try (InputStream inputstream = resourceIn.m_6679_();){
                                    pair2 = Pair.of((Object)resourceIn.m_7816_(), (Object)BlockModelDefinition.m_111540_((BlockModelDefinition.Context)this.f_119211_, (Reader)new InputStreamReader(inputstream, StandardCharsets.UTF_8)));
                                }
                                return pair2;
                            }
                            catch (Exception exception1) {
                                throw new BlockStateDefinitionException(String.format("Exception loading blockstate definition: '%s' in resourcepack: '%s': %s", resourceIn.m_7843_(), resourceIn.m_7816_(), exception1.getMessage()));
                            }
                        }).collect(Collectors.toList());
                    }
                    catch (IOException ioexception) {
                        f_119235_.warn("Exception loading blockstate definition: {}: {}", (Object)resourcelocation1, (Object)ioexception);
                        HashMap map3 = Maps.newHashMap();
                        map.forEach((locationIn, stateIn) -> {
                            Pair pair2 = (Pair)map1.get(stateIn);
                            if (pair2 == null) {
                                f_119235_.warn("Exception loading blockstate definition: '{}' missing model for variant: '{}'", (Object)resourcelocation1, locationIn);
                                pair2 = pair;
                            }
                            this.m_119352_((ResourceLocation)locationIn, (UnbakedModel)pair2.getFirst());
                            try {
                                ModelGroupKey modelbakery$modelgroupkey1 = (ModelGroupKey)((Supplier)pair2.getSecond()).get();
                                map3.computeIfAbsent(modelbakery$modelgroupkey1, keyIn -> Sets.newIdentityHashSet()).add(stateIn);
                            }
                            catch (Exception exception1) {
                                f_119235_.warn("Exception evaluating model definition: '{}'", locationIn, (Object)exception1);
                            }
                        });
                        map3.forEach((keyIn, setIn) -> {
                            Iterator iterator = setIn.iterator();
                            while (iterator.hasNext()) {
                                BlockState blockstate = (BlockState)iterator.next();
                                if (blockstate.m_60799_() == RenderShape.MODEL) continue;
                                iterator.remove();
                                this.f_119218_.put((Object)blockstate, 0);
                            }
                            if (setIn.size() > 1) {
                                this.m_119310_((Iterable)setIn);
                            }
                        });
                        return;
                    }
                    for (Pair pair1 : list1) {
                        MultiPart multipart;
                        BlockModelDefinition blockmodeldefinition = (BlockModelDefinition)pair1.getSecond();
                        IdentityHashMap map2 = Maps.newIdentityHashMap();
                        if (blockmodeldefinition.m_111543_()) {
                            multipart = blockmodeldefinition.m_111544_();
                            immutablelist.forEach(arg_0 -> ModelBakery.lambda$loadBlockstate$19(map2, multipart, (List)list, arg_0));
                        } else {
                            multipart = null;
                        }
                        blockmodeldefinition.m_111539_().forEach((arg_0, arg_1) -> ModelBakery.lambda$loadBlockstate$23(immutablelist, statedefinition, map2, (List)list, multipart, pair, blockmodeldefinition, resourcelocation1, pair1, arg_0, arg_1));
                        map1.putAll(map2);
                    }
                }
                catch (BlockStateDefinitionException modelbakery$blockstatedefinitionexception) {
                    throw modelbakery$blockstatedefinitionexception;
                }
                catch (Exception exception) {
                    throw new BlockStateDefinitionException(String.format("Exception loading blockstate definition: '%s': %s", resourcelocation1, exception));
                }
                finally {
                    HashMap map3 = Maps.newHashMap();
                    map.forEach((locationIn, stateIn) -> {
                        Pair pair2 = (Pair)map1.get(stateIn);
                        if (pair2 == null) {
                            f_119235_.warn("Exception loading blockstate definition: '{}' missing model for variant: '{}'", (Object)resourcelocation1, locationIn);
                            pair2 = pair;
                        }
                        this.m_119352_((ResourceLocation)locationIn, (UnbakedModel)pair2.getFirst());
                        try {
                            ModelGroupKey modelbakery$modelgroupkey1 = (ModelGroupKey)((Supplier)pair2.getSecond()).get();
                            map3.computeIfAbsent(modelbakery$modelgroupkey1, keyIn -> Sets.newIdentityHashSet()).add(stateIn);
                        }
                        catch (Exception exception1) {
                            f_119235_.warn("Exception evaluating model definition: '{}'", locationIn, (Object)exception1);
                        }
                    });
                    map3.forEach((keyIn, setIn) -> {
                        Iterator iterator = setIn.iterator();
                        while (iterator.hasNext()) {
                            BlockState blockstate = (BlockState)iterator.next();
                            if (blockstate.m_60799_() == RenderShape.MODEL) continue;
                            iterator.remove();
                            this.f_119218_.put((Object)blockstate, 0);
                        }
                        if (setIn.size() > 1) {
                            this.m_119310_((Iterable)setIn);
                        }
                    });
                }
            }
        }
    }

    private void m_119352_(ResourceLocation locationIn, UnbakedModel modelIn) {
        this.f_119212_.put(locationIn, modelIn);
        this.f_119210_.addAll(modelIn.m_7970_());
    }

    private void addModelToCache(ResourceLocation locationIn) {
        UnbakedModel iunbakedmodel = this.m_119341_(locationIn);
        this.f_119212_.put(locationIn, iunbakedmodel);
        this.f_119214_.put(locationIn, iunbakedmodel);
    }

    public void m_119306_(ModelResourceLocation locationIn) {
        UnbakedModel unbakedmodel = this.m_119341_((ResourceLocation)locationIn);
        this.f_119212_.put(locationIn, unbakedmodel);
        this.f_119214_.put(locationIn, unbakedmodel);
    }

    private void m_119310_(Iterable<BlockState> blockStatesIn) {
        int i2 = this.f_119217_++;
        blockStatesIn.forEach(stateIn -> this.f_119218_.put(stateIn, i2));
    }

    @Nullable
    public BakedModel m_119349_(ResourceLocation locationIn, ModelState transformIn) {
        return this.bake(locationIn, transformIn, arg_0 -> ((AtlasSet)this.f_119244_).m_117971_(arg_0));
    }

    public BakedModel bake(ResourceLocation locationIn, ModelState transformIn, Function<Material, TextureAtlasSprite> textureGetter) {
        BlockModel blockmodel;
        Triple triple = Triple.of((Object)locationIn, (Object)transformIn.m_6189_(), (Object)transformIn.m_7538_());
        if (this.f_119213_.containsKey(triple)) {
            return (BakedModel)this.f_119213_.get(triple);
        }
        if (this.f_119244_ == null) {
            throw new IllegalStateException("bake called too early");
        }
        UnbakedModel unbakedmodel = this.m_119341_(locationIn);
        if (unbakedmodel instanceof BlockModel && (blockmodel = (BlockModel)unbakedmodel).m_111490_() == f_119232_) {
            if (Reflector.ForgeHooksClient.exists()) {
                return f_119241_.m_111670_(textureGetter, blockmodel).m_111449_(this, blockmodel, textureGetter, transformIn, locationIn, false);
            }
            return f_119241_.m_111670_(arg_0 -> ((AtlasSet)this.f_119244_).m_117971_(arg_0), blockmodel).m_111449_(this, blockmodel, arg_0 -> ((AtlasSet)this.f_119244_).m_117971_(arg_0), transformIn, locationIn, false);
        }
        BakedModel bakedmodel = unbakedmodel.m_7611_(this, arg_0 -> ((AtlasSet)this.f_119244_).m_117971_(arg_0), transformIn, locationIn);
        if (Reflector.ForgeHooksClient.exists()) {
            bakedmodel = unbakedmodel.m_7611_(this, textureGetter, transformIn, locationIn);
        }
        this.f_119213_.put(triple, bakedmodel);
        return bakedmodel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockModel m_119364_(ResourceLocation location) throws IOException {
        BlockModel blockmodel;
        Resource resource;
        Reader reader;
        block8: {
            ResourceLocation locationFile;
            String s;
            block9: {
                reader = null;
                resource = null;
                s = location.m_135815_();
                locationFile = location;
                if ("builtin/generated".equals(s)) break block8;
                if (!"builtin/entity".equals(s)) break block9;
                BlockModel blockModel = f_119233_;
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(resource);
                return blockModel;
            }
            if (s.startsWith("builtin/")) {
                String s2 = s.substring("builtin/".length());
                String s1 = (String)f_119237_.get(s2);
                if (s1 == null) {
                    throw new FileNotFoundException(location.toString());
                }
                reader = new StringReader(s1);
            } else {
                locationFile = this.getModelLocation(location);
                resource = this.f_119243_.m_142591_(locationFile);
                reader = new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8);
            }
            BlockModel blockmodel2 = BlockModel.m_111461_((Reader)reader);
            blockmodel2.f_111416_ = location.toString();
            String basePath = TextureUtils.getBasePath((String)locationFile.m_135815_());
            ModelBakery.fixModelLocations((BlockModel)blockmodel2, (String)basePath);
            BlockModel blockModel = blockmodel2;
            IOUtils.closeQuietly((Reader)reader);
            IOUtils.closeQuietly((Closeable)resource);
            return blockModel;
        }
        try {
            blockmodel = f_119232_;
        }
        finally {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(resource);
        }
        return blockmodel;
    }

    public Map<ResourceLocation, BakedModel> m_119251_() {
        return this.f_119215_;
    }

    public Object2IntMap<BlockState> m_119355_() {
        return this.f_119218_;
    }

    private ResourceLocation getModelLocation(ResourceLocation location) {
        String path = location.m_135815_();
        if (path.startsWith("optifine/")) {
            if (!path.endsWith(".json")) {
                location = new ResourceLocation(location.m_135827_(), path + ".json");
            }
            return location;
        }
        return new ResourceLocation(location.m_135827_(), "models/" + location.m_135815_() + ".json");
    }

    public static void fixModelLocations(BlockModel modelBlock, String basePath) {
        ResourceLocation parentLocFixed = ModelBakery.fixModelLocation((ResourceLocation)FaceBakery.getParentLocation((BlockModel)modelBlock), (String)basePath);
        if (parentLocFixed != FaceBakery.getParentLocation((BlockModel)modelBlock)) {
            FaceBakery.setParentLocation((BlockModel)modelBlock, (ResourceLocation)parentLocFixed);
        }
        if (FaceBakery.getTextures((BlockModel)modelBlock) != null) {
            for (Map.Entry entry : FaceBakery.getTextures((BlockModel)modelBlock).entrySet()) {
                Material material;
                ResourceLocation textureLocation;
                String path;
                String pathFixed;
                Either value = (Either)entry.getValue();
                Optional optionalMaterial = value.left();
                if (!optionalMaterial.isPresent() || (pathFixed = ModelBakery.fixResourcePath((String)(path = (textureLocation = (material = (Material)optionalMaterial.get()).m_119203_()).m_135815_()), (String)basePath)).equals(path)) continue;
                ResourceLocation textureLocationFixed = new ResourceLocation(textureLocation.m_135827_(), pathFixed);
                Material materialFixed = new Material(material.m_119193_(), textureLocationFixed);
                Either valueFixed = Either.left((Object)materialFixed);
                entry.setValue(valueFixed);
            }
        }
    }

    public static ResourceLocation fixModelLocation(ResourceLocation loc, String basePath) {
        if (loc == null || basePath == null) {
            return loc;
        }
        if (!loc.m_135827_().equals("minecraft")) {
            return loc;
        }
        String path = loc.m_135815_();
        String pathFixed = ModelBakery.fixResourcePath((String)path, (String)basePath);
        if (pathFixed != path) {
            loc = new ResourceLocation(loc.m_135827_(), pathFixed);
        }
        return loc;
    }

    private static String fixResourcePath(String path, String basePath) {
        path = TextureUtils.fixResourcePath((String)path, (String)basePath);
        path = StrUtils.removeSuffix((String)path, (String)".json");
        path = StrUtils.removeSuffix((String)path, (String)".png");
        return path;
    }

    public Set<ResourceLocation> getSpecialModels() {
        return Collections.emptySet();
    }

    public AtlasSet getSpriteMap() {
        return this.f_119244_;
    }

    private static /* synthetic */ void lambda$loadBlockstate$23(ImmutableList immutablelist, StateDefinition statedefinition, Map map2, List list, MultiPart multipart, Pair pair, BlockModelDefinition blockmodeldefinition, ResourceLocation resourcelocation1, Pair pair1, String keyIn, MultiVariant variantIn) {
        try {
            immutablelist.stream().filter(ModelBakery.m_119273_((StateDefinition)statedefinition, (String)keyIn)).forEach(stateIn -> {
                Pair pair2 = map2.put(stateIn, Pair.of((Object)variantIn, () -> ModelGroupKey.m_119383_((BlockState)stateIn, (UnbakedModel)variantIn, (Collection)list)));
                if (pair2 != null && pair2.getFirst() != multipart) {
                    map2.put(stateIn, pair);
                    throw new RuntimeException("Overlapping definition with: " + (String)blockmodeldefinition.m_111539_().entrySet().stream().filter(entityIn -> entityIn.getValue() == pair2.getFirst()).findFirst().get().getKey());
                }
            });
        }
        catch (Exception exception1) {
            f_119235_.warn("Exception loading blockstate definition: '{}' in resourcepack: '{}' for variant: '{}': {}", new Object[]{resourcelocation1, pair1.getFirst(), keyIn, exception1.getMessage()});
        }
    }

    private static /* synthetic */ void lambda$loadBlockstate$19(Map map2, MultiPart multipart, List list, BlockState stateIn) {
        map2.put(stateIn, Pair.of((Object)multipart, () -> ModelGroupKey.m_119379_((BlockState)stateIn, (MultiPart)multipart, (Collection)list)));
    }
}

