/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.optifine.util.BiomeUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class SynchedEntityData {
    private static final Logger f_135342_ = LogUtils.getLogger();
    private static final Object2IntMap<Class<? extends Entity>> f_135343_ = new Object2IntOpenHashMap();
    private static final int f_179842_ = 255;
    private static final int f_179843_ = 254;
    private final Entity f_135344_;
    private final Int2ObjectMap<DataItem<?>> f_135345_ = new Int2ObjectOpenHashMap();
    private final ReadWriteLock f_135346_ = new ReentrantReadWriteLock();
    private boolean f_135347_ = true;
    private boolean f_135348_;
    public Biome spawnBiome = BiomeUtils.PLAINS;
    public BlockPos spawnPosition = BlockPos.f_121853_;

    public SynchedEntityData(Entity entityIn) {
        this.f_135344_ = entityIn;
    }

    public static <T> EntityDataAccessor<T> m_135353_(Class<? extends Entity> clazz, EntityDataSerializer<T> serializer) {
        int j2;
        if (f_135342_.isDebugEnabled()) {
            try {
                Class<?> oclass = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!oclass.equals(clazz)) {
                    f_135342_.debug("defineId called for: {} from {}", new Object[]{clazz, oclass, new RuntimeException()});
                }
            }
            catch (ClassNotFoundException oclass) {
                // empty catch block
            }
        }
        if (f_135343_.containsKey(clazz)) {
            j2 = f_135343_.getInt(clazz) + 1;
        } else {
            int i2 = 0;
            Class<? extends Entity> oclass1 = clazz;
            while (oclass1 != Entity.class) {
                if (!f_135343_.containsKey(oclass1 = oclass1.getSuperclass())) continue;
                i2 = f_135343_.getInt(oclass1) + 1;
                break;
            }
            j2 = i2;
        }
        if (j2 > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + j2 + "! (Max is 254)");
        }
        f_135343_.put(clazz, j2);
        return serializer.m_135021_(j2);
    }

    public <T> void m_135372_(EntityDataAccessor<T> key, T value) {
        int i2 = key.m_135015_();
        if (i2 > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i2 + "! (Max is 254)");
        }
        if (this.f_135345_.containsKey(i2)) {
            throw new IllegalArgumentException("Duplicate id value for " + i2 + "!");
        }
        if (EntityDataSerializers.m_135052_((EntityDataSerializer)key.m_135016_()) < 0) {
            throw new IllegalArgumentException("Unregistered serializer " + key.m_135016_() + " for " + i2 + "!");
        }
        this.m_135385_(key, value);
    }

    private <T> void m_135385_(EntityDataAccessor<T> key, T value) {
        DataItem dataitem = new DataItem(key, value);
        this.f_135346_.writeLock().lock();
        this.f_135345_.put(key.m_135015_(), (Object)dataitem);
        this.f_135347_ = false;
        this.f_135346_.writeLock().unlock();
    }

    private <T> DataItem<T> m_135379_(EntityDataAccessor<T> key) {
        DataItem dataitem;
        this.f_135346_.readLock().lock();
        try {
            dataitem = (DataItem)this.f_135345_.get(key.m_135015_());
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Getting synched entity data");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Synched entity data");
            crashreportcategory.m_128159_("Data ID", key);
            throw new ReportedException(crashreport);
        }
        finally {
            this.f_135346_.readLock().unlock();
        }
        return dataitem;
    }

    public <T> T m_135370_(EntityDataAccessor<T> key) {
        return (T)this.m_135379_(key).m_135403_();
    }

    public <T> void m_135381_(EntityDataAccessor<T> key, T value) {
        DataItem dataitem = this.m_135379_(key);
        if (ObjectUtils.notEqual(value, (Object)dataitem.m_135403_())) {
            dataitem.m_135397_(value);
            this.f_135344_.m_7350_(key);
            dataitem.m_135401_(true);
            this.f_135348_ = true;
        }
    }

    public boolean m_135352_() {
        return this.f_135348_;
    }

    public static void m_135358_(@Nullable List<DataItem<?>> entriesIn, FriendlyByteBuf buf) {
        if (entriesIn != null) {
            for (DataItem<?> dataitem : entriesIn) {
                SynchedEntityData.m_135367_((FriendlyByteBuf)buf, dataitem);
            }
        }
        buf.writeByte(255);
    }

    @Nullable
    public List<DataItem<?>> m_135378_() {
        ArrayList list = null;
        if (this.f_135348_) {
            this.f_135346_.readLock().lock();
            for (DataItem dataitem : this.f_135345_.values()) {
                if (!dataitem.m_135406_()) continue;
                dataitem.m_135401_(false);
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(dataitem.m_135407_());
            }
            this.f_135346_.readLock().unlock();
        }
        this.f_135348_ = false;
        return list;
    }

    @Nullable
    public List<DataItem<?>> m_135384_() {
        ArrayList list = null;
        this.f_135346_.readLock().lock();
        for (DataItem dataitem : this.f_135345_.values()) {
            if (list == null) {
                list = Lists.newArrayList();
            }
            list.add(dataitem.m_135407_());
        }
        this.f_135346_.readLock().unlock();
        return list;
    }

    private static <T> void m_135367_(FriendlyByteBuf buf, DataItem<T> entry) {
        EntityDataAccessor entitydataaccessor = entry.m_135396_();
        int i2 = EntityDataSerializers.m_135052_((EntityDataSerializer)entitydataaccessor.m_135016_());
        if (i2 < 0) {
            throw new EncoderException("Unknown serializer type " + entitydataaccessor.m_135016_());
        }
        buf.writeByte(entitydataaccessor.m_135015_());
        buf.m_130130_(i2);
        entitydataaccessor.m_135016_().m_6856_(buf, entry.m_135403_());
    }

    @Nullable
    public static List<DataItem<?>> m_135361_(FriendlyByteBuf buf) {
        short i2;
        ArrayList list = null;
        while ((i2 = buf.readUnsignedByte()) != 255) {
            int j2;
            EntityDataSerializer entitydataserializer;
            if (list == null) {
                list = Lists.newArrayList();
            }
            if ((entitydataserializer = EntityDataSerializers.m_135048_((int)(j2 = buf.m_130242_()))) == null) {
                throw new DecoderException("Unknown serializer type " + j2);
            }
            list.add(SynchedEntityData.m_135363_((FriendlyByteBuf)buf, (int)i2, (EntityDataSerializer)entitydataserializer));
        }
        return list;
    }

    private static <T> DataItem<T> m_135363_(FriendlyByteBuf bufferIn, int idIn, EntityDataSerializer<T> serializerIn) {
        return new DataItem(serializerIn.m_135021_(idIn), serializerIn.m_6709_(bufferIn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_135356_(List<DataItem<?>> entriesIn) {
        this.f_135346_.writeLock().lock();
        try {
            for (DataItem<?> dataitem : entriesIn) {
                DataItem dataitem1 = (DataItem)this.f_135345_.get(dataitem.m_135396_().m_135015_());
                if (dataitem1 == null) continue;
                this.m_135375_(dataitem1, dataitem);
                this.f_135344_.m_7350_(dataitem.m_135396_());
            }
        }
        finally {
            this.f_135346_.writeLock().unlock();
        }
        this.f_135348_ = true;
    }

    private <T> void m_135375_(DataItem<T> target, DataItem<?> source) {
        if (!Objects.equals(source.f_135390_.m_135016_(), target.f_135390_.m_135016_())) {
            throw new IllegalStateException(String.format("Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", target.f_135390_.m_135015_(), this.f_135344_, target.f_135391_, target.f_135391_.getClass(), source.f_135391_, source.f_135391_.getClass()));
        }
        target.m_135397_(source.m_135403_());
    }

    public boolean m_135388_() {
        return this.f_135347_;
    }

    public void m_135389_() {
        this.f_135348_ = false;
        this.f_135346_.readLock().lock();
        for (DataItem dataitem : this.f_135345_.values()) {
            dataitem.m_135401_(false);
        }
        this.f_135346_.readLock().unlock();
    }
}

