/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskPriorityQueue;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorConstructor;
import net.optifine.reflect.ReflectorField;
import net.optifine.reflect.ReflectorMethod;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChunkMap
extends ChunkStorage
implements ChunkHolder.PlayerProvider {
    private static final byte f_143034_ = -1;
    private static final byte f_143035_ = 0;
    private static final byte f_143036_ = 1;
    private static final Logger f_140128_ = LogUtils.getLogger();
    private static final int f_143037_ = 200;
    private static final int f_198789_ = 20;
    private static final int f_202982_ = 10000;
    private static final int f_143038_ = 3;
    public static final int f_143032_ = 33;
    public static final int f_140127_ = 65 + ChunkStatus.m_62421_();
    public static final int f_143033_ = 31;
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> f_140129_ = new Long2ObjectLinkedOpenHashMap();
    private volatile Long2ObjectLinkedOpenHashMap<ChunkHolder> f_140130_ = this.f_140129_.clone();
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> f_140131_ = new Long2ObjectLinkedOpenHashMap();
    private final LongSet f_140132_ = new LongOpenHashSet();
    final ServerLevel f_140133_;
    private final ThreadedLevelLightEngine f_140134_;
    private final BlockableEventLoop<Runnable> f_140135_;
    private ChunkGenerator f_140136_;
    private final Supplier<DimensionDataStorage> f_140137_;
    private final PoiManager f_140138_;
    final LongSet f_140139_ = new LongOpenHashSet();
    private boolean f_140140_;
    private final ChunkTaskPriorityQueueSorter f_140141_;
    private final ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> f_140142_;
    private final ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> f_140143_;
    private final ChunkProgressListener f_140144_;
    private final ChunkStatusUpdateListener f_143031_;
    private final DistanceManager f_140145_;
    private final AtomicInteger f_140146_ = new AtomicInteger();
    private final StructureManager f_140147_;
    private final String f_182284_;
    private final PlayerMap f_140149_ = new PlayerMap();
    private final Int2ObjectMap<TrackedEntity> f_140150_ = new Int2ObjectOpenHashMap();
    private final Long2ByteMap f_140151_ = new Long2ByteOpenHashMap();
    private final Long2LongMap f_202981_ = new Long2LongOpenHashMap();
    private final Queue<Runnable> f_140125_ = Queues.newConcurrentLinkedQueue();
    int f_140126_;

    public ChunkMap(ServerLevel worldIn, LevelStorageSource.LevelStorageAccess levelSaveIn, DataFixer dataFixerIn, StructureManager templateManagerIn, Executor executorIn, BlockableEventLoop<Runnable> taskExecutorIn, LightChunkGetter lightProviderIn, ChunkGenerator chunkGeneratorIn, ChunkProgressListener statusListenerIn, ChunkStatusUpdateListener p_i143039_10_, Supplier<DimensionDataStorage> p_i143039_11_, int p_i143039_12_, boolean p_i143039_13_) {
        super(levelSaveIn.m_197394_(worldIn.m_46472_()).resolve("region"), dataFixerIn, p_i143039_13_);
        this.f_140147_ = templateManagerIn;
        Path path = levelSaveIn.m_197394_(worldIn.m_46472_());
        this.f_182284_ = path.getFileName().toString();
        this.f_140133_ = worldIn;
        this.f_140136_ = chunkGeneratorIn;
        this.f_140135_ = taskExecutorIn;
        ProcessorMailbox processormailbox = ProcessorMailbox.m_18751_((Executor)executorIn, (String)"worldgen");
        ProcessorHandle processorhandle = ProcessorHandle.m_18714_((String)"main", arg_0 -> taskExecutorIn.m_6937_(arg_0));
        this.f_140144_ = statusListenerIn;
        this.f_143031_ = p_i143039_10_;
        ProcessorMailbox processormailbox1 = ProcessorMailbox.m_18751_((Executor)executorIn, (String)"light");
        this.f_140141_ = new ChunkTaskPriorityQueueSorter((List)ImmutableList.of((Object)processormailbox, (Object)processorhandle, (Object)processormailbox1), executorIn, Integer.MAX_VALUE);
        this.f_140142_ = this.f_140141_.m_140604_((ProcessorHandle)processormailbox, false);
        this.f_140143_ = this.f_140141_.m_140604_(processorhandle, false);
        this.f_140134_ = new ThreadedLevelLightEngine(lightProviderIn, this, this.f_140133_.m_6042_().m_63935_(), processormailbox1, this.f_140141_.m_140604_((ProcessorHandle)processormailbox1, false));
        this.f_140145_ = new DistanceManager(this, executorIn, taskExecutorIn);
        this.f_140137_ = p_i143039_11_;
        this.f_140138_ = new PoiManager(path.resolve("poi"), dataFixerIn, p_i143039_13_, (LevelHeightAccessor)worldIn);
        this.m_140167_(p_i143039_12_);
    }

    protected ChunkGenerator m_183719_() {
        return this.f_140136_;
    }

    public void m_183825_() {
        DataResult dataresult = ChunkGenerator.f_62136_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.f_140136_);
        DataResult dataresult1 = dataresult.flatMap(p_183803_0_ -> ChunkGenerator.f_62136_.parse((DynamicOps)JsonOps.INSTANCE, p_183803_0_));
        dataresult1.result().ifPresent(p_183807_1_ -> {
            this.f_140136_ = p_183807_1_;
        });
    }

    private static double m_140226_(ChunkPos chunkPosIn, Entity entityIn) {
        double d0 = SectionPos.m_175554_((int)chunkPosIn.f_45578_, (int)8);
        double d1 = SectionPos.m_175554_((int)chunkPosIn.f_45579_, (int)8);
        double d2 = d0 - entityIn.m_20185_();
        double d3 = d1 - entityIn.m_20189_();
        return d2 * d2 + d3 * d3;
    }

    public static boolean m_200878_(int xPosIn, int zPosIn, int xIn, int zIn, int viewDistanceIn) {
        int j1;
        int k1;
        int i2 = Math.max(0, Math.abs(xPosIn - xIn) - 1);
        int j2 = Math.max(0, Math.abs(zPosIn - zIn) - 1);
        long k2 = Math.max(0, Math.max(i2, j2) - 1);
        long l2 = Math.min(i2, j2);
        long i1 = l2 * l2 + k2 * k2;
        return i1 <= (long)(k1 = (j1 = viewDistanceIn - 1) * j1);
    }

    private static boolean m_183828_(int xPosIn, int zPosIn, int xIn, int zIn, int viewDistanceIn) {
        if (!ChunkMap.m_200878_((int)xPosIn, (int)zPosIn, (int)xIn, (int)zIn, (int)viewDistanceIn)) {
            return false;
        }
        if (!ChunkMap.m_200878_((int)(xPosIn + 1), (int)zPosIn, (int)xIn, (int)zIn, (int)viewDistanceIn)) {
            return true;
        }
        if (!ChunkMap.m_200878_((int)xPosIn, (int)(zPosIn + 1), (int)xIn, (int)zIn, (int)viewDistanceIn)) {
            return true;
        }
        if (!ChunkMap.m_200878_((int)(xPosIn - 1), (int)zPosIn, (int)xIn, (int)zIn, (int)viewDistanceIn)) {
            return true;
        }
        return !ChunkMap.m_200878_((int)xPosIn, (int)(zPosIn - 1), (int)xIn, (int)zIn, (int)viewDistanceIn);
    }

    protected ThreadedLevelLightEngine m_140166_() {
        return this.f_140134_;
    }

    @Nullable
    protected ChunkHolder m_140174_(long chunkPosIn) {
        return (ChunkHolder)this.f_140129_.get(chunkPosIn);
    }

    @Nullable
    protected ChunkHolder m_140327_(long chunkPosIn) {
        return (ChunkHolder)this.f_140130_.get(chunkPosIn);
    }

    protected IntSupplier m_140371_(long chunkPosIn) {
        return () -> {
            ChunkHolder chunkholder = this.m_140327_(chunkPosIn);
            return chunkholder == null ? ChunkTaskPriorityQueue.f_140508_ - 1 : Math.min(chunkholder.m_140094_(), ChunkTaskPriorityQueue.f_140508_ - 1);
        };
    }

    public String m_140204_(ChunkPos pos) {
        ChunkHolder chunkholder = this.m_140327_(pos.m_45588_());
        if (chunkholder == null) {
            return "null";
        }
        String s = chunkholder.m_140093_() + "\n";
        ChunkStatus chunkstatus = chunkholder.m_140088_();
        ChunkAccess chunkaccess = chunkholder.m_140089_();
        if (chunkstatus != null) {
            s = s + "St: \u00a7" + chunkstatus.m_62445_() + chunkstatus + "\u00a7r\n";
        }
        if (chunkaccess != null) {
            s = s + "Ch: \u00a7" + chunkaccess.m_6415_().m_62445_() + chunkaccess.m_6415_() + "\u00a7r\n";
        }
        ChunkHolder.FullChunkStatus chunkholder$fullchunkstatus = chunkholder.m_140091_();
        s = s + "\u00a7" + chunkholder$fullchunkstatus.ordinal() + chunkholder$fullchunkstatus;
        return s + "\u00a7r";
    }

    private CompletableFuture<Either<List<ChunkAccess>, ChunkHolder.ChunkLoadingFailure>> m_140210_(ChunkPos pos, int p_140210_2_, IntFunction<ChunkStatus> p_140210_3_) {
        ArrayList<CompletableFuture> list = new ArrayList<CompletableFuture>();
        ArrayList<ChunkHolder> list1 = new ArrayList<ChunkHolder>();
        int i2 = pos.f_45578_;
        int j2 = pos.f_45579_;
        for (int k2 = -p_140210_2_; k2 <= p_140210_2_; ++k2) {
            for (int l2 = -p_140210_2_; l2 <= p_140210_2_; ++l2) {
                int i1 = Math.max(Math.abs(l2), Math.abs(k2));
                ChunkPos chunkpos = new ChunkPos(i2 + l2, j2 + k2);
                long j1 = chunkpos.m_45588_();
                ChunkHolder chunkholder = this.m_140174_(j1);
                if (chunkholder == null) {
                    return CompletableFuture.completedFuture(Either.right((Object)new /* Unavailable Anonymous Inner Class!! */));
                }
                ChunkStatus chunkstatus = p_140210_3_.apply(i1);
                CompletableFuture completablefuture = chunkholder.m_140049_(chunkstatus, this);
                list1.add(chunkholder);
                list.add(completablefuture);
            }
        }
        CompletableFuture completablefuture1 = Util.m_137567_(list);
        CompletionStage completablefuture2 = completablefuture1.thenApply(p_183726_4_ -> {
            ArrayList list2 = Lists.newArrayList();
            int k1 = 0;
            for (Either either : p_183726_4_) {
                if (either == null) {
                    throw this.m_203751_(new IllegalStateException("At least one of the chunk futures were null"), "n/a");
                }
                Optional optional = either.left();
                if (!optional.isPresent()) {
                    int l1 = k1;
                    return Either.right((Object)new /* Unavailable Anonymous Inner Class!! */);
                }
                list2.add((ChunkAccess)optional.get());
                ++k1;
            }
            return Either.left((Object)list2);
        });
        for (ChunkHolder chunkholder1 : list1) {
            chunkholder1.m_200416_("getChunkRangeFuture " + pos + " " + p_140210_2_, (CompletableFuture)completablefuture2);
        }
        return completablefuture2;
    }

    public ReportedException m_203751_(IllegalStateException p_203751_1_, String p_203751_2_) {
        StringBuilder stringbuilder = new StringBuilder();
        Consumer<ChunkHolder> consumer = p_203754_1_ -> p_203754_1_.m_202980_().forEach(p_203757_2_ -> {
            ChunkStatus chunkstatus = (ChunkStatus)p_203757_2_.getFirst();
            CompletableFuture completablefuture = (CompletableFuture)p_203757_2_.getSecond();
            if (completablefuture != null && completablefuture.isDone() && completablefuture.join() == null) {
                stringbuilder.append(p_203754_1_.m_140092_()).append(" - status: ").append(chunkstatus).append(" future: ").append(completablefuture).append(System.lineSeparator());
            }
        });
        stringbuilder.append("Updating:").append(System.lineSeparator());
        this.f_140129_.values().forEach(consumer);
        stringbuilder.append("Visible:").append(System.lineSeparator());
        this.f_140130_.values().forEach(consumer);
        CrashReport crashreport = CrashReport.m_127521_((Throwable)p_203751_1_, (String)"Chunk loading");
        CrashReportCategory crashreportcategory = crashreport.m_127514_("Chunk loading");
        crashreportcategory.m_128159_("Details", (Object)p_203751_2_);
        crashreportcategory.m_128159_("Futures", (Object)stringbuilder);
        return new ReportedException(crashreport);
    }

    public CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> m_143117_(ChunkPos p_143117_1_) {
        return this.m_140210_(p_143117_1_, 2, p_203077_0_ -> ChunkStatus.f_62326_).thenApplyAsync(p_203085_0_ -> p_203085_0_.mapLeft(p_203091_0_ -> (LevelChunk)p_203091_0_.get(p_203091_0_.size() / 2)), (Executor)this.f_140135_);
    }

    @Nullable
    ChunkHolder m_140176_(long chunkPosIn, int newLevel, @Nullable ChunkHolder holder, int oldLevel) {
        if (oldLevel > f_140127_ && newLevel > f_140127_) {
            return holder;
        }
        if (holder != null) {
            holder.m_140027_(newLevel);
        }
        if (holder != null) {
            if (newLevel > f_140127_) {
                this.f_140139_.add(chunkPosIn);
            } else {
                this.f_140139_.remove(chunkPosIn);
            }
        }
        if (newLevel <= f_140127_ && holder == null) {
            holder = (ChunkHolder)this.f_140131_.remove(chunkPosIn);
            if (holder != null) {
                holder.m_140027_(newLevel);
            } else {
                holder = new ChunkHolder(new ChunkPos(chunkPosIn), newLevel, (LevelHeightAccessor)this.f_140133_, (LevelLightEngine)this.f_140134_, (ChunkHolder.LevelChangeListener)this.f_140141_, (ChunkHolder.PlayerProvider)this);
            }
            this.f_140129_.put(chunkPosIn, (Object)holder);
            this.f_140140_ = true;
        }
        return holder;
    }

    public void close() throws IOException {
        try {
            this.f_140141_.close();
            this.f_140138_.close();
        }
        finally {
            super.close();
        }
    }

    protected void m_140318_(boolean flush) {
        if (flush) {
            List list = this.f_140130_.values().stream().filter(ChunkHolder::m_140095_).peek(ChunkHolder::m_140096_).collect(Collectors.toList());
            MutableBoolean mutableboolean = new MutableBoolean();
            do {
                mutableboolean.setFalse();
                list.stream().map(p_203101_1_ -> {
                    CompletableFuture completablefuture;
                    do {
                        completablefuture = p_203101_1_.m_140090_();
                        this.f_140135_.m_18701_(completablefuture::isDone);
                    } while (completablefuture != p_203101_1_.m_140090_());
                    return (ChunkAccess)completablefuture.join();
                }).filter(p_203087_0_ -> p_203087_0_ instanceof ImposterProtoChunk || p_203087_0_ instanceof LevelChunk).filter(arg_0 -> this.m_140258_(arg_0)).forEach(p_203049_1_ -> mutableboolean.setTrue());
            } while (mutableboolean.isTrue());
            this.m_140353_(() -> true);
            this.m_63514_();
        } else {
            this.f_140130_.values().forEach(arg_0 -> this.m_198874_(arg_0));
        }
    }

    protected void m_140280_(BooleanSupplier hasMoreTime) {
        ProfilerFiller profilerfiller = this.f_140133_.m_46473_();
        profilerfiller.m_6180_("poi");
        this.f_140138_.m_6202_(hasMoreTime);
        profilerfiller.m_6182_("chunk_unload");
        if (!this.f_140133_.m_7441_()) {
            this.m_140353_(hasMoreTime);
        }
        profilerfiller.m_7238_();
    }

    public boolean m_201907_() {
        return this.f_140134_.m_142182_() || !this.f_140131_.isEmpty() || !this.f_140129_.isEmpty() || this.f_140138_.m_202164_() || !this.f_140139_.isEmpty() || !this.f_140125_.isEmpty() || this.f_140141_.m_201909_() || this.f_140145_.m_201911_();
    }

    private void m_140353_(BooleanSupplier hasMoreTime) {
        Runnable runnable;
        LongIterator longiterator = this.f_140139_.iterator();
        int i2 = 0;
        while (longiterator.hasNext() && (hasMoreTime.getAsBoolean() || i2 < 200 || this.f_140139_.size() > 2000)) {
            long j2 = longiterator.nextLong();
            ChunkHolder chunkholder = (ChunkHolder)this.f_140129_.remove(j2);
            if (chunkholder != null) {
                this.f_140131_.put(j2, (Object)chunkholder);
                this.f_140140_ = true;
                ++i2;
                this.m_140181_(j2, chunkholder);
            }
            longiterator.remove();
        }
        for (int k2 = Math.max(0, this.f_140125_.size() - 2000); (hasMoreTime.getAsBoolean() || k2 > 0) && (runnable = (Runnable)this.f_140125_.poll()) != null; --k2) {
            runnable.run();
        }
        int l2 = 0;
        ObjectIterator objectiterator = this.f_140130_.values().iterator();
        while (l2 < 20 && hasMoreTime.getAsBoolean() && objectiterator.hasNext()) {
            if (!this.m_198874_((ChunkHolder)objectiterator.next())) continue;
            ++l2;
        }
    }

    private void m_140181_(long chunkPosIn, ChunkHolder chunkHolderIn) {
        CompletableFuture completablefuture = chunkHolderIn.m_140090_();
        ((CompletableFuture)completablefuture.thenAcceptAsync(p_202998_5_ -> {
            CompletableFuture completablefuture1 = chunkHolderIn.m_140090_();
            if (completablefuture1 != completablefuture) {
                this.m_140181_(chunkPosIn, chunkHolderIn);
            } else if (this.f_140131_.remove(chunkPosIn, (Object)chunkHolderIn) && p_202998_5_ != null) {
                if (p_202998_5_ instanceof LevelChunk) {
                    ((LevelChunk)p_202998_5_).m_62913_(false);
                    if (Reflector.ChunkEvent_Unload_Constructor.exists()) {
                        Reflector.postForgeBusEvent((ReflectorConstructor)Reflector.ChunkEvent_Unload_Constructor, (Object[])new Object[]{(LevelChunk)p_202998_5_});
                    }
                }
                this.m_140258_(p_202998_5_);
                if (this.f_140132_.remove(chunkPosIn) && p_202998_5_ instanceof LevelChunk) {
                    LevelChunk levelchunk = (LevelChunk)p_202998_5_;
                    this.f_140133_.m_8712_(levelchunk);
                }
                this.f_140134_.m_9330_(p_202998_5_.m_7697_());
                this.f_140134_.m_9409_();
                this.f_140144_.m_5511_(p_202998_5_.m_7697_(), (ChunkStatus)null);
                this.f_202981_.remove(p_202998_5_.m_7697_().m_45588_());
            }
        }, this.f_140125_::add)).whenComplete((p_202994_1_, p_202994_2_) -> {
            if (p_202994_2_ != null) {
                f_140128_.error("Failed to save chunk {}", (Object)chunkHolderIn.m_140092_(), p_202994_2_);
            }
        });
    }

    protected boolean m_140324_() {
        if (!this.f_140140_) {
            return false;
        }
        this.f_140130_ = this.f_140129_.clone();
        this.f_140140_ = false;
        return true;
    }

    public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_140292_(ChunkHolder chunkHolderIn, ChunkStatus chunkStatusIn) {
        Optional optional;
        ChunkPos chunkpos = chunkHolderIn.m_140092_();
        if (chunkStatusIn == ChunkStatus.f_62314_) {
            return this.m_140417_(chunkpos);
        }
        if (chunkStatusIn == ChunkStatus.f_62323_) {
            this.f_140145_.m_140792_(TicketType.f_9446_, chunkpos, 33 + ChunkStatus.m_62370_((ChunkStatus)ChunkStatus.f_62323_), (Object)chunkpos);
        }
        if ((optional = chunkHolderIn.m_140049_(chunkStatusIn.m_62482_(), this).getNow(ChunkHolder.f_139995_).left()).isPresent() && ((ChunkAccess)optional.get()).m_6415_().m_62427_(chunkStatusIn)) {
            CompletableFuture completablefuture = chunkStatusIn.m_62364_(this.f_140133_, this.f_140147_, this.f_140134_, p_203079_2_ -> this.m_140383_(chunkHolderIn), (ChunkAccess)optional.get());
            this.f_140144_.m_5511_(chunkpos, chunkStatusIn);
            return completablefuture;
        }
        return this.m_140360_(chunkHolderIn, chunkStatusIn);
    }

    private CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_140417_(ChunkPos chunkPosIn) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.f_140133_.m_46473_().m_6174_("chunkLoad");
                CompoundTag compoundtag = this.m_140427_(chunkPosIn);
                if (compoundtag != null) {
                    boolean flag = compoundtag.m_128425_("Status", 8);
                    if (flag) {
                        ProtoChunk chunkaccess = ChunkSerializer.m_188230_((ServerLevel)this.f_140133_, (PoiManager)this.f_140138_, (ChunkPos)chunkPosIn, (CompoundTag)compoundtag);
                        this.m_140229_(chunkPosIn, chunkaccess.m_6415_().m_62494_());
                        return Either.left((Object)chunkaccess);
                    }
                    f_140128_.error("Chunk file at {} is missing level data, skipping", (Object)chunkPosIn);
                }
            }
            catch (ReportedException reportedexception) {
                Throwable throwable = reportedexception.getCause();
                if (!(throwable instanceof IOException)) {
                    this.m_140422_(chunkPosIn);
                    throw reportedexception;
                }
                f_140128_.error("Couldn't load chunk {}", (Object)chunkPosIn, (Object)throwable);
            }
            catch (Exception exception) {
                f_140128_.error("Couldn't load chunk {}", (Object)chunkPosIn, (Object)exception);
            }
            this.m_140422_(chunkPosIn);
            return Either.left((Object)new ProtoChunk(chunkPosIn, UpgradeData.f_63320_, (LevelHeightAccessor)this.f_140133_, this.f_140133_.m_5962_().m_175515_(Registry.f_122885_), (BlendingData)null));
        }, (Executor)this.f_140135_);
    }

    private void m_140422_(ChunkPos p_140422_1_) {
        this.f_140151_.put(p_140422_1_.m_45588_(), (byte)-1);
    }

    private byte m_140229_(ChunkPos p_140229_1_, ChunkStatus.ChunkType p_140229_2_) {
        return this.f_140151_.put(p_140229_1_.m_45588_(), (byte)(p_140229_2_ == ChunkStatus.ChunkType.PROTOCHUNK ? -1 : 1));
    }

    private CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_140360_(ChunkHolder chunkHolderIn, ChunkStatus chunkStatusIn) {
        ChunkPos chunkpos = chunkHolderIn.m_140092_();
        CompletableFuture completablefuture = this.m_140210_(chunkpos, chunkStatusIn.m_62488_(), p_203070_2_ -> this.m_140262_(chunkStatusIn, p_203070_2_));
        this.f_140133_.m_46473_().m_6525_(() -> "chunkGenerate " + chunkStatusIn.m_62467_());
        Executor executor = p_203098_2_ -> this.f_140142_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140642_((ChunkHolder)chunkHolderIn, (Runnable)p_203098_2_));
        return completablefuture.thenComposeAsync(p_203011_5_ -> (CompletionStage)p_203011_5_.map(p_203017_5_ -> {
            try {
                CompletableFuture completablefuture1 = chunkStatusIn.m_187788_(executor, this.f_140133_, this.f_140136_, this.f_140147_, this.f_140134_, p_203060_2_ -> this.m_140383_(chunkHolderIn), p_203017_5_, false);
                this.f_140144_.m_5511_(chunkpos, chunkStatusIn);
                return completablefuture1;
            }
            catch (Exception exception) {
                exception.getStackTrace();
                CrashReport crashreport = CrashReport.m_127521_((Throwable)exception, (String)"Exception generating new chunk");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Chunk to be generated");
                crashreportcategory.m_128159_("Location", (Object)String.format("%d,%d", chunkpos.f_45578_, chunkpos.f_45579_));
                crashreportcategory.m_128159_("Position hash", (Object)ChunkPos.m_45589_((int)chunkpos.f_45578_, (int)chunkpos.f_45579_));
                crashreportcategory.m_128159_("Generator", (Object)this.f_140136_);
                this.f_140135_.execute(() -> {
                    throw new ReportedException(crashreport);
                });
                throw new ReportedException(crashreport);
            }
        }, p_203008_2_ -> {
            this.m_140375_(chunkpos);
            return CompletableFuture.completedFuture(Either.right((Object)p_203008_2_));
        }), executor);
    }

    protected void m_140375_(ChunkPos p_140375_1_) {
        this.f_140135_.m_6937_(Util.m_137474_(() -> this.f_140145_.m_140823_(TicketType.f_9446_, p_140375_1_, 33 + ChunkStatus.m_62370_((ChunkStatus)ChunkStatus.f_62323_), (Object)p_140375_1_), () -> "release light ticket " + p_140375_1_));
    }

    private ChunkStatus m_140262_(ChunkStatus p_140262_1_, int p_140262_2_) {
        ChunkStatus chunkstatus = p_140262_2_ == 0 ? p_140262_1_.m_62482_() : ChunkStatus.m_156185_((int)(ChunkStatus.m_62370_((ChunkStatus)p_140262_1_) + p_140262_2_));
        return chunkstatus;
    }

    private static void m_143064_(ServerLevel p_143064_0_, List<CompoundTag> p_143064_1_) {
        if (!p_143064_1_.isEmpty()) {
            p_143064_0_.m_143327_(EntityType.m_147045_(p_143064_1_, (Level)p_143064_0_));
        }
    }

    private CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_140383_(ChunkHolder p_140383_1_) {
        CompletableFuture completablefuture = p_140383_1_.m_140047_(ChunkStatus.f_62326_.m_62482_());
        return completablefuture.thenApplyAsync(p_202985_2_ -> {
            ChunkStatus chunkstatus = ChunkHolder.m_140074_((int)p_140383_1_.m_140093_());
            return !chunkstatus.m_62427_(ChunkStatus.f_62326_) ? ChunkHolder.f_139995_ : p_202985_2_.mapLeft(p_202988_2_ -> {
                LevelChunk levelchunk;
                ChunkPos chunkpos = p_140383_1_.m_140092_();
                ProtoChunk protochunk = (ProtoChunk)p_202988_2_;
                if (protochunk instanceof ImposterProtoChunk) {
                    levelchunk = ((ImposterProtoChunk)protochunk).m_62768_();
                } else {
                    levelchunk = new LevelChunk(this.f_140133_, protochunk, p_203035_2_ -> ChunkMap.m_143064_((ServerLevel)this.f_140133_, (List)protochunk.m_63293_()));
                    p_140383_1_.m_140052_(new ImposterProtoChunk(levelchunk, false));
                }
                levelchunk.m_62879_(() -> ChunkHolder.m_140083_((int)p_140383_1_.m_140093_()));
                levelchunk.m_62952_();
                if (this.f_140132_.add(chunkpos.m_45588_())) {
                    levelchunk.m_62913_(true);
                    try {
                        Reflector.setFieldValue((Object)p_140383_1_, (ReflectorField)Reflector.ForgeChunkHolder_currentlyLoading, (Object)levelchunk);
                        levelchunk.m_156369_();
                        levelchunk.m_187958_(this.f_140133_);
                        Reflector.postForgeBusEvent((ReflectorConstructor)Reflector.ChunkEvent_Load_Constructor, (Object[])new Object[]{levelchunk});
                    }
                    finally {
                        Reflector.setFieldValue((Object)p_140383_1_, (ReflectorField)Reflector.ForgeChunkHolder_currentlyLoading, null);
                    }
                }
                return levelchunk;
            });
        }, p_203093_2_ -> this.f_140143_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140624_((Runnable)p_203093_2_, (long)p_140383_1_.m_140092_().m_45588_(), () -> ((ChunkHolder)p_140383_1_).m_140093_())));
    }

    public CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> m_143053_(ChunkHolder p_143053_1_) {
        ChunkPos chunkpos = p_143053_1_.m_140092_();
        CompletableFuture completablefuture = this.m_140210_(chunkpos, 1, p_203058_0_ -> ChunkStatus.f_62326_);
        CompletionStage completablefuture1 = ((CompletableFuture)completablefuture.thenApplyAsync(p_203066_0_ -> p_203066_0_.mapLeft(p_212883_0_ -> (LevelChunk)p_212883_0_.get(p_212883_0_.size() / 2)), p_203082_2_ -> this.f_140143_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140642_((ChunkHolder)p_143053_1_, (Runnable)p_203082_2_)))).thenApplyAsync(p_212877_1_ -> p_212877_1_.ifLeft(p_212887_1_ -> {
            p_212887_1_.m_62812_();
            this.f_140133_.m_184102_(p_212887_1_);
        }), (Executor)this.f_140135_);
        ((CompletableFuture)completablefuture1).thenAcceptAsync(p_212858_2_ -> p_212858_2_.ifLeft(p_212861_2_ -> {
            this.f_140146_.getAndIncrement();
            MutableObject mutableobject = new MutableObject();
            this.m_183262_(chunkpos, false).forEach(p_212870_3_ -> this.m_183760_(p_212870_3_, mutableobject, p_212861_2_));
        }), p_212874_2_ -> this.f_140143_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140642_((ChunkHolder)p_143053_1_, (Runnable)p_212874_2_)));
        return completablefuture1;
    }

    public CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> m_143109_(ChunkHolder p_143109_1_) {
        return this.m_140210_(p_143109_1_.m_140092_(), 1, ChunkStatus::m_156185_).thenApplyAsync(p_212864_0_ -> p_212864_0_.mapLeft(p_212868_0_ -> (LevelChunk)p_212868_0_.get(p_212868_0_.size() / 2)), p_212850_2_ -> this.f_140143_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140642_((ChunkHolder)p_143109_1_, (Runnable)p_212850_2_)));
    }

    public int m_140368_() {
        return this.f_140146_.get();
    }

    private boolean m_198874_(ChunkHolder p_198874_1_) {
        if (!p_198874_1_.m_140095_()) {
            return false;
        }
        ChunkAccess chunkaccess = p_198874_1_.m_140090_().getNow(null);
        if (!(chunkaccess instanceof ImposterProtoChunk) && !(chunkaccess instanceof LevelChunk)) {
            return false;
        }
        long i2 = chunkaccess.m_7697_().m_45588_();
        long j2 = this.f_202981_.getOrDefault(i2, -1L);
        long k2 = System.currentTimeMillis();
        if (k2 < j2) {
            return false;
        }
        boolean flag = this.m_140258_(chunkaccess);
        p_198874_1_.m_140096_();
        if (flag) {
            this.f_202981_.put(i2, k2 + 10000L);
        }
        return flag;
    }

    private boolean m_140258_(ChunkAccess chunkIn) {
        this.f_140138_.m_63796_(chunkIn.m_7697_());
        if (!chunkIn.m_6344_()) {
            return false;
        }
        chunkIn.m_8092_(false);
        ChunkPos chunkpos = chunkIn.m_7697_();
        try {
            ChunkStatus chunkstatus = chunkIn.m_6415_();
            if (chunkstatus.m_62494_() != ChunkStatus.ChunkType.LEVELCHUNK) {
                if (this.m_140425_(chunkpos)) {
                    return false;
                }
                if (chunkstatus == ChunkStatus.f_62314_ && chunkIn.m_6633_().values().stream().noneMatch(StructureStart::m_73603_)) {
                    return false;
                }
            }
            this.f_140133_.m_46473_().m_6174_("chunkSave");
            CompoundTag compoundtag = ChunkSerializer.m_63454_((ServerLevel)this.f_140133_, (ChunkAccess)chunkIn);
            if (Reflector.ChunkDataEvent_Save_Constructor.exists()) {
                Level worldForge = (Level)Reflector.call((Object)chunkIn, (ReflectorMethod)Reflector.ForgeIChunk_getWorldForge, (Object[])new Object[0]);
                Reflector.postForgeBusEvent((ReflectorConstructor)Reflector.ChunkDataEvent_Save_Constructor, (Object[])new Object[]{chunkIn, worldForge != null ? worldForge : this.f_140133_, compoundtag});
            }
            this.m_63502_(chunkpos, compoundtag);
            this.m_140229_(chunkpos, chunkstatus.m_62494_());
            return true;
        }
        catch (Exception exception) {
            f_140128_.error("Failed to save chunk {},{}", new Object[]{chunkpos.f_45578_, chunkpos.f_45579_, exception});
            return false;
        }
    }

    private boolean m_140425_(ChunkPos p_140425_1_) {
        CompoundTag compoundtag;
        byte b0 = this.f_140151_.get(p_140425_1_.m_45588_());
        if (b0 != 0) {
            return b0 == 1;
        }
        try {
            compoundtag = this.m_140427_(p_140425_1_);
            if (compoundtag == null) {
                this.m_140422_(p_140425_1_);
                return false;
            }
        }
        catch (Exception exception) {
            f_140128_.error("Failed to read chunk {}", (Object)p_140425_1_, (Object)exception);
            this.m_140422_(p_140425_1_);
            return false;
        }
        ChunkStatus.ChunkType chunkstatus$chunktype = ChunkSerializer.m_63485_((CompoundTag)compoundtag);
        return this.m_140229_(p_140425_1_, chunkstatus$chunktype) == 1;
    }

    protected void m_140167_(int viewDistance) {
        int i2 = Mth.m_14045_((int)(viewDistance + 1), (int)3, (int)64);
        if (i2 != this.f_140126_) {
            int j2 = this.f_140126_;
            this.f_140126_ = i2;
            this.f_140145_.m_140777_(this.f_140126_ + 1);
            for (ChunkHolder chunkholder : this.f_140129_.values()) {
                ChunkPos chunkpos = chunkholder.m_140092_();
                MutableObject mutableobject = new MutableObject();
                this.m_183262_(chunkpos, false).forEach(p_212853_4_ -> {
                    SectionPos sectionpos = p_212853_4_.m_8965_();
                    boolean flag = ChunkMap.m_200878_((int)chunkpos.f_45578_, (int)chunkpos.f_45579_, (int)sectionpos.m_123170_(), (int)sectionpos.m_123222_(), (int)j2);
                    boolean flag1 = ChunkMap.m_200878_((int)chunkpos.f_45578_, (int)chunkpos.f_45579_, (int)sectionpos.m_123170_(), (int)sectionpos.m_123222_(), (int)this.f_140126_);
                    this.m_183754_(p_212853_4_, chunkpos, mutableobject, flag, flag1);
                });
            }
        }
    }

    protected void m_183754_(ServerPlayer player, ChunkPos chunkPosIn, MutableObject<ClientboundLevelChunkWithLightPacket> packetCache, boolean wasLoaded, boolean load) {
        if (player.f_19853_ == this.f_140133_) {
            ChunkHolder chunkholder;
            if (Reflector.ForgeEventFactory_fireChunkWatch.exists()) {
                Reflector.ForgeEventFactory_fireChunkWatch.call(new Object[]{wasLoaded, load, player, chunkPosIn, this.f_140133_});
            }
            if (load && !wasLoaded && (chunkholder = this.m_140327_(chunkPosIn.m_45588_())) != null) {
                LevelChunk levelchunk = chunkholder.m_140085_();
                if (levelchunk != null) {
                    this.m_183760_(player, packetCache, levelchunk);
                }
                DebugPackets.m_133676_((ServerLevel)this.f_140133_, (ChunkPos)chunkPosIn);
            }
            if (!load && wasLoaded) {
                player.m_9088_(chunkPosIn);
            }
        }
    }

    public int m_140394_() {
        return this.f_140130_.size();
    }

    public net.minecraft.server.level.DistanceManager m_143145_() {
        return this.f_140145_;
    }

    protected Iterable<ChunkHolder> m_140416_() {
        return Iterables.unmodifiableIterable((Iterable)this.f_140130_.values());
    }

    void m_140274_(Writer writerIn) throws IOException {
        CsvOutput csvoutput = CsvOutput.m_13619_().m_13630_("x").m_13630_("z").m_13630_("level").m_13630_("in_memory").m_13630_("status").m_13630_("full_status").m_13630_("accessible_ready").m_13630_("ticking_ready").m_13630_("entity_ticking_ready").m_13630_("ticket").m_13630_("spawning").m_13630_("block_entity_count").m_13630_("ticking_ticket").m_13630_("ticking_level").m_13630_("block_ticks").m_13630_("fluid_ticks").m_13628_(writerIn);
        TickingTracker tickingtracker = this.f_140145_.m_183915_();
        for (Long2ObjectMap.Entry entry : this.f_140130_.long2ObjectEntrySet()) {
            long i2 = entry.getLongKey();
            ChunkPos chunkpos = new ChunkPos(i2);
            ChunkHolder chunkholder = (ChunkHolder)entry.getValue();
            Optional<ChunkAccess> optional = Optional.ofNullable(chunkholder.m_140089_());
            Optional<Object> optional1 = optional.flatMap(p_212879_0_ -> p_212879_0_ instanceof LevelChunk ? Optional.of((LevelChunk)p_212879_0_) : Optional.empty());
            csvoutput.m_13624_(new Object[]{chunkpos.f_45578_, chunkpos.f_45579_, chunkholder.m_140093_(), optional.isPresent(), optional.map(ChunkAccess::m_6415_).orElse(null), optional1.map(LevelChunk::m_6708_).orElse(null), ChunkMap.m_140278_((CompletableFuture)chunkholder.m_140082_()), ChunkMap.m_140278_((CompletableFuture)chunkholder.m_140026_()), ChunkMap.m_140278_((CompletableFuture)chunkholder.m_140073_()), this.f_140145_.m_140838_(i2), this.m_183879_(chunkpos), optional1.map(p_203073_0_ -> p_203073_0_.m_62954_().size()).orElse(0), tickingtracker.m_184175_(i2), tickingtracker.m_6172_(i2), optional1.map(p_212885_0_ -> p_212885_0_.m_183531_().m_183574_()).orElse(0), optional1.map(p_212881_0_ -> p_212881_0_.m_183526_().m_183574_()).orElse(0)});
        }
    }

    private static String m_140278_(CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> p_140278_0_) {
        try {
            Either<LevelChunk, ChunkHolder.ChunkLoadingFailure> either = p_140278_0_.getNow((Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>)((Either)null));
            return either != null ? (String)either.map(p_212866_0_ -> "done", p_212848_0_ -> "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    @Nullable
    private CompoundTag m_140427_(ChunkPos pos) throws IOException {
        CompoundTag compoundtag = this.m_63512_(pos);
        return compoundtag == null ? null : this.m_188288_(this.f_140133_.m_46472_(), this.f_140137_, compoundtag, this.f_140136_.m_187743_());
    }

    boolean m_183879_(ChunkPos chunkPosIn) {
        long i2 = chunkPosIn.m_45588_();
        if (!this.f_140145_.m_140847_(i2)) {
            return false;
        }
        for (ServerPlayer serverplayer : this.f_140149_.m_183926_(i2)) {
            if (!this.m_183751_(serverplayer, chunkPosIn)) continue;
            return true;
        }
        return false;
    }

    public List<ServerPlayer> m_183888_(ChunkPos chunkPosIn) {
        long i2 = chunkPosIn.m_45588_();
        if (!this.f_140145_.m_140847_(i2)) {
            return List.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ServerPlayer serverplayer : this.f_140149_.m_183926_(i2)) {
            if (!this.m_183751_(serverplayer, chunkPosIn)) continue;
            builder.add((Object)serverplayer);
        }
        return builder.build();
    }

    private boolean m_183751_(ServerPlayer playerIn, ChunkPos chunkPosIn) {
        if (playerIn.m_5833_()) {
            return false;
        }
        double d0 = ChunkMap.m_140226_((ChunkPos)chunkPosIn, (Entity)playerIn);
        return d0 < 16384.0;
    }

    private boolean m_140329_(ServerPlayer player) {
        return player.m_5833_() && !this.f_140133_.m_46469_().m_46207_(GameRules.f_46146_);
    }

    void m_140192_(ServerPlayer player, boolean track) {
        boolean flag = this.m_140329_(player);
        boolean flag1 = this.f_140149_.m_8260_(player);
        int i2 = SectionPos.m_123171_((int)player.m_146903_());
        int j2 = SectionPos.m_123171_((int)player.m_146907_());
        if (track) {
            this.f_140149_.m_8252_(ChunkPos.m_45589_((int)i2, (int)j2), player, flag);
            this.m_140373_(player);
            if (!flag) {
                this.f_140145_.m_140802_(SectionPos.m_123194_((Entity)player), player);
            }
        } else {
            SectionPos sectionpos = player.m_8965_();
            this.f_140149_.m_8249_(sectionpos.m_123251_().m_45588_(), player);
            if (!flag1) {
                this.f_140145_.m_140828_(sectionpos, player);
            }
        }
        for (int l2 = i2 - this.f_140126_ - 1; l2 <= i2 + this.f_140126_ + 1; ++l2) {
            for (int k2 = j2 - this.f_140126_ - 1; k2 <= j2 + this.f_140126_ + 1; ++k2) {
                if (!ChunkMap.m_200878_((int)l2, (int)k2, (int)i2, (int)j2, (int)this.f_140126_)) continue;
                ChunkPos chunkpos = new ChunkPos(l2, k2);
                this.m_183754_(player, chunkpos, new MutableObject(), !track, track);
            }
        }
    }

    private SectionPos m_140373_(ServerPlayer serverPlayerEntityIn) {
        SectionPos sectionpos = SectionPos.m_123194_((Entity)serverPlayerEntityIn);
        serverPlayerEntityIn.m_9119_(sectionpos);
        serverPlayerEntityIn.f_8906_.m_141995_((Packet)new ClientboundSetChunkCacheCenterPacket(sectionpos.m_123170_(), sectionpos.m_123222_()));
        return sectionpos;
    }

    public void m_140184_(ServerPlayer player) {
        boolean flag2;
        for (TrackedEntity chunkmap$trackedentity : this.f_140150_.values()) {
            if (chunkmap$trackedentity.f_140472_ == player) {
                chunkmap$trackedentity.m_140487_(this.f_140133_.m_6907_());
                continue;
            }
            chunkmap$trackedentity.m_140497_(player);
        }
        int i2 = SectionPos.m_123171_((int)player.m_146903_());
        int j2 = SectionPos.m_123171_((int)player.m_146907_());
        SectionPos sectionpos = player.m_8965_();
        SectionPos sectionpos1 = SectionPos.m_123194_((Entity)player);
        long i3 = sectionpos.m_123251_().m_45588_();
        long j3 = sectionpos1.m_123251_().m_45588_();
        boolean flag = this.f_140149_.m_8262_(player);
        boolean flag1 = this.m_140329_(player);
        boolean bl = flag2 = sectionpos.m_123252_() != sectionpos1.m_123252_();
        if (flag2 || flag != flag1) {
            this.m_140373_(player);
            if (!flag) {
                this.f_140145_.m_140828_(sectionpos, player);
            }
            if (!flag1) {
                this.f_140145_.m_140802_(sectionpos1, player);
            }
            if (!flag && flag1) {
                this.f_140149_.m_8256_(player);
            }
            if (flag && !flag1) {
                this.f_140149_.m_8258_(player);
            }
            if (i3 != j3) {
                this.f_140149_.m_8245_(i3, j3, player);
            }
        }
        int k2 = sectionpos.m_123170_();
        int l2 = sectionpos.m_123222_();
        if (Math.abs(k2 - i2) <= this.f_140126_ * 2 && Math.abs(l2 - j2) <= this.f_140126_ * 2) {
            int l22 = Math.min(i2, k2) - this.f_140126_ - 1;
            int j32 = Math.min(j2, l2) - this.f_140126_ - 1;
            int k3 = Math.max(i2, k2) + this.f_140126_ + 1;
            int l3 = Math.max(j2, l2) + this.f_140126_ + 1;
            for (int k1 = l22; k1 <= k3; ++k1) {
                for (int l1 = j32; l1 <= l3; ++l1) {
                    boolean flag5 = ChunkMap.m_200878_((int)k1, (int)l1, (int)k2, (int)l2, (int)this.f_140126_);
                    boolean flag6 = ChunkMap.m_200878_((int)k1, (int)l1, (int)i2, (int)j2, (int)this.f_140126_);
                    this.m_183754_(player, new ChunkPos(k1, l1), new MutableObject(), flag5, flag6);
                }
            }
        } else {
            for (int i1 = k2 - this.f_140126_ - 1; i1 <= k2 + this.f_140126_ + 1; ++i1) {
                for (int j1 = l2 - this.f_140126_ - 1; j1 <= l2 + this.f_140126_ + 1; ++j1) {
                    if (!ChunkMap.m_200878_((int)i1, (int)j1, (int)k2, (int)l2, (int)this.f_140126_)) continue;
                    boolean flag3 = true;
                    boolean flag4 = false;
                    this.m_183754_(player, new ChunkPos(i1, j1), new MutableObject(), true, false);
                }
            }
            for (int k22 = i2 - this.f_140126_ - 1; k22 <= i2 + this.f_140126_ + 1; ++k22) {
                for (int i32 = j2 - this.f_140126_ - 1; i32 <= j2 + this.f_140126_ + 1; ++i32) {
                    if (!ChunkMap.m_200878_((int)k22, (int)i32, (int)i2, (int)j2, (int)this.f_140126_)) continue;
                    boolean flag7 = false;
                    boolean flag8 = true;
                    this.m_183754_(player, new ChunkPos(k22, i32), new MutableObject(), false, true);
                }
            }
        }
    }

    public List<ServerPlayer> m_183262_(ChunkPos pos, boolean boundaryOnly) {
        Set set = this.f_140149_.m_183926_(pos.m_45588_());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ServerPlayer serverplayer : set) {
            SectionPos sectionpos = serverplayer.m_8965_();
            if ((!boundaryOnly || !ChunkMap.m_183828_((int)pos.f_45578_, (int)pos.f_45579_, (int)sectionpos.m_123170_(), (int)sectionpos.m_123222_(), (int)this.f_140126_)) && (boundaryOnly || !ChunkMap.m_200878_((int)pos.f_45578_, (int)pos.f_45579_, (int)sectionpos.m_123170_(), (int)sectionpos.m_123222_(), (int)this.f_140126_))) continue;
            builder.add((Object)serverplayer);
        }
        return builder.build();
    }

    protected void m_140199_(Entity entityIn) {
        EntityType entitytype;
        int i2;
        boolean multipart = entityIn instanceof EnderDragonPart;
        if (Reflector.PartEntity.exists()) {
            multipart = Reflector.PartEntity.isInstance((Object)entityIn);
        }
        if (!multipart && (i2 = (entitytype = entityIn.m_6095_()).m_20681_() * 16) != 0) {
            int j2 = entitytype.m_20682_();
            if (this.f_140150_.containsKey(entityIn.m_142049_())) {
                throw (IllegalStateException)Util.m_137570_((Throwable)new IllegalStateException("Entity is already tracked!"));
            }
            TrackedEntity chunkmap$trackedentity = new TrackedEntity(this, entityIn, i2, j2, entitytype.m_20683_());
            this.f_140150_.put(entityIn.m_142049_(), (Object)chunkmap$trackedentity);
            chunkmap$trackedentity.m_140487_(this.f_140133_.m_6907_());
            if (entityIn instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)entityIn;
                this.m_140192_(serverplayer, true);
                for (TrackedEntity chunkmap$trackedentity1 : this.f_140150_.values()) {
                    if (chunkmap$trackedentity1.f_140472_ == serverplayer) continue;
                    chunkmap$trackedentity1.m_140497_(serverplayer);
                }
            }
        }
    }

    protected void m_140331_(Entity entityIn) {
        TrackedEntity chunkmap$trackedentity1;
        if (entityIn instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entityIn;
            this.m_140192_(serverplayer, false);
            for (TrackedEntity chunkmap$trackedentity : this.f_140150_.values()) {
                chunkmap$trackedentity.m_140485_(serverplayer);
            }
        }
        if ((chunkmap$trackedentity1 = (TrackedEntity)this.f_140150_.remove(entityIn.m_142049_())) != null) {
            chunkmap$trackedentity1.m_140482_();
        }
    }

    protected void m_140421_() {
        ArrayList list = Lists.newArrayList();
        List list1 = this.f_140133_.m_6907_();
        for (TrackedEntity chunkmap$trackedentity : this.f_140150_.values()) {
            boolean flag;
            SectionPos sectionpos = chunkmap$trackedentity.f_140474_;
            SectionPos sectionpos1 = SectionPos.m_123194_((Entity)chunkmap$trackedentity.f_140472_);
            boolean bl = flag = !Objects.equals(sectionpos, sectionpos1);
            if (flag) {
                chunkmap$trackedentity.m_140487_(list1);
                Entity entity = chunkmap$trackedentity.f_140472_;
                if (entity instanceof ServerPlayer) {
                    list.add((ServerPlayer)entity);
                }
                chunkmap$trackedentity.f_140474_ = sectionpos1;
            }
            if (!flag && !this.f_140145_.m_183913_(sectionpos1.m_123251_().m_45588_())) continue;
            chunkmap$trackedentity.f_140471_.m_8533_();
        }
        if (!list.isEmpty()) {
            for (TrackedEntity chunkmap$trackedentity1 : this.f_140150_.values()) {
                chunkmap$trackedentity1.m_140487_((List)list);
            }
        }
    }

    public void m_140201_(Entity entityIn, Packet<?> p_140201_2_) {
        TrackedEntity chunkmap$trackedentity = (TrackedEntity)this.f_140150_.get(entityIn.m_142049_());
        if (chunkmap$trackedentity != null) {
            chunkmap$trackedentity.m_140489_(p_140201_2_);
        }
    }

    protected void m_140333_(Entity entityIn, Packet<?> p_140333_2_) {
        TrackedEntity chunkmap$trackedentity = (TrackedEntity)this.f_140150_.get(entityIn.m_142049_());
        if (chunkmap$trackedentity != null) {
            chunkmap$trackedentity.m_140499_(p_140333_2_);
        }
    }

    private void m_183760_(ServerPlayer player, MutableObject<ClientboundLevelChunkWithLightPacket> packetCache, LevelChunk chunkIn) {
        if (packetCache.getValue() == null) {
            packetCache.setValue((Object)new ClientboundLevelChunkWithLightPacket(chunkIn, (LevelLightEngine)this.f_140134_, (BitSet)null, (BitSet)null, true));
        }
        player.m_184135_(chunkIn.m_7697_(), (Packet)packetCache.getValue());
        DebugPackets.m_133676_((ServerLevel)this.f_140133_, (ChunkPos)chunkIn.m_7697_());
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (TrackedEntity chunkmap$trackedentity : this.f_140150_.values()) {
            Entity entity = chunkmap$trackedentity.f_140472_;
            if (entity == player || !entity.m_146902_().equals((Object)chunkIn.m_7697_())) continue;
            chunkmap$trackedentity.m_140497_(player);
            if (entity instanceof Mob && ((Mob)entity).m_21524_() != null) {
                list.add(entity);
            }
            if (entity.m_20197_().isEmpty()) continue;
            list1.add(entity);
        }
        if (!list.isEmpty()) {
            for (Entity entity1 : list) {
                player.f_8906_.m_141995_((Packet)new ClientboundSetEntityLinkPacket(entity1, ((Mob)entity1).m_21524_()));
            }
        }
        if (!list1.isEmpty()) {
            for (Entity entity2 : list1) {
                player.f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket(entity2));
            }
        }
    }

    protected PoiManager m_140424_() {
        return this.f_140138_;
    }

    public String m_182285_() {
        return this.f_182284_;
    }

    void m_143075_(ChunkPos p_143075_1_, ChunkHolder.FullChunkStatus p_143075_2_) {
        this.f_143031_.m_156794_(p_143075_1_, p_143075_2_);
    }
}

