/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractPackResources
implements PackResources {
    private static final Logger f_10204_ = LogUtils.getLogger();
    public final File f_10203_;

    public AbstractPackResources(File resourcePackFileIn) {
        this.f_10203_ = resourcePackFileIn;
    }

    private static String m_10226_(PackType type, ResourceLocation location) {
        return String.format("%s/%s/%s", type.m_10305_(), location.m_135827_(), location.m_135815_());
    }

    protected static String m_10217_(File file1, File file2) {
        return file1.toURI().relativize(file2.toURI()).getPath();
    }

    public InputStream m_8031_(PackType type, ResourceLocation location) throws IOException {
        return this.m_5541_(AbstractPackResources.m_10226_((PackType)type, (ResourceLocation)location));
    }

    public boolean m_7211_(PackType type, ResourceLocation location) {
        return this.m_6105_(AbstractPackResources.m_10226_((PackType)type, (ResourceLocation)location));
    }

    protected abstract InputStream m_5541_(String var1) throws IOException;

    public InputStream m_5542_(String fileName) throws IOException {
        if (!fileName.contains("/") && !fileName.contains("\\")) {
            return this.m_5541_(fileName);
        }
        throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
    }

    protected abstract boolean m_6105_(String var1);

    protected void m_10230_(String namespace) {
        f_10204_.warn("ResourcePack: ignored non-lowercase namespace: {} in {}", (Object)namespace, (Object)this.f_10203_);
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) throws IOException {
        Object object;
        try (InputStream inputstream = this.m_5541_("pack.mcmeta");){
            object = AbstractPackResources.m_10214_(deserializer, (InputStream)inputstream);
        }
        return (T)object;
    }

    @Nullable
    public static <T> T m_10214_(MetadataSectionSerializer<T> deserializer, InputStream inputStream) {
        JsonObject jsonobject;
        try (BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            jsonobject = GsonHelper.m_13859_((Reader)bufferedreader);
        }
        catch (Exception exception1) {
            f_10204_.error("Couldn't load {} metadata", (Object)deserializer.m_7991_(), (Object)exception1);
            return null;
        }
        if (!jsonobject.has(deserializer.m_7991_())) {
            return null;
        }
        try {
            return (T)deserializer.m_6322_(GsonHelper.m_13930_((JsonObject)jsonobject, (String)deserializer.m_7991_()));
        }
        catch (Exception exception) {
            f_10204_.error("Couldn't load {} metadata", (Object)deserializer.m_7991_(), (Object)exception);
            return null;
        }
    }

    public String m_8017_() {
        return this.f_10203_.getName();
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s: %s", this.getClass().getName(), this.f_10203_.getPath());
    }
}

