/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.extensions.IForgeBlockState;
import net.optifine.Config;
import net.optifine.util.BlockUtils;

public class BlockState
extends BlockBehaviour.BlockStateBase
implements IForgeBlockState {
    public static final Codec<BlockState> f_61039_ = BlockState.m_61127_((Codec)Registry.f_122824_.m_194605_(), Block::m_49966_).stable();
    private int blockId = -1;
    private int metadata = -1;
    private ResourceLocation blockLocation;
    private int blockStateId = -1;
    private static final AtomicInteger blockStateIdCounter = new AtomicInteger(0);

    public int getBlockId() {
        if (this.blockId < 0) {
            this.blockId = Registry.f_122824_.m_7447_((Object)this.m_60734_());
        }
        return this.blockId;
    }

    public int getMetadata() {
        if (this.metadata < 0) {
            this.metadata = BlockUtils.getMetadata((BlockState)this);
            if (this.metadata < 0) {
                Config.warn((String)("Metadata not found, block: " + this.getBlockLocation()));
                this.metadata = 0;
            }
        }
        return this.metadata;
    }

    public ResourceLocation getBlockLocation() {
        if (this.blockLocation == null) {
            this.blockLocation = Registry.f_122824_.m_7981_((Object)this.m_60734_());
        }
        return this.blockLocation;
    }

    public int getBlockStateId() {
        if (this.blockStateId < 0) {
            this.blockStateId = blockStateIdCounter.incrementAndGet();
        }
        return this.blockStateId;
    }

    public int getLightValue(BlockGetter world, BlockPos pos) {
        return this.m_60791_();
    }

    public boolean isCacheOpaqueCube() {
        return this.f_60593_ != null && this.f_60593_.f_60841_;
    }

    public boolean isCacheOpaqueCollisionShape() {
        return this.f_60593_ != null && this.f_60593_.f_60844_;
    }

    public BlockState(Block blockIn, ImmutableMap<Property<?>, Comparable<?>> propertiesIn, MapCodec<BlockState> codecIn) {
        super(blockIn, propertiesIn, codecIn);
    }

    protected BlockState m_7160_() {
        return this;
    }
}

