/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.util.ClassInstanceMultiMap;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public class EntitySection<T extends EntityAccess> {
    private static final Logger f_156826_ = LogUtils.getLogger();
    private final ClassInstanceMultiMap<T> f_156827_;
    private Visibility f_156828_;

    public EntitySection(Class<T> p_i156830_1_, Visibility p_i156830_2_) {
        this.f_156828_ = p_i156830_2_;
        this.f_156827_ = new ClassInstanceMultiMap(p_i156830_1_);
    }

    public void m_188346_(T accessIn) {
        this.f_156827_.add(accessIn);
    }

    public boolean m_188355_(T accessIn) {
        return this.f_156827_.remove(accessIn);
    }

    public void m_188352_(AABB aabbIn, Consumer<T> consumerIn) {
        for (EntityAccess t : this.f_156827_) {
            if (!t.m_142469_().m_82381_(aabbIn)) continue;
            consumerIn.accept(t);
        }
    }

    public <U extends T> void m_188348_(EntityTypeTest<T, U> typeTestIn, AABB aabbIn, Consumer<? super U> consumerIn) {
        Collection collection = this.f_156827_.m_13533_(typeTestIn.m_142225_());
        if (!collection.isEmpty()) {
            for (EntityAccess t : collection) {
                EntityAccess u = (EntityAccess)typeTestIn.m_141992_((Object)t);
                if (u == null || !t.m_142469_().m_82381_(aabbIn)) continue;
                consumerIn.accept(u);
            }
        }
    }

    public boolean m_156833_() {
        return this.f_156827_.isEmpty();
    }

    public Stream<T> m_156845_() {
        return this.f_156827_.stream();
    }

    public Visibility m_156848_() {
        return this.f_156828_;
    }

    public Visibility m_156838_(Visibility p_156838_1_) {
        Visibility visibility = this.f_156828_;
        this.f_156828_ = p_156838_1_;
        return visibility;
    }

    @VisibleForDebug
    public int m_156849_() {
        return this.f_156827_.size();
    }

    public List<T> getEntityList() {
        return this.f_156827_.getValues();
    }

    public static EntitySectionStorage getSectionStorage(TransientEntitySectionManager tesm) {
        return tesm.f_157638_;
    }
}

