/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.function.LongPredicate;
import net.minecraft.util.Mth;
import net.minecraft.world.level.lighting.BlockLightEngine;
import net.minecraft.world.level.lighting.BlockLightSectionStorage;
import net.minecraft.world.level.lighting.SkyLightEngine;
import net.minecraft.world.level.lighting.SkyLightSectionStorage;

public abstract class DynamicGraphMinFixedPoint {
    private static final int f_164422_ = 255;
    private final int f_75537_;
    private final LongLinkedOpenHashSet[] f_75538_;
    private final Long2ByteMap f_75539_;
    private int f_75540_;
    private volatile boolean f_75541_;

    protected DynamicGraphMinFixedPoint(int levelCount, int p_i75542_2_, int p_i75542_3_) {
        if (levelCount >= 254) {
            throw new IllegalArgumentException("Level count must be < 254.");
        }
        this.f_75537_ = levelCount;
        this.f_75538_ = new LongLinkedOpenHashSet[levelCount];
        int capacity1 = p_i75542_2_;
        int capacity2 = p_i75542_3_;
        if (this.getClass() == BlockLightEngine.class || this.getClass() == SkyLightEngine.class) {
            capacity1 = Math.max(capacity1, 8192);
            capacity2 = Math.max(capacity2, 8192);
        } else if (this.getClass() == BlockLightSectionStorage.class || this.getClass() == SkyLightSectionStorage.class) {
            capacity1 = Math.max(capacity1, 2048);
            capacity2 = Math.max(capacity2, 2048);
        }
        for (int i2 = 0; i2 < levelCount; ++i2) {
            this.f_75538_[i2] = new /* Unavailable Anonymous Inner Class!! */;
        }
        this.f_75539_ = new /* Unavailable Anonymous Inner Class!! */;
        this.f_75539_.defaultReturnValue((byte)-1);
        this.f_75540_ = levelCount;
    }

    private int m_75548_(int level1, int level2) {
        int i2 = level1;
        if (level1 > level2) {
            i2 = level2;
        }
        if (i2 > this.f_75537_ - 1) {
            i2 = this.f_75537_ - 1;
        }
        return i2;
    }

    private void m_75546_(int maxLevel) {
        int i2 = this.f_75540_;
        this.f_75540_ = maxLevel;
        for (int j2 = i2 + 1; j2 < maxLevel; ++j2) {
            if (this.f_75538_[j2].isEmpty()) continue;
            this.f_75540_ = j2;
            break;
        }
    }

    protected void m_75600_(long positionIn) {
        int i2 = this.f_75539_.get(positionIn) & 0xFF;
        if (i2 != 255) {
            int j2 = this.m_6172_(positionIn);
            int k2 = this.m_75548_(j2, i2);
            this.m_75558_(positionIn, k2, this.f_75537_, true);
            this.f_75541_ = this.f_75540_ < this.f_75537_;
        }
    }

    public void m_75581_(LongPredicate p_75581_1_) {
        LongArrayList longlist = new LongArrayList();
        this.f_75539_.keySet().forEach(arg_0 -> DynamicGraphMinFixedPoint.lambda$removeIf$0(p_75581_1_, (LongList)longlist, arg_0));
        longlist.forEach(arg_0 -> this.m_75600_(arg_0));
    }

    private void m_75558_(long pos, int level, int maxLevel, boolean removeAll) {
        if (removeAll) {
            this.f_75539_.remove(pos);
        }
        this.f_75538_[level].remove(pos);
        if (this.f_75538_[level].isEmpty() && this.f_75540_ == level) {
            this.m_75546_(maxLevel);
        }
    }

    private void m_75554_(long pos, int levelToSet, int updateLevel) {
        this.f_75539_.put(pos, (byte)levelToSet);
        this.f_75538_[updateLevel].add(pos);
        if (this.f_75540_ > updateLevel) {
            this.f_75540_ = updateLevel;
        }
    }

    protected void m_6185_(long worldPos) {
        this.m_75576_(worldPos, worldPos, this.f_75537_ - 1, false);
    }

    protected void m_75576_(long fromPos, long toPos, int newLevel, boolean isDecreasing) {
        this.m_75569_(fromPos, toPos, newLevel, this.m_6172_(toPos), this.f_75539_.get(toPos) & 0xFF, isDecreasing);
        this.f_75541_ = this.f_75540_ < this.f_75537_;
    }

    private void m_75569_(long fromPos, long toPos, int newLevel, int previousLevel, int propagationLevel, boolean isDecreasing) {
        if (!this.m_6163_(toPos)) {
            boolean flag;
            newLevel = Mth.m_14045_((int)newLevel, (int)0, (int)(this.f_75537_ - 1));
            previousLevel = Mth.m_14045_((int)previousLevel, (int)0, (int)(this.f_75537_ - 1));
            if (propagationLevel == 255) {
                flag = true;
                propagationLevel = previousLevel;
            } else {
                flag = false;
            }
            int i2 = isDecreasing ? Math.min(propagationLevel, newLevel) : Mth.m_14045_((int)this.m_6357_(toPos, fromPos, newLevel), (int)0, (int)(this.f_75537_ - 1));
            int j2 = this.m_75548_(previousLevel, propagationLevel);
            if (previousLevel != i2) {
                int k2 = this.m_75548_(previousLevel, i2);
                if (j2 != k2 && !flag) {
                    this.m_75558_(toPos, j2, k2, false);
                }
                this.m_75554_(toPos, i2, k2);
            } else if (!flag) {
                this.m_75558_(toPos, j2, this.f_75537_, true);
            }
        }
    }

    protected final void m_75593_(long fromPos, long toPos, int sourceLevel, boolean isDecreasing) {
        int i2 = this.f_75539_.get(toPos) & 0xFF;
        int j2 = Mth.m_14045_((int)this.m_6359_(fromPos, toPos, sourceLevel), (int)0, (int)(this.f_75537_ - 1));
        if (isDecreasing) {
            this.m_75569_(fromPos, toPos, j2, this.m_6172_(toPos), i2, true);
        } else {
            int k2;
            boolean flag;
            if (i2 == 255) {
                flag = true;
                k2 = Mth.m_14045_((int)this.m_6172_(toPos), (int)0, (int)(this.f_75537_ - 1));
            } else {
                k2 = i2;
                flag = false;
            }
            if (j2 == k2) {
                this.m_75569_(fromPos, toPos, this.f_75537_ - 1, flag ? k2 : this.m_6172_(toPos), i2, false);
            }
        }
    }

    protected final boolean m_75587_() {
        return this.f_75541_;
    }

    protected final int m_75588_(int toUpdateCount) {
        if (this.f_75540_ >= this.f_75537_) {
            return toUpdateCount;
        }
        while (this.f_75540_ < this.f_75537_ && toUpdateCount > 0) {
            int k2;
            --toUpdateCount;
            LongLinkedOpenHashSet longlinkedopenhashset = this.f_75538_[this.f_75540_];
            long i2 = longlinkedopenhashset.removeFirstLong();
            int j2 = Mth.m_14045_((int)this.m_6172_(i2), (int)0, (int)(this.f_75537_ - 1));
            if (longlinkedopenhashset.isEmpty()) {
                this.m_75546_(this.f_75537_);
            }
            if ((k2 = this.f_75539_.remove(i2) & 0xFF) < j2) {
                this.m_7351_(i2, k2);
                this.m_7900_(i2, k2, true);
                continue;
            }
            if (k2 <= j2) continue;
            this.m_75554_(i2, k2, this.m_75548_(this.f_75537_ - 1, k2));
            this.m_7351_(i2, this.f_75537_ - 1);
            this.m_7900_(i2, j2, false);
        }
        this.f_75541_ = this.f_75540_ < this.f_75537_;
        return toUpdateCount;
    }

    public int m_75598_() {
        return this.f_75539_.size();
    }

    protected abstract boolean m_6163_(long var1);

    protected abstract int m_6357_(long var1, long var3, int var5);

    protected abstract void m_7900_(long var1, int var3, boolean var4);

    protected abstract int m_6172_(long var1);

    protected abstract void m_7351_(long var1, int var3);

    protected abstract int m_6359_(long var1, long var3, int var5);

    protected int queuedUpdateSize() {
        return this.f_75539_.size();
    }

    private static /* synthetic */ void lambda$removeIf$0(LongPredicate p_75581_1_, LongList longlist, long p_75583_2_) {
        if (p_75581_1_.test(p_75583_2_)) {
            longlist.add(p_75583_2_);
        }
    }
}

