/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import net.optifine.Config;
import net.optifine.config.IParserInt;
import net.optifine.config.NbtTagValue;
import net.optifine.config.ParserEnchantmentId;
import net.optifine.config.RangeInt;
import net.optifine.config.RangeListInt;
import net.optifine.render.Blender;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;
import org.lwjgl.opengl.GL11;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomItemProperties {
    public String name = null;
    public String basePath = null;
    public int type = 1;
    public int[] items = null;
    public String texture = null;
    public Map<String, String> mapTextures = null;
    public String model = null;
    public Map<String, String> mapModels = null;
    public RangeListInt damage = null;
    public boolean damagePercent = false;
    public int damageMask = 0;
    public RangeListInt stackSize = null;
    public int[] enchantmentIds = null;
    public RangeListInt enchantmentLevels = null;
    public NbtTagValue[] nbtTagValues = null;
    public int hand = 0;
    public int blend = 1;
    public float speed = 0.0f;
    public float rotation = 0.0f;
    public int layer = 0;
    public float duration = 1.0f;
    public int weight = 0;
    public yt textureLocation = null;
    public Map mapTextureLocations = null;
    public fay sprite = null;
    public Map mapSprites = null;
    public fck bakedModelTexture = null;
    public Map<String, fck> mapBakedModelsTexture = null;
    public fck bakedModelFull = null;
    public Map<String, fck> mapBakedModelsFull = null;
    private int textureWidth = 0;
    private int textureHeight = 0;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_ITEM = 1;
    public static final int TYPE_ENCHANTMENT = 2;
    public static final int TYPE_ARMOR = 3;
    public static final int TYPE_ELYTRA = 4;
    public static final int HAND_ANY = 0;
    public static final int HAND_MAIN = 1;
    public static final int HAND_OFF = 2;
    public static final String INVENTORY = "inventory";

    public CustomItemProperties(Properties props, String path) {
        this.name = CustomItemProperties.parseName((String)path);
        this.basePath = CustomItemProperties.parseBasePath((String)path);
        this.type = this.parseType(props.getProperty("type"));
        this.items = this.parseItems(props.getProperty("items"), props.getProperty("matchItems"));
        this.mapModels = CustomItemProperties.parseModels((Properties)props, (String)this.basePath);
        this.model = CustomItemProperties.parseModel((String)props.getProperty("model"), (String)path, (String)this.basePath, (int)this.type, (Map)this.mapModels);
        this.mapTextures = CustomItemProperties.parseTextures((Properties)props, (String)this.basePath);
        boolean textureFromPath = this.mapModels == null && this.model == null;
        this.texture = CustomItemProperties.parseTexture((String)props.getProperty("texture"), (String)props.getProperty("tile"), (String)props.getProperty("source"), (String)path, (String)this.basePath, (int)this.type, (Map)this.mapTextures, (boolean)textureFromPath);
        String damageStr = props.getProperty("damage");
        if (damageStr != null) {
            this.damagePercent = damageStr.contains("%");
            damageStr = damageStr.replace("%", "");
            this.damage = this.parseRangeListInt(damageStr);
            this.damageMask = this.parseInt(props.getProperty("damageMask"), 0);
        }
        this.stackSize = this.parseRangeListInt(props.getProperty("stackSize"));
        this.enchantmentIds = this.parseInts(CustomItemProperties.getProperty((Properties)props, (String[])new String[]{"enchantmentIDs", "enchantments"}), (IParserInt)new ParserEnchantmentId());
        this.enchantmentLevels = this.parseRangeListInt(props.getProperty("enchantmentLevels"));
        this.nbtTagValues = this.parseNbtTagValues(props);
        this.hand = this.parseHand(props.getProperty("hand"));
        this.blend = Blender.parseBlend((String)props.getProperty("blend"));
        this.speed = this.parseFloat(props.getProperty("speed"), 0.0f);
        this.rotation = this.parseFloat(props.getProperty("rotation"), 0.0f);
        this.layer = this.parseInt(props.getProperty("layer"), 0);
        this.weight = this.parseInt(props.getProperty("weight"), 0);
        this.duration = this.parseFloat(props.getProperty("duration"), 1.0f);
    }

    private static String getProperty(Properties props, String ... names) {
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            String val = props.getProperty(name);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    private static String parseName(String path) {
        int pos2;
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        return str;
    }

    private static String parseBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    private int parseType(String str) {
        if (str == null) {
            return 1;
        }
        if (str.equals("item")) {
            return 1;
        }
        if (str.equals("enchantment")) {
            return 2;
        }
        if (str.equals("armor")) {
            return 3;
        }
        if (str.equals("elytra")) {
            return 4;
        }
        Config.warn((String)("Unknown method: " + str));
        return 0;
    }

    private int[] parseItems(String str, String str2) {
        if (str == null) {
            str = str2;
        }
        if (str == null) {
            return null;
        }
        str = str.trim();
        TreeSet<Integer> setItemIds = new TreeSet<Integer>();
        String[] tokens = Config.tokenize((String)str, (String)" ");
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            bus item = this.getItemByName(token);
            if (item == null) {
                Config.warn((String)("Item not found: " + token));
                continue;
            }
            int id2 = bus.a((bus)item);
            if (id2 < 0) {
                Config.warn((String)("Item ID not found: " + token));
                continue;
            }
            setItemIds.add(new Integer(id2));
        }
        Integer[] integers = setItemIds.toArray(new Integer[setItemIds.size()]);
        int[] ints = new int[integers.length];
        for (int i3 = 0; i3 < ints.length; ++i3) {
            ints[i3] = integers[i3];
        }
        return ints;
    }

    private bus getItemByName(String name) {
        yt loc = new yt(name);
        if (!hb.X.c(loc)) {
            return null;
        }
        bus item = (bus)hb.X.a(loc);
        return item;
    }

    private static String parseTexture(String texStr, String texStr2, String texStr3, String path, String basePath, int type, Map<String, String> mapTexs, boolean textureFromPath) {
        int pos2;
        String bowStandbyTex;
        if (texStr == null) {
            texStr = texStr2;
        }
        if (texStr == null) {
            texStr = texStr3;
        }
        if (texStr != null) {
            String png = ".png";
            if (texStr.endsWith(png)) {
                texStr = texStr.substring(0, texStr.length() - png.length());
            }
            texStr = CustomItemProperties.fixTextureName((String)texStr, (String)basePath);
            return texStr;
        }
        if (type == 3) {
            return null;
        }
        if (mapTexs != null && (bowStandbyTex = mapTexs.get("texture.bow_standby")) != null) {
            return bowStandbyTex;
        }
        if (!textureFromPath) {
            return null;
        }
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        str = CustomItemProperties.fixTextureName((String)str, (String)basePath);
        return str;
    }

    private static Map parseTextures(Properties props, String basePath) {
        String prefix = "texture.";
        Map mapProps = CustomItemProperties.getMatchingProperties((Properties)props, (String)prefix);
        if (mapProps.size() <= 0) {
            return null;
        }
        Set keySet = mapProps.keySet();
        LinkedHashMap<String, String> mapTex = new LinkedHashMap<String, String>();
        for (String key : keySet) {
            String val = (String)mapProps.get(key);
            val = CustomItemProperties.fixTextureName((String)val, (String)basePath);
            mapTex.put(key, val);
        }
        return mapTex;
    }

    private static String fixTextureName(String iconName, String basePath) {
        if (!(((String)(iconName = TextureUtils.fixResourcePath((String)iconName, (String)basePath))).startsWith(basePath) || ((String)iconName).startsWith("textures/") || ((String)iconName).startsWith("optifine/"))) {
            iconName = basePath + "/" + (String)iconName;
        }
        if (((String)iconName).endsWith(".png")) {
            iconName = ((String)iconName).substring(0, ((String)iconName).length() - 4);
        }
        if (((String)iconName).startsWith("/")) {
            iconName = ((String)iconName).substring(1);
        }
        return iconName;
    }

    private static String parseModel(String modelStr, String path, String basePath, int type, Map<String, String> mapModelNames) {
        String bowStandbyModel;
        if (modelStr != null) {
            String json = ".json";
            if (modelStr.endsWith(json)) {
                modelStr = modelStr.substring(0, modelStr.length() - json.length());
            }
            modelStr = CustomItemProperties.fixModelName((String)modelStr, (String)basePath);
            return modelStr;
        }
        if (type == 3) {
            return null;
        }
        if (mapModelNames != null && (bowStandbyModel = mapModelNames.get("model.bow_standby")) != null) {
            return bowStandbyModel;
        }
        return modelStr;
    }

    private static Map parseModels(Properties props, String basePath) {
        String prefix = "model.";
        Map mapProps = CustomItemProperties.getMatchingProperties((Properties)props, (String)prefix);
        if (mapProps.size() <= 0) {
            return null;
        }
        Set keySet = mapProps.keySet();
        LinkedHashMap<String, String> mapTex = new LinkedHashMap<String, String>();
        for (String key : keySet) {
            String val = (String)mapProps.get(key);
            val = CustomItemProperties.fixModelName((String)val, (String)basePath);
            mapTex.put(key, val);
        }
        return mapTex;
    }

    private static String fixModelName(String modelName, String basePath) {
        String json;
        boolean isVanilla;
        boolean bl = isVanilla = ((String)(modelName = TextureUtils.fixResourcePath((String)modelName, (String)basePath))).startsWith("block/") || ((String)modelName).startsWith("item/");
        if (!(((String)modelName).startsWith(basePath) || isVanilla || ((String)modelName).startsWith("optifine/"))) {
            modelName = basePath + "/" + (String)modelName;
        }
        if (((String)modelName).endsWith(json = ".json")) {
            modelName = ((String)modelName).substring(0, ((String)modelName).length() - json.length());
        }
        if (((String)modelName).startsWith("/")) {
            modelName = ((String)modelName).substring(1);
        }
        return modelName;
    }

    private int parseInt(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        int val = Config.parseInt((String)(str = str.trim()), (int)Integer.MIN_VALUE);
        if (val == Integer.MIN_VALUE) {
            Config.warn((String)("Invalid integer: " + str));
            return defVal;
        }
        return val;
    }

    private float parseFloat(String str, float defVal) {
        if (str == null) {
            return defVal;
        }
        float val = Config.parseFloat((String)(str = str.trim()), (float)Float.MIN_VALUE);
        if (val == Float.MIN_VALUE) {
            Config.warn((String)("Invalid float: " + str));
            return defVal;
        }
        return val;
    }

    private int[] parseInts(String str, IParserInt parser) {
        if (str == null) {
            return null;
        }
        String[] tokens = Config.tokenize((String)str, (String)" ");
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            int val = parser.parse(token, Integer.MIN_VALUE);
            if (val == Integer.MIN_VALUE) {
                Config.warn((String)("Invalid value: " + token));
                continue;
            }
            list.add(val);
        }
        Integer[] intArr = list.toArray(new Integer[list.size()]);
        int[] ints = Config.toPrimitive((Integer[])intArr);
        return ints;
    }

    private RangeListInt parseRangeListInt(String str) {
        if (str == null) {
            return null;
        }
        String[] tokens = Config.tokenize((String)str, (String)" ");
        RangeListInt rangeList = new RangeListInt();
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            RangeInt range = this.parseRangeInt(token);
            if (range == null) {
                Config.warn((String)("Invalid range list: " + str));
                return null;
            }
            rangeList.addRange(range);
        }
        return rangeList;
    }

    private RangeInt parseRangeInt(String str) {
        if (str == null) {
            return null;
        }
        int countMinus = (str = str.trim()).length() - str.replace("-", "").length();
        if (countMinus > 1) {
            Config.warn((String)("Invalid range: " + str));
            return null;
        }
        String[] tokens = Config.tokenize((String)str, (String)"- ");
        int[] vals = new int[tokens.length];
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            int val = Config.parseInt((String)token, (int)-1);
            if (val < 0) {
                Config.warn((String)("Invalid range: " + str));
                return null;
            }
            vals[i2] = val;
        }
        if (vals.length == 1) {
            int val = vals[0];
            if (str.startsWith("-")) {
                return new RangeInt(0, val);
            }
            if (str.endsWith("-")) {
                return new RangeInt(val, 65535);
            }
            return new RangeInt(val, val);
        }
        if (vals.length == 2) {
            int min = Math.min(vals[0], vals[1]);
            int max = Math.max(vals[0], vals[1]);
            return new RangeInt(min, max);
        }
        Config.warn((String)("Invalid range: " + str));
        return null;
    }

    private NbtTagValue[] parseNbtTagValues(Properties props) {
        String PREFIX_NBT = "nbt.";
        Map mapNbt = CustomItemProperties.getMatchingProperties((Properties)props, (String)PREFIX_NBT);
        if (mapNbt.size() <= 0) {
            return null;
        }
        ArrayList<NbtTagValue> listNbts = new ArrayList<NbtTagValue>();
        Set keySet = mapNbt.keySet();
        for (String key : keySet) {
            String val = (String)mapNbt.get(key);
            String id2 = key.substring(PREFIX_NBT.length());
            NbtTagValue nbt = new NbtTagValue(id2, val);
            listNbts.add(nbt);
        }
        NbtTagValue[] nbts = listNbts.toArray(new NbtTagValue[listNbts.size()]);
        return nbts;
    }

    private static Map getMatchingProperties(Properties props, String keyPrefix) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Set<Object> keySet = props.keySet();
        for (String string : keySet) {
            String val = props.getProperty(string);
            if (!string.startsWith(keyPrefix)) continue;
            map.put(string, val);
        }
        return map;
    }

    private int parseHand(String str) {
        if (str == null) {
            return 0;
        }
        if ((str = str.toLowerCase()).equals("any")) {
            return 0;
        }
        if (str.equals("main")) {
            return 1;
        }
        if (str.equals("off")) {
            return 2;
        }
        Config.warn((String)("Invalid hand: " + str));
        return 0;
    }

    public boolean isValid(String path) {
        if (this.name == null || this.name.length() <= 0) {
            Config.warn((String)("No name found: " + path));
            return false;
        }
        if (this.basePath == null) {
            Config.warn((String)("No base path found: " + path));
            return false;
        }
        if (this.type == 0) {
            Config.warn((String)("No type defined: " + path));
            return false;
        }
        if (this.type == 4 && this.items == null) {
            this.items = new int[]{bus.a((bus)buy.lT)};
        }
        if (this.type == 1 || this.type == 3 || this.type == 4) {
            if (this.items == null) {
                this.items = this.detectItems();
            }
            if (this.items == null) {
                Config.warn((String)("No items defined: " + path));
                return false;
            }
        }
        if (this.texture == null && this.mapTextures == null && this.model == null && this.mapModels == null) {
            Config.warn((String)("No texture or model specified: " + path));
            return false;
        }
        if (this.type == 2 && this.enchantmentIds == null) {
            Config.warn((String)("No enchantmentIDs specified: " + path));
            return false;
        }
        return true;
    }

    private int[] detectItems() {
        bus item = this.getItemByName(this.name);
        if (item == null) {
            return null;
        }
        int id2 = bus.a((bus)item);
        if (id2 < 0) {
            return null;
        }
        return new int[]{id2};
    }

    public void updateIcons(fax textureMap) {
        if (this.texture != null) {
            this.textureLocation = this.getTextureLocation(this.texture);
            if (this.type == 1) {
                yt spriteLocation = this.getSpriteLocation(this.textureLocation);
                this.sprite = textureMap.registerSprite(spriteLocation);
            }
        }
        if (this.mapTextures != null) {
            this.mapTextureLocations = new HashMap();
            this.mapSprites = new HashMap();
            Set keySet = this.mapTextures.keySet();
            for (String key : keySet) {
                String val = (String)this.mapTextures.get(key);
                yt locTex = this.getTextureLocation(val);
                this.mapTextureLocations.put(key, locTex);
                if (this.type != 1) continue;
                yt locSprite = this.getSpriteLocation(locTex);
                fay icon = textureMap.registerSprite(locSprite);
                this.mapSprites.put(key, icon);
            }
        }
    }

    public void refreshIcons(fax textureMap) {
        if (this.sprite != null) {
            this.sprite = textureMap.a(this.sprite.l());
        }
        if (this.mapSprites != null) {
            Set keySet = this.mapSprites.keySet();
            for (String key : keySet) {
                fay sprite = (fay)this.mapSprites.get(key);
                if (sprite == null) continue;
                yt loc = sprite.l();
                fay spriteNew = textureMap.a(loc);
                if (spriteNew == null || spriteNew instanceof far) {
                    Config.warn((String)("Missing CIT sprite: " + loc + ", properties: " + this.basePath));
                }
                this.mapSprites.put(key, spriteNew);
            }
        }
    }

    private yt getTextureLocation(String texName) {
        String filePath;
        yt locFile;
        boolean exists;
        if (texName == null) {
            return null;
        }
        yt resLoc = new yt(texName);
        String domain = resLoc.b();
        Object path = resLoc.a();
        if (!((String)path).contains("/")) {
            path = "textures/item/" + (String)path;
        }
        if (!(exists = Config.hasResource((yt)(locFile = new yt(domain, filePath = (String)path + ".png"))))) {
            Config.warn((String)("File not found: " + filePath));
        }
        return locFile;
    }

    private yt getSpriteLocation(yt resLoc) {
        String pathTex = resLoc.a();
        pathTex = StrUtils.removePrefix((String)pathTex, (String)"textures/");
        pathTex = StrUtils.removeSuffix((String)pathTex, (String)".png");
        yt locTex = new yt(resLoc.b(), pathTex);
        return locTex;
    }

    public void updateModelTexture(fax textureMap, eru itemModelGenerator) {
        if (this.texture == null && this.mapTextures == null) {
            return;
        }
        String[] textures = this.getModelTextures();
        boolean useTint = this.isUseTint();
        this.bakedModelTexture = CustomItemProperties.makeBakedModel((fax)textureMap, (eru)itemModelGenerator, (String[])textures, (boolean)useTint);
        if (this.type == 1 && this.mapTextures != null) {
            Set keySet = this.mapTextures.keySet();
            for (String key : keySet) {
                String tex = (String)this.mapTextures.get(key);
                String path = StrUtils.removePrefix((String)key, (String)"texture.");
                if (!this.isSubTexture(path)) continue;
                String[] texNames = new String[]{tex};
                fck modelTex = CustomItemProperties.makeBakedModel((fax)textureMap, (eru)itemModelGenerator, (String[])texNames, (boolean)useTint);
                if (this.mapBakedModelsTexture == null) {
                    this.mapBakedModelsTexture = new HashMap();
                }
                String location = "item/" + path;
                this.mapBakedModelsTexture.put(location, modelTex);
            }
        }
    }

    private boolean isSubTexture(String path) {
        return path.startsWith("bow") || path.startsWith("crossbow") || path.startsWith("fishing_rod") || path.startsWith("shield");
    }

    private boolean isUseTint() {
        return true;
    }

    private static fck makeBakedModel(fax textureMap, eru itemModelGenerator, String[] textures, boolean useTint) {
        String[] spriteNames = new String[textures.length];
        for (int i2 = 0; i2 < spriteNames.length; ++i2) {
            String texture = textures[i2];
            spriteNames[i2] = StrUtils.removePrefix((String)texture, (String)"textures/");
        }
        err modelBlockBase = CustomItemProperties.makeModelBlock((String[])spriteNames);
        err modelBlock = itemModelGenerator.a(CustomItemProperties::getSprite, modelBlockBase);
        fck model = CustomItemProperties.bakeModel((fax)textureMap, (err)modelBlock, (boolean)useTint);
        return model;
    }

    public static fay getSprite(fcn material) {
        fax atlasTexture = dyr.D().aq().a(material.a());
        return atlasTexture.a(material.b());
    }

    private String[] getModelTextures() {
        if (this.type == 1 && this.items.length == 1) {
            bsr itemArmor;
            boolean isPotionItem;
            bus item = bus.b((int)this.items[0]);
            boolean bl = isPotionItem = item == buy.pF || item == buy.sr || item == buy.su;
            if (isPotionItem && this.damage != null && this.damage.getCountRanges() > 0) {
                RangeInt range = this.damage.getRange(0);
                int valDamage = range.getMin();
                boolean splash = (valDamage & 0x4000) != 0;
                String texOverlay = this.getMapTexture(this.mapTextures, "texture.potion_overlay", "item/potion_overlay");
                String texMain = null;
                texMain = splash ? this.getMapTexture(this.mapTextures, "texture.potion_bottle_splash", "item/potion_bottle_splash") : this.getMapTexture(this.mapTextures, "texture.potion_bottle_drinkable", "item/potion_bottle_drinkable");
                return new String[]{texOverlay, texMain};
            }
            if (item instanceof bsr && (itemArmor = (bsr)item).d() == bst.a) {
                String material = "leather";
                String type = "helmet";
                axp equipmentSlot = itemArmor.b();
                if (equipmentSlot == axp.f) {
                    type = "helmet";
                }
                if (equipmentSlot == axp.e) {
                    type = "chestplate";
                }
                if (equipmentSlot == axp.d) {
                    type = "leggings";
                }
                if (equipmentSlot == axp.c) {
                    type = "boots";
                }
                String key = material + "_" + type;
                String texMain = this.getMapTexture(this.mapTextures, "texture." + key, "item/" + key);
                String texOverlay = this.getMapTexture(this.mapTextures, "texture." + key + "_overlay", "item/" + key + "_overlay");
                return new String[]{texMain, texOverlay};
            }
        }
        return new String[]{this.texture};
    }

    private String getMapTexture(Map<String, String> map, String key, String def) {
        if (map == null) {
            return def;
        }
        String str = map.get(key);
        if (str == null) {
            return def;
        }
        return str;
    }

    private static err makeModelBlock(String[] modelTextures) {
        StringBuffer sb = new StringBuffer();
        sb.append("{\"parent\": \"builtin/generated\",\"textures\": {");
        for (int i2 = 0; i2 < modelTextures.length; ++i2) {
            String modelTexture = modelTextures[i2];
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append("\"layer" + i2 + "\": \"" + modelTexture + "\"");
        }
        sb.append("}}");
        String modelStr = sb.toString();
        err model = err.a((String)modelStr);
        return model;
    }

    private static fck bakeModel(fax textureMap, err modelBlockIn, boolean useTint) {
        fcl modelRotationIn = fcl.a;
        fcn materialParticle = modelBlockIn.c("particle");
        fay var4 = materialParticle.c();
        fct.a var5 = new fct.a(modelBlockIn, erw.a, false).a(var4);
        for (ern blockPart : modelBlockIn.a()) {
            for (go direction : blockPart.c.keySet()) {
                ero blockPartFace = (ero)blockPart.c.get(direction);
                if (!useTint) {
                    blockPartFace = new ero(blockPartFace.b, -1, blockPartFace.d, blockPartFace.e);
                }
                fcn material = modelBlockIn.c(blockPartFace.d);
                fay sprite = material.c();
                erm quad = CustomItemProperties.makeBakedQuad((ern)blockPart, (ero)blockPartFace, (fay)sprite, (go)direction, (fcl)modelRotationIn);
                if (blockPartFace.b == null) {
                    var5.a(quad);
                    continue;
                }
                var5.a(go.a((d)modelRotationIn.b().c(), (go)blockPartFace.b), quad);
            }
        }
        return var5.b();
    }

    private static erm makeBakedQuad(ern blockPart, ero blockPartFace, fay textureAtlasSprite, go enumFacing, fcl modelRotation) {
        ert faceBakery = new ert();
        return faceBakery.a(blockPart.a, blockPart.b, blockPartFace, textureAtlasSprite, enumFacing, (fcr)modelRotation, blockPart.d, blockPart.e, textureAtlasSprite.l());
    }

    public String toString() {
        return this.basePath + "/" + this.name + ", type: " + this.type + ", items: [" + Config.arrayToString((int[])this.items) + "], textture: " + this.texture;
    }

    public float getTextureWidth(faz textureManager) {
        if (this.textureWidth <= 0) {
            if (this.textureLocation != null) {
                fam tex = textureManager.b(this.textureLocation);
                int texId = tex.b();
                int prevTexId = GlStateManager.getBoundTexture();
                GlStateManager._bindTexture((int)texId);
                this.textureWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
                GlStateManager._bindTexture((int)prevTexId);
            }
            if (this.textureWidth <= 0) {
                this.textureWidth = 16;
            }
        }
        return this.textureWidth;
    }

    public float getTextureHeight(faz textureManager) {
        if (this.textureHeight <= 0) {
            if (this.textureLocation != null) {
                fam tex = textureManager.b(this.textureLocation);
                int texId = tex.b();
                int prevTexId = GlStateManager.getBoundTexture();
                GlStateManager._bindTexture((int)texId);
                this.textureHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
                GlStateManager._bindTexture((int)prevTexId);
            }
            if (this.textureHeight <= 0) {
                this.textureHeight = 16;
            }
        }
        return this.textureHeight;
    }

    public fck getBakedModel(yt modelLocation, boolean fullModel) {
        String modelPath;
        fck customModel;
        Map mapBakedModels;
        fck bakedModel;
        if (fullModel) {
            bakedModel = this.bakedModelFull;
            mapBakedModels = this.mapBakedModelsFull;
        } else {
            bakedModel = this.bakedModelTexture;
            mapBakedModels = this.mapBakedModelsTexture;
        }
        if (modelLocation != null && mapBakedModels != null && (customModel = (fck)mapBakedModels.get(modelPath = modelLocation.a())) != null) {
            return customModel;
        }
        return bakedModel;
    }

    public void loadModels(fco modelBakery) {
        if (this.model != null) {
            CustomItemProperties.loadItemModel((fco)modelBakery, (String)this.model);
        }
        if (this.type == 1 && this.mapModels != null) {
            Set keySet = this.mapModels.keySet();
            for (String key : keySet) {
                String mod = (String)this.mapModels.get(key);
                String path = StrUtils.removePrefix((String)key, (String)"model.");
                if (!this.isSubTexture(path)) continue;
                CustomItemProperties.loadItemModel((fco)modelBakery, (String)mod);
            }
        }
    }

    public void updateModelsFull() {
        fcp modelManager = Config.getModelManager();
        fck missingModel = modelManager.a();
        if (this.model != null) {
            yt locItem = CustomItemProperties.getModelLocation((String)this.model);
            fcq mrl = new fcq(locItem, "inventory");
            this.bakedModelFull = modelManager.a(mrl);
            if (this.bakedModelFull == missingModel) {
                Config.warn((String)("Custom Items: Model not found " + mrl.a()));
                this.bakedModelFull = null;
            }
        }
        if (this.type == 1 && this.mapModels != null) {
            Set keySet = this.mapModels.keySet();
            for (String key : keySet) {
                String mod = (String)this.mapModels.get(key);
                String path = StrUtils.removePrefix((String)key, (String)"model.");
                if (!this.isSubTexture(path)) continue;
                yt locItem = CustomItemProperties.getModelLocation((String)mod);
                fcq mrl = new fcq(locItem, "inventory");
                fck bm = modelManager.a(mrl);
                if (bm == missingModel) {
                    Config.warn((String)("Custom Items: Model not found " + mrl.a()));
                    continue;
                }
                if (this.mapBakedModelsFull == null) {
                    this.mapBakedModelsFull = new HashMap();
                }
                String location = "item/" + path;
                this.mapBakedModelsFull.put(location, bm);
            }
        }
    }

    private static void loadItemModel(fco modelBakery, String model) {
        yt locItem = CustomItemProperties.getModelLocation((String)model);
        fcq mrl = new fcq(locItem, "inventory");
        modelBakery.a(mrl);
    }

    private static yt getModelLocation(String modelName) {
        return new yt(modelName);
    }
}

