/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.optifine.Config;
import net.optifine.DynamicLight;
import net.optifine.DynamicLightsMap;
import net.optifine.config.ConnectedParser;
import net.optifine.config.EntityTypeNameLocator;
import net.optifine.config.IObjectLocator;
import net.optifine.config.ItemLocator;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.util.PropertiesOrdered;

/*
 * Exception performing whole class analysis ignored.
 */
public class DynamicLights {
    private static DynamicLightsMap mapDynamicLights = new DynamicLightsMap();
    private static Map<String, Integer> mapEntityLightLevels = new HashMap();
    private static Map<bus, Integer> mapItemLightLevels = new HashMap();
    private static long timeUpdateMs = 0L;
    private static final double MAX_DIST = 7.5;
    private static final double MAX_DIST_SQ = 56.25;
    private static final int LIGHT_LEVEL_MAX = 15;
    private static final int LIGHT_LEVEL_FIRE = 15;
    private static final int LIGHT_LEVEL_BLAZE = 10;
    private static final int LIGHT_LEVEL_MAGMA_CUBE = 8;
    private static final int LIGHT_LEVEL_MAGMA_CUBE_CORE = 13;
    private static final int LIGHT_LEVEL_GLOWSTONE_DUST = 8;
    private static final int LIGHT_LEVEL_PRISMARINE_CRYSTALS = 8;
    private static final int LIGHT_LEVEL_GLOW_SQUID = 11;
    private static final int LIGHT_LEVEL_GLOW_INK_SAC = 8;
    private static final int LIGHT_LEVEL_GLOW_LICHEN = 6;
    private static final int LIGHT_LEVEL_GLOW_BERRIES = 12;
    private static final int LIGHT_LEVEL_GLOW_ITEM_FRAME = 8;
    private static final yb<buw> PARAMETER_ITEM_STACK = (yb)Reflector.EntityItem_ITEM.getValue();
    private static boolean initialized;

    public static void entityAdded(axk entityIn, eqq renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entityRemoved(axk entityIn, eqq renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLight dynamicLight = mapDynamicLights.remove(entityIn.ae());
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(eqq renderGlobal) {
        long timeNowMs = System.currentTimeMillis();
        if (timeNowMs < timeUpdateMs + 50L) {
            return;
        }
        timeUpdateMs = timeNowMs;
        if (!initialized) {
            DynamicLights.initialize();
        }
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLights.updateMapDynamicLights((eqq)renderGlobal);
            if (mapDynamicLights.size() <= 0) {
                return;
            }
            List dynamicLights = mapDynamicLights.valueList();
            for (int i2 = 0; i2 < dynamicLights.size(); ++i2) {
                DynamicLight dynamicLight = (DynamicLight)dynamicLights.get(i2);
                dynamicLight.update(renderGlobal);
            }
        }
    }

    private static void initialize() {
        initialized = true;
        mapEntityLightLevels.clear();
        mapItemLightLevels.clear();
        String[] modIds = ReflectorForge.getForgeModIds();
        for (int i2 = 0; i2 < modIds.length; ++i2) {
            String modId = modIds[i2];
            try {
                yt loc = new yt(modId, "optifine/dynamic_lights.properties");
                InputStream in = Config.getResourceStream((yt)loc);
                DynamicLights.loadModConfiguration((InputStream)in, (String)loc.toString(), (String)modId);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (mapEntityLightLevels.size() > 0) {
            Config.dbg((String)("DynamicLights entities: " + mapEntityLightLevels.size()));
        }
        if (mapItemLightLevels.size() > 0) {
            Config.dbg((String)("DynamicLights items: " + mapItemLightLevels.size()));
        }
    }

    private static void loadModConfiguration(InputStream in, String path, String modId) {
        if (in == null) {
            return;
        }
        try {
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            Config.dbg((String)("DynamicLights: Parsing " + path));
            ConnectedParser cp = new ConnectedParser("DynamicLights");
            DynamicLights.loadModLightLevels((String)props.getProperty("entities"), (Map)mapEntityLightLevels, (IObjectLocator)new EntityTypeNameLocator(), (ConnectedParser)cp, (String)path, (String)modId);
            DynamicLights.loadModLightLevels((String)props.getProperty("items"), (Map)mapItemLightLevels, (IObjectLocator)new ItemLocator(), (ConnectedParser)cp, (String)path, (String)modId);
        }
        catch (IOException e2) {
            Config.warn((String)("DynamicLights: Error reading " + path));
        }
    }

    private static <T> void loadModLightLevels(String prop, Map<T, Integer> mapLightLevels, IObjectLocator<T> ol, ConnectedParser cp, String path, String modId) {
        if (prop == null) {
            return;
        }
        String[] parts = Config.tokenize((String)prop, (String)" ");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            String[] tokens = Config.tokenize((String)part, (String)":");
            if (tokens.length != 2) {
                cp.warn("Invalid entry: " + part + ", in:" + path);
                continue;
            }
            String name = tokens[0];
            String light = tokens[1];
            String nameFull = modId + ":" + name;
            yt loc = new yt(nameFull);
            Object obj = ol.getObject(loc);
            if (obj == null) {
                cp.warn("Object not found: " + nameFull);
                continue;
            }
            int lightLevel = cp.parseInt(light, -1);
            if (lightLevel < 0 || lightLevel > 15) {
                cp.warn("Invalid light level: " + part);
                continue;
            }
            mapLightLevels.put(obj, new Integer(lightLevel));
        }
    }

    private static void updateMapDynamicLights(eqq renderGlobal) {
        ems world = renderGlobal.getWorld();
        if (world == null) {
            return;
        }
        Iterable entities = world.d();
        for (axk entity : entities) {
            DynamicLight dynamicLight;
            int key;
            int lightLevel = DynamicLights.getLightLevel((axk)entity);
            if (lightLevel > 0) {
                key = entity.ae();
                dynamicLight = mapDynamicLights.get(key);
                if (dynamicLight != null) continue;
                dynamicLight = new DynamicLight(entity);
                mapDynamicLights.put(key, dynamicLight);
                continue;
            }
            key = entity.ae();
            dynamicLight = mapDynamicLights.remove(key);
            if (dynamicLight == null) continue;
            dynamicLight.updateLitChunks(renderGlobal);
        }
    }

    public static int getCombinedLight(gj pos, int combinedLight) {
        double lightPos = DynamicLights.getLightLevel((gj)pos);
        combinedLight = DynamicLights.getCombinedLight((double)lightPos, (int)combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(axk entity, int combinedLight) {
        double lightPos = DynamicLights.getLightLevel((gj)entity.cW());
        if (entity == Config.getMinecraft().s) {
            double lightOwn = DynamicLights.getLightLevel((axk)entity);
            lightPos = Math.max(lightPos, lightOwn);
        }
        combinedLight = DynamicLights.getCombinedLight((double)lightPos, (int)combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(double lightPlayer, int combinedLight) {
        int lightBlockFF;
        int lightPlayerFF;
        if (lightPlayer > 0.0 && (lightPlayerFF = (int)(lightPlayer * 16.0)) > (lightBlockFF = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= lightPlayerFF;
        }
        return combinedLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getLightLevel(gj pos) {
        double lightLevelMax = 0.0;
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List dynamicLights = mapDynamicLights.valueList();
            int dynamicLightsSize = dynamicLights.size();
            for (int i2 = 0; i2 < dynamicLightsSize; ++i2) {
                double dist;
                double light;
                double lightLevel;
                double dz;
                double dy;
                DynamicLight dynamicLight = (DynamicLight)dynamicLights.get(i2);
                int dynamicLightLevel = dynamicLight.getLastLightLevel();
                if (dynamicLightLevel <= 0) continue;
                double px = dynamicLight.getLastPosX();
                double py2 = dynamicLight.getLastPosY();
                double pz = dynamicLight.getLastPosZ();
                double dx = (double)pos.u() - px;
                double distSq = dx * dx + (dy = (double)pos.v() - py2) * dy + (dz = (double)pos.w() - pz) * dz;
                if (distSq > 56.25 || !((lightLevel = (light = 1.0 - (dist = Math.sqrt(distSq)) / 7.5) * (double)dynamicLightLevel) > lightLevelMax)) continue;
                lightLevelMax = lightLevel;
            }
        }
        double lightPlayer = Config.limit((double)lightLevelMax, (double)0.0, (double)15.0);
        return lightPlayer;
    }

    public static int getLightLevel(buw itemStack) {
        Integer level;
        bta itemBlock;
        cdq block;
        if (itemStack == null) {
            return 0;
        }
        bus item = itemStack.c();
        if (item instanceof bta && (block = (itemBlock = (bta)item).e()) != null) {
            if (block == cdr.gC) {
                return 0;
            }
            if (block == cdr.dY) {
                return 6;
            }
            if (block == cdr.pB) {
                return 12;
            }
            return block.n().f();
        }
        if (item == buy.nY) {
            return cdr.B.n().f();
        }
        if (item == buy.pB || item == buy.pJ) {
            return 10;
        }
        if (item == buy.ou) {
            return 8;
        }
        if (item == buy.rE) {
            return 8;
        }
        if (item == buy.pK) {
            return 8;
        }
        if (item == buy.rx) {
            return cdr.eF.n().f() / 2;
        }
        if (item == buy.oC) {
            return 8;
        }
        if (item == buy.rj) {
            return 8;
        }
        if (!mapItemLightLevels.isEmpty() && (level = (Integer)mapItemLightLevels.get(item)) != null) {
            return level;
        }
        return 0;
    }

    public static int getLightLevel(axk entity) {
        blp entityCreeper;
        String typeName;
        Integer level;
        boj player;
        if (entity == Config.getMinecraft().Z() && !Config.isDynamicHandLight()) {
            return 0;
        }
        if (entity instanceof boj && (player = (boj)entity).B_()) {
            return 0;
        }
        if (entity.bE()) {
            return 15;
        }
        if (!mapEntityLightLevels.isEmpty() && (level = (Integer)mapEntityLightLevels.get(typeName = EntityTypeNameLocator.getEntityTypeName((axk)entity))) != null) {
            return level;
        }
        if (entity instanceof boo) {
            return 15;
        }
        if (entity instanceof blj) {
            return 15;
        }
        if (entity instanceof bln) {
            bln entityBlaze = (bln)entity;
            if (entityBlaze.bE()) {
                return 15;
            }
            return 10;
        }
        if (entity instanceof bmc) {
            bmc emc = (bmc)entity;
            if ((double)emc.e > 0.6) {
                return 13;
            }
            return 8;
        }
        if (entity instanceof blp && (double)(entityCreeper = (blp)entity).z(0.0f) > 0.001) {
            return 15;
        }
        if (entity instanceof axs) {
            axs glowSquid = (axs)entity;
            int squidLight = (int)ajl.b((float)0.0f, (float)11.0f, (float)(1.0f - (float)glowSquid.t() / 10.0f));
            return squidLight;
        }
        if (entity instanceof bla) {
            return 8;
        }
        if (entity instanceof axy) {
            player = (axy)entity;
            buw stackMain = player.es();
            int levelMain = DynamicLights.getLightLevel((buw)stackMain);
            buw stackOff = player.et();
            int levelOff = DynamicLights.getLightLevel((buw)stackOff);
            buw stackHead = player.b(axp.f);
            int levelHead = DynamicLights.getLightLevel((buw)stackHead);
            int levelHandMax = Math.max(levelMain, levelOff);
            return Math.max(levelHandMax, levelHead);
        }
        if (entity instanceof bli) {
            bli entityItem = (bli)entity;
            buw itemStack = DynamicLights.getItemStack((bli)entityItem);
            return DynamicLights.getLightLevel((buw)itemStack);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLights(eqq renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List dynamicLights = mapDynamicLights.valueList();
            for (int i2 = 0; i2 < dynamicLights.size(); ++i2) {
                DynamicLight dynamicLight = (DynamicLight)dynamicLights.get(i2);
                dynamicLight.updateLitChunks(renderGlobal);
            }
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            return mapDynamicLights.size();
        }
    }

    public static buw getItemStack(bli entityItem) {
        buw itemstack = (buw)entityItem.ai().a(PARAMETER_ITEM_STACK);
        return itemstack;
    }
}

