/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.uniform;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.optifine.expr.ConstantFloat;
import net.optifine.expr.IExpression;
import net.optifine.expr.IExpressionResolver;
import net.optifine.shaders.SMCLog;
import net.optifine.shaders.uniform.ShaderParameterBool;
import net.optifine.shaders.uniform.ShaderParameterFloat;
import net.optifine.shaders.uniform.ShaderParameterIndexed;
import net.optifine.util.BiomeUtils;

public class ShaderExpressionResolver
implements IExpressionResolver {
    private Map<String, IExpression> mapExpressions = new HashMap();

    public ShaderExpressionResolver(Map<String, IExpression> map) {
        this.registerExpressions();
        Set<String> keys = map.keySet();
        for (String name : keys) {
            IExpression expr = map.get(name);
            this.registerExpression(name, expr);
        }
    }

    private void registerExpressions() {
        ShaderParameterFloat[] spfs = ShaderParameterFloat.values();
        for (int i2 = 0; i2 < spfs.length; ++i2) {
            ShaderParameterFloat spf = spfs[i2];
            this.addParameterFloat(this.mapExpressions, spf);
        }
        ShaderParameterBool[] spbs = ShaderParameterBool.values();
        for (int i3 = 0; i3 < spbs.length; ++i3) {
            ShaderParameterBool spb = spbs[i3];
            this.mapExpressions.put(spb.getName(), spb);
        }
        Set biomeLocations = BiomeUtils.getLocations();
        for (yt loc : biomeLocations) {
            Object name = loc.a().trim();
            name = "BIOME_" + ((String)name).toUpperCase().replace(' ', '_');
            int id2 = BiomeUtils.getId((yt)loc);
            ConstantFloat expr = new ConstantFloat((float)id2);
            this.registerExpression((String)name, (IExpression)expr);
        }
        cbr.b[] biomeCats = cbr.b.values();
        int i4 = 0;
        while (i4 < biomeCats.length) {
            cbr.b bc = biomeCats[i4];
            String name = "CAT_" + bc.c().toUpperCase();
            int id3 = i4++;
            ConstantFloat expr = new ConstantFloat((float)id3);
            this.registerExpression(name, (IExpression)expr);
        }
        cbr.d[] biomePpts = cbr.d.values();
        int i5 = 0;
        while (i5 < biomePpts.length) {
            cbr.d bp = biomePpts[i5];
            String name = "PPT_" + bp.c().toUpperCase();
            int id4 = i5++;
            ConstantFloat expr = new ConstantFloat((float)id4);
            this.registerExpression(name, (IExpression)expr);
        }
    }

    private void addParameterFloat(Map<String, IExpression> map, ShaderParameterFloat spf) {
        String[] indexNames1 = spf.getIndexNames1();
        if (indexNames1 == null) {
            map.put(spf.getName(), (IExpression)new ShaderParameterIndexed(spf));
            return;
        }
        for (int i1 = 0; i1 < indexNames1.length; ++i1) {
            String indexName1 = indexNames1[i1];
            String[] indexNames2 = spf.getIndexNames2();
            if (indexNames2 == null) {
                map.put(spf.getName() + "." + indexName1, (IExpression)new ShaderParameterIndexed(spf, i1));
                continue;
            }
            for (int i2 = 0; i2 < indexNames2.length; ++i2) {
                String indexName2 = indexNames2[i2];
                map.put(spf.getName() + "." + indexName1 + "." + indexName2, (IExpression)new ShaderParameterIndexed(spf, i1, i2));
            }
        }
    }

    public boolean registerExpression(String name, IExpression expr) {
        if (this.mapExpressions.containsKey(name)) {
            SMCLog.warning((String)("Expression already defined: " + name));
            return false;
        }
        this.mapExpressions.put(name, expr);
        return true;
    }

    public IExpression getExpression(String name) {
        return (IExpression)this.mapExpressions.get(name);
    }

    public boolean hasExpression(String name) {
        return this.mapExpressions.containsKey(name);
    }
}

