/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.FontUtils;
import net.optifine.util.PropertiesOrdered;

public class FontUtils {
    public static Properties readFontProperties(yt locationFontTexture) {
        String fontFileName = locationFontTexture.a();
        PropertiesOrdered props = new PropertiesOrdered();
        String suffix = ".png";
        if (!fontFileName.endsWith(suffix)) {
            return props;
        }
        String fileName = fontFileName.substring(0, fontFileName.length() - suffix.length()) + ".properties";
        try {
            yt locProp = new yt(locationFontTexture.b(), fileName);
            InputStream in = Config.getResourceStream((aga)Config.getResourceManager(), (yt)locProp);
            if (in == null) {
                return props;
            }
            Config.log((String)("Loading " + fileName));
            props.load(in);
            in.close();
        }
        catch (FileNotFoundException locProp) {
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return props;
    }

    public static Int2ObjectMap<Float> readCustomCharWidths(Properties props) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        Set<Object> keySet = props.keySet();
        for (String string : keySet) {
            String value;
            float width;
            String numStr;
            int num;
            String prefix;
            if (!string.startsWith(prefix = "width.") || (num = Config.parseInt((String)(numStr = string.substring(prefix.length())), (int)-1)) < 0 || !((width = Config.parseFloat((String)(value = props.getProperty(string)), (float)-1.0f)) >= 0.0f)) continue;
            char ch = (char)num;
            map.put((int)ch, (Object)new Float(width));
        }
        return map;
    }

    public static float readFloat(Properties props, String key, float defOffset) {
        String str = props.getProperty(key);
        if (str == null) {
            return defOffset;
        }
        float offset = Config.parseFloat((String)str, (float)Float.MIN_VALUE);
        if (offset == Float.MIN_VALUE) {
            Config.warn((String)("Invalid value for " + key + ": " + str));
            return defOffset;
        }
        return offset;
    }

    public static boolean readBoolean(Properties props, String key, boolean defVal) {
        String str = props.getProperty(key);
        if (str == null) {
            return defVal;
        }
        String strLow = str.toLowerCase().trim();
        if (strLow.equals("true") || strLow.equals("on")) {
            return true;
        }
        if (strLow.equals("false") || strLow.equals("off")) {
            return false;
        }
        Config.warn((String)("Invalid value for " + key + ": " + str));
        return defVal;
    }

    public static yt getHdFontLocation(yt fontLoc) {
        if (!Config.isCustomFonts()) {
            return fontLoc;
        }
        if (fontLoc == null) {
            return fontLoc;
        }
        if (!Config.isMinecraftThread()) {
            return fontLoc;
        }
        Object fontName = fontLoc.a();
        String texturesStr = "textures/";
        String optifineStr = "optifine/";
        if (!((String)fontName).startsWith(texturesStr)) {
            return fontLoc;
        }
        fontName = ((String)fontName).substring(texturesStr.length());
        fontName = optifineStr + (String)fontName;
        yt fontLocHD = new yt(fontLoc.b(), (String)fontName);
        if (Config.hasResource((aga)Config.getResourceManager(), (yt)fontLocHD)) {
            return fontLocHD;
        }
        return fontLoc;
    }

    public static void reloadFonts() {
        1 stage = new /* Unavailable Anonymous Inner Class!! */;
        ExecutorService ex = ad.f();
        dyr mc = dyr.D();
        ebq frm = (ebq)Reflector.getFieldValue((Object)mc, (ReflectorField)Reflector.Minecraft_fontResourceManager);
        if (frm == null) {
            return;
        }
        frm.b().a((afv.a)stage, Config.getResourceManager(), (asy)asv.a, (asy)asv.a, (Executor)ex, (Executor)mc);
    }
}

