/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.block;

import com.refinedmods.refinedpipes.block.PipeBlock;
import com.refinedmods.refinedpipes.blockentity.EnergyPipeBlockEntity;
import com.refinedmods.refinedpipes.network.pipe.energy.EnergyPipeEnergyStorage;
import com.refinedmods.refinedpipes.network.pipe.energy.EnergyPipeType;
import com.refinedmods.refinedpipes.network.pipe.shape.PipeShapeCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyPipeBlock
extends PipeBlock
implements EntityBlock {
    private final EnergyPipeType type;

    public EnergyPipeBlock(PipeShapeCache shapeCache, EnergyPipeType type) {
        super(shapeCache);
        this.type = type;
        this.setRegistryName(type.getId());
    }

    public EnergyPipeType getType() {
        return this.type;
    }

    @Override
    protected boolean hasConnection(LevelAccessor level, BlockPos pos, Direction direction) {
        BlockEntity currentBlockEntity = level.m_7702_(pos);
        if (currentBlockEntity instanceof EnergyPipeBlockEntity && ((EnergyPipeBlockEntity)currentBlockEntity).getAttachmentManager().hasAttachment(direction)) {
            return false;
        }
        BlockState facingState = level.m_8055_(pos.m_142300_(direction));
        BlockEntity facingBlockEntity = level.m_7702_(pos.m_142300_(direction));
        if (facingBlockEntity instanceof EnergyPipeBlockEntity && ((EnergyPipeBlockEntity)facingBlockEntity).getAttachmentManager().hasAttachment(direction.m_122424_())) {
            return false;
        }
        return facingState.m_60734_() instanceof EnergyPipeBlock && ((EnergyPipeBlock)facingState.m_60734_()).getType() == this.type;
    }

    @Override
    protected boolean hasInvConnection(LevelAccessor level, BlockPos pos, Direction direction) {
        BlockEntity facingBlockEntityy = level.m_7702_(pos.m_142300_(direction));
        if (facingBlockEntityy == null) {
            return false;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)facingBlockEntityy.getCapability(CapabilityEnergy.ENERGY, direction.m_122424_()).orElse(null);
        if (energyStorage == null) {
            return false;
        }
        return !(energyStorage instanceof EnergyPipeEnergyStorage);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnergyPipeBlockEntity(pos, state, this.type);
    }
}

