/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.block;

import com.refinedmods.refinedpipes.block.PipeBlock;
import com.refinedmods.refinedpipes.blockentity.FluidPipeBlockEntity;
import com.refinedmods.refinedpipes.network.pipe.fluid.FluidPipeType;
import com.refinedmods.refinedpipes.network.pipe.shape.PipeShapeCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class FluidPipeBlock
extends PipeBlock
implements EntityBlock {
    private final FluidPipeType type;

    public FluidPipeBlock(PipeShapeCache shapeCache, FluidPipeType type) {
        super(shapeCache);
        this.type = type;
        this.setRegistryName(type.getId());
    }

    public FluidPipeType getType() {
        return this.type;
    }

    @Override
    protected boolean hasConnection(LevelAccessor level, BlockPos pos, Direction direction) {
        BlockEntity currentBlockEntity = level.m_7702_(pos);
        if (currentBlockEntity instanceof FluidPipeBlockEntity && ((FluidPipeBlockEntity)currentBlockEntity).getAttachmentManager().hasAttachment(direction)) {
            return false;
        }
        BlockState facingState = level.m_8055_(pos.m_142300_(direction));
        BlockEntity facingBlockEntity = level.m_7702_(pos.m_142300_(direction));
        if (facingBlockEntity instanceof FluidPipeBlockEntity && ((FluidPipeBlockEntity)facingBlockEntity).getAttachmentManager().hasAttachment(direction.m_122424_())) {
            return false;
        }
        return facingState.m_60734_() instanceof FluidPipeBlock && ((FluidPipeBlock)facingState.m_60734_()).getType() == this.type;
    }

    @Override
    protected boolean hasInvConnection(LevelAccessor level, BlockPos pos, Direction direction) {
        BlockEntity facingBlockEntity = level.m_7702_(pos.m_142300_(direction));
        return facingBlockEntity != null && facingBlockEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.m_122424_()).isPresent();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FluidPipeBlockEntity(pos, state, this.type);
    }
}

