/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.block;

import com.refinedmods.refinedpipes.blockentity.PipeBlockEntity;
import com.refinedmods.refinedpipes.item.AttachmentItem;
import com.refinedmods.refinedpipes.network.NetworkManager;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.network.pipe.attachment.Attachment;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentFactory;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentManager;
import com.refinedmods.refinedpipes.network.pipe.shape.PipeShapeCache;
import com.refinedmods.refinedpipes.network.pipe.shape.PipeShapeProps;
import com.refinedmods.refinedpipes.util.Raytracer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class PipeBlock
extends Block {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final BooleanProperty INV_NORTH = BooleanProperty.m_61465_((String)"inv_north");
    public static final BooleanProperty INV_EAST = BooleanProperty.m_61465_((String)"inv_east");
    public static final BooleanProperty INV_SOUTH = BooleanProperty.m_61465_((String)"inv_south");
    public static final BooleanProperty INV_WEST = BooleanProperty.m_61465_((String)"inv_west");
    public static final BooleanProperty INV_UP = BooleanProperty.m_61465_((String)"inv_up");
    public static final BooleanProperty INV_DOWN = BooleanProperty.m_61465_((String)"inv_down");
    private final PipeShapeCache shapeCache;

    public PipeBlock(PipeShapeCache shapeCache) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(0.35f));
        this.shapeCache = shapeCache;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INV_NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INV_EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INV_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INV_WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INV_UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INV_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, INV_NORTH, INV_EAST, INV_SOUTH, INV_WEST, INV_UP, INV_DOWN});
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        Pipe pipe;
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (!level.f_46443_ && (pipe = NetworkManager.get(level).getPipe(pos)) != null && pipe.getNetwork() != null) {
            pipe.getNetwork().scanGraph(level, pos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction dirClicked = this.getAttachmentDirectionClicked(pos, hit.m_82450_());
        if (dirClicked != null) {
            PipeBlockEntity pipeBlockEntity;
            ItemStack held = player.m_21205_();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (held.m_41619_() && player.m_6047_()) {
                return this.removeAttachment(level, pos, dirClicked);
            }
            if (blockEntity instanceof PipeBlockEntity && (pipeBlockEntity = (PipeBlockEntity)blockEntity).getAttachmentManager().hasAttachment(dirClicked)) {
                return this.openAttachmentContainer(player, pos, pipeBlockEntity.getAttachmentManager(), dirClicked);
            }
            if (held.m_41720_() instanceof AttachmentItem) {
                return this.addAttachment(player, level, pos, held, dirClicked);
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    private InteractionResult addAttachment(Player player, Level level, BlockPos pos, ItemStack attachment, Direction dir) {
        Pipe pipe;
        if (!level.f_46443_ && (pipe = NetworkManager.get(level).getPipe(pos)) != null && !pipe.getAttachmentManager().hasAttachment(dir)) {
            AttachmentFactory type = ((AttachmentItem)attachment.m_41720_()).getFactory();
            if (!type.canPlaceOnPipe(this)) {
                return InteractionResult.SUCCESS;
            }
            pipe.getAttachmentManager().setAttachmentAndScanGraph(dir, type.create(pipe, dir));
            NetworkManager.get(level).m_77762_();
            pipe.sendBlockUpdate();
            level.m_46597_(pos, this.getState(level.m_8055_(pos), (LevelAccessor)level, pos));
            if (!player.m_7500_()) {
                attachment.m_41774_(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult removeAttachment(Level level, BlockPos pos, Direction dir) {
        if (!level.f_46443_) {
            Pipe pipe = NetworkManager.get(level).getPipe(pos);
            if (pipe != null && pipe.getAttachmentManager().hasAttachment(dir)) {
                Attachment attachment = pipe.getAttachmentManager().getAttachment(dir);
                pipe.getAttachmentManager().removeAttachmentAndScanGraph(dir);
                NetworkManager.get(level).m_77762_();
                pipe.sendBlockUpdate();
                level.m_46597_(pos, this.getState(level.m_8055_(pos), (LevelAccessor)level, pos));
                Block.m_49840_((Level)level, (BlockPos)pos.m_142300_(dir), (ItemStack)attachment.getDrop());
            }
            return InteractionResult.SUCCESS;
        }
        return ((PipeBlockEntity)level.m_7702_(pos)).getAttachmentManager().hasAttachment(dir) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    private InteractionResult openAttachmentContainer(Player player, BlockPos pos, AttachmentManager attachmentManager, Direction dir) {
        if (player instanceof ServerPlayer) {
            attachmentManager.openAttachmentContainer(dir, (ServerPlayer)player);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getState(this.m_49966_(), (LevelAccessor)ctx.m_43725_(), ctx.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return this.getState(state, world, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return this.shapeCache.getShape(state, world, pos, ctx);
    }

    private BlockState getState(BlockState currentState, LevelAccessor world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)currentState.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.NORTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.EAST)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.SOUTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.WEST)))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.UP)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.DOWN)))).m_61124_((Property)INV_NORTH, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.NORTH)))).m_61124_((Property)INV_EAST, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.EAST)))).m_61124_((Property)INV_SOUTH, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.SOUTH)))).m_61124_((Property)INV_WEST, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.WEST)))).m_61124_((Property)INV_UP, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.UP)))).m_61124_((Property)INV_DOWN, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.DOWN)));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        Direction dirClicked = this.getAttachmentDirectionClicked(pos, target.m_82450_());
        if (dirClicked != null && (blockEntity = world.m_7702_(pos)) instanceof PipeBlockEntity) {
            PipeBlockEntity pipeBlockEntity = (PipeBlockEntity)blockEntity;
            return pipeBlockEntity.getAttachmentManager().getPickBlock(dirClicked);
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    @Nullable
    public Direction getAttachmentDirectionClicked(BlockPos pos, Vec3 hit) {
        if (Raytracer.inclusiveContains(PipeShapeProps.NORTH_ATTACHMENT_SHAPE.m_83215_().m_82338_(pos), hit)) {
            return Direction.NORTH;
        }
        if (Raytracer.inclusiveContains(PipeShapeProps.EAST_ATTACHMENT_SHAPE.m_83215_().m_82338_(pos), hit)) {
            return Direction.EAST;
        }
        if (Raytracer.inclusiveContains(PipeShapeProps.SOUTH_ATTACHMENT_SHAPE.m_83215_().m_82338_(pos), hit)) {
            return Direction.SOUTH;
        }
        if (Raytracer.inclusiveContains(PipeShapeProps.WEST_ATTACHMENT_SHAPE.m_83215_().m_82338_(pos), hit)) {
            return Direction.WEST;
        }
        if (Raytracer.inclusiveContains(PipeShapeProps.UP_ATTACHMENT_SHAPE.m_83215_().m_82338_(pos), hit)) {
            return Direction.UP;
        }
        if (Raytracer.inclusiveContains(PipeShapeProps.DOWN_ATTACHMENT_SHAPE.m_83215_().m_82338_(pos), hit)) {
            return Direction.DOWN;
        }
        return null;
    }

    protected abstract boolean hasConnection(LevelAccessor var1, BlockPos var2, Direction var3);

    protected abstract boolean hasInvConnection(LevelAccessor var1, BlockPos var2, Direction var3);
}

