/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.blockentity;

import com.refinedmods.refinedpipes.blockentity.BaseBlockEntity;
import com.refinedmods.refinedpipes.network.NetworkManager;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.network.pipe.attachment.Attachment;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentManager;
import com.refinedmods.refinedpipes.network.pipe.attachment.ClientAttachmentManager;
import com.refinedmods.refinedpipes.network.pipe.attachment.DummyAttachmentManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public abstract class PipeBlockEntity
extends BaseBlockEntity {
    public static final ModelProperty<ResourceLocation[]> ATTACHMENTS_PROPERTY = new ModelProperty();
    private final AttachmentManager clientAttachmentManager = new ClientAttachmentManager();
    private boolean unloaded;

    protected PipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public AttachmentManager getAttachmentManager() {
        if (this.f_58857_.f_46443_) {
            return this.clientAttachmentManager;
        }
        Pipe pipe = NetworkManager.get(this.f_58857_).getPipe(this.f_58858_);
        if (pipe != null) {
            return pipe.getAttachmentManager();
        }
        return DummyAttachmentManager.INSTANCE;
    }

    public void m_6339_() {
        NetworkManager mgr;
        super.m_6339_();
        if (!this.f_58857_.f_46443_ && (mgr = NetworkManager.get(this.f_58857_)).getPipe(this.f_58858_) == null) {
            mgr.addPipe(this.createPipe(this.f_58857_, this.f_58858_));
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.unloaded = true;
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.f_58857_.f_46443_ && !this.unloaded) {
            NetworkManager mgr = NetworkManager.get(this.f_58857_);
            Pipe pipe = mgr.getPipe(this.f_58858_);
            if (pipe != null) {
                this.spawnDrops(pipe);
                for (Attachment attachment : pipe.getAttachmentManager().getAttachments()) {
                    Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)attachment.getDrop());
                }
            }
            mgr.removePipe(this.f_58858_);
        }
    }

    protected void spawnDrops(Pipe pipe) {
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ATTACHMENTS_PROPERTY, (Object)this.getAttachmentManager().getState()).build();
    }

    @Override
    public CompoundTag writeUpdate(CompoundTag tag) {
        this.getAttachmentManager().writeUpdate(tag);
        return tag;
    }

    @Override
    public void readUpdate(@Nullable CompoundTag tag) {
        this.getAttachmentManager().readUpdate(tag);
        this.requestModelDataUpdate();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
    }

    protected abstract Pipe createPipe(Level var1, BlockPos var2);
}

