/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private final ForgeConfigSpec spec;
    private final ItemPipe basicItemPipe;
    private final ItemPipe improvedItemPipe;
    private final ItemPipe advancedItemPipe;
    private final FluidPipe basicFluidPipe;
    private final FluidPipe improvedFluidPipe;
    private final FluidPipe advancedFluidPipe;
    private final FluidPipe eliteFluidPipe;
    private final FluidPipe ultimateFluidPipe;
    private final EnergyPipe basicEnergyPipe;
    private final EnergyPipe improvedEnergyPipe;
    private final EnergyPipe advancedEnergyPipe;
    private final EnergyPipe eliteEnergyPipe;
    private final EnergyPipe ultimateEnergyPipe;
    private final ExtractorAttachment basicExtractorAttachment;
    private final ExtractorAttachment improvedExtractorAttachment;
    private final ExtractorAttachment advancedExtractorAttachment;
    private final ExtractorAttachment eliteExtractorAttachment;
    private final ExtractorAttachment ultimateExtractorAttachment;

    public ServerConfig() {
        this.builder.push("pipe");
        this.builder.push("item");
        this.basicItemPipe = new ItemPipe("basic", 30);
        this.improvedItemPipe = new ItemPipe("improved", 20);
        this.advancedItemPipe = new ItemPipe("advanced", 10);
        this.builder.pop();
        this.builder.push("fluid");
        this.basicFluidPipe = new FluidPipe("basic", 1000, 100);
        this.improvedFluidPipe = new FluidPipe("improved", 4000, 400);
        this.advancedFluidPipe = new FluidPipe("advanced", 8000, 800);
        this.eliteFluidPipe = new FluidPipe("elite", 16000, 1600);
        this.ultimateFluidPipe = new FluidPipe("ultimate", 32000, 3200);
        this.builder.pop();
        this.builder.push("energy");
        this.basicEnergyPipe = new EnergyPipe("basic", 1000, 1000);
        this.improvedEnergyPipe = new EnergyPipe("improved", 4000, 4000);
        this.advancedEnergyPipe = new EnergyPipe("advanced", 8000, 8000);
        this.eliteEnergyPipe = new EnergyPipe("elite", 16000, 16000);
        this.ultimateEnergyPipe = new EnergyPipe("ultimate", 32000, 32000);
        this.builder.pop();
        this.builder.push("attachment");
        this.builder.push("extractor");
        this.basicExtractorAttachment = new ExtractorAttachment("basic", 60, 8, 0, 100, 0, false, false, false, false);
        this.improvedExtractorAttachment = new ExtractorAttachment("improved", 40, 16, 0, 400, 4, true, false, false, true);
        this.advancedExtractorAttachment = new ExtractorAttachment("advanced", 20, 32, 0, 800, 8, true, true, true, true);
        this.eliteExtractorAttachment = new ExtractorAttachment("elite", 10, 64, 0, 1600, 12, true, true, true, true);
        this.ultimateExtractorAttachment = new ExtractorAttachment("ultimate", 10, 64, 0, 3200, 15, true, true, true, true);
        this.builder.pop();
        this.builder.pop();
        this.builder.pop();
        this.spec = this.builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public ItemPipe getBasicItemPipe() {
        return this.basicItemPipe;
    }

    public ItemPipe getImprovedItemPipe() {
        return this.improvedItemPipe;
    }

    public ItemPipe getAdvancedItemPipe() {
        return this.advancedItemPipe;
    }

    public FluidPipe getBasicFluidPipe() {
        return this.basicFluidPipe;
    }

    public FluidPipe getImprovedFluidPipe() {
        return this.improvedFluidPipe;
    }

    public FluidPipe getAdvancedFluidPipe() {
        return this.advancedFluidPipe;
    }

    public FluidPipe getEliteFluidPipe() {
        return this.eliteFluidPipe;
    }

    public FluidPipe getUltimateFluidPipe() {
        return this.ultimateFluidPipe;
    }

    public EnergyPipe getBasicEnergyPipe() {
        return this.basicEnergyPipe;
    }

    public EnergyPipe getImprovedEnergyPipe() {
        return this.improvedEnergyPipe;
    }

    public EnergyPipe getAdvancedEnergyPipe() {
        return this.advancedEnergyPipe;
    }

    public EnergyPipe getEliteEnergyPipe() {
        return this.eliteEnergyPipe;
    }

    public EnergyPipe getUltimateEnergyPipe() {
        return this.ultimateEnergyPipe;
    }

    public ExtractorAttachment getBasicExtractorAttachment() {
        return this.basicExtractorAttachment;
    }

    public ExtractorAttachment getImprovedExtractorAttachment() {
        return this.improvedExtractorAttachment;
    }

    public ExtractorAttachment getAdvancedExtractorAttachment() {
        return this.advancedExtractorAttachment;
    }

    public ExtractorAttachment getEliteExtractorAttachment() {
        return this.eliteExtractorAttachment;
    }

    public ExtractorAttachment getUltimateExtractorAttachment() {
        return this.ultimateExtractorAttachment;
    }

    public class ItemPipe {
        private final ForgeConfigSpec.IntValue maxTicks;

        public ItemPipe(String type, int defaultMaxTicks) {
            ServerConfig.this.builder.push(type);
            this.maxTicks = ServerConfig.this.builder.comment("The maximum amount of ticks that items can be in the pipe. Lower is faster.").defineInRange("maxTicks", defaultMaxTicks, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getMaxTicks() {
            return (Integer)this.maxTicks.get();
        }
    }

    public class FluidPipe {
        private final ForgeConfigSpec.IntValue capacity;
        private final ForgeConfigSpec.IntValue transferRate;

        public FluidPipe(String type, int defaultCapacity, int defaultTransferRate) {
            ServerConfig.this.builder.push(type);
            this.capacity = ServerConfig.this.builder.comment("The capacity in mB of the pipe.").defineInRange("capacity", defaultCapacity, 0, Integer.MAX_VALUE);
            this.transferRate = ServerConfig.this.builder.comment("The transfer rate in mB/t of the pipe.").defineInRange("transferRate", defaultTransferRate, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getCapacity() {
            return (Integer)this.capacity.get();
        }

        public int getTransferRate() {
            return (Integer)this.transferRate.get();
        }
    }

    public class EnergyPipe {
        private final ForgeConfigSpec.IntValue capacity;
        private final ForgeConfigSpec.IntValue transferRate;

        public EnergyPipe(String type, int defaultCapacity, int defaultTransferRate) {
            ServerConfig.this.builder.push(type);
            this.capacity = ServerConfig.this.builder.comment("The capacity in FE of the pipe.").defineInRange("capacity", defaultCapacity, 0, Integer.MAX_VALUE);
            this.transferRate = ServerConfig.this.builder.comment("The transfer rate in FE/t of the pipe.").defineInRange("transferRate", defaultTransferRate, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getCapacity() {
            return (Integer)this.capacity.get();
        }

        public int getTransferRate() {
            return (Integer)this.transferRate.get();
        }
    }

    public class ExtractorAttachment {
        private final ForgeConfigSpec.IntValue itemTickInterval;
        private final ForgeConfigSpec.IntValue itemsToExtract;
        private final ForgeConfigSpec.IntValue fluidTickInterval;
        private final ForgeConfigSpec.IntValue fluidsToExtract;
        private final ForgeConfigSpec.IntValue filterSlots;
        private final ForgeConfigSpec.BooleanValue canSetRedstoneMode;
        private final ForgeConfigSpec.BooleanValue canSetWhitelistBlacklist;
        private final ForgeConfigSpec.BooleanValue canSetRoutingMode;
        private final ForgeConfigSpec.BooleanValue canSetExactMode;

        public ExtractorAttachment(String type, int defaultItemTickInterval, int defaultItemsToExtract, int defaultFluidTickInterval, int defaultFluidsToExtract, int defaultFilterSlots, boolean defaultCanSetRedstoneMode, boolean defaultCanSetWhitelistBlacklist, boolean defaultCanSetRoutingMode, boolean defaultCanSetExactMode) {
            ServerConfig.this.builder.push(type);
            this.itemTickInterval = ServerConfig.this.builder.comment("The interval between item extractions in ticks. Lower is faster.").defineInRange("itemTickInterval", defaultItemTickInterval, 0, Integer.MAX_VALUE);
            this.itemsToExtract = ServerConfig.this.builder.comment("The amount of items to extract per extraction.").defineInRange("itemsToExtract", defaultItemsToExtract, 0, 64);
            this.fluidTickInterval = ServerConfig.this.builder.comment("The interval between fluid extractions in ticks. Lower is faster.").defineInRange("fluidTickInterval", defaultFluidTickInterval, 0, Integer.MAX_VALUE);
            this.fluidsToExtract = ServerConfig.this.builder.comment("The amount of fluids in mB to extract per extraction.").defineInRange("fluidsToExtract", defaultFluidsToExtract, 0, Integer.MAX_VALUE);
            this.filterSlots = ServerConfig.this.builder.comment("The amount of filter slots allowed.").defineInRange("filterSlots", defaultFilterSlots, 0, 15);
            this.canSetRedstoneMode = ServerConfig.this.builder.comment("Whether the redstone mode can be configured for this extractor.").define("canSetRedstoneMode", defaultCanSetRedstoneMode);
            this.canSetWhitelistBlacklist = ServerConfig.this.builder.comment("Whether the extractor can be toggled between whitelist and blacklist.").define("canSetWhitelistBlacklist", defaultCanSetWhitelistBlacklist);
            this.canSetRoutingMode = ServerConfig.this.builder.comment("Whether the extractor can be toggled between routing modes.").define("canSetRoutingMode", defaultCanSetRoutingMode);
            this.canSetExactMode = ServerConfig.this.builder.comment("Whether the extractor can toggle exact mode.").define("canSetExactMode", defaultCanSetExactMode);
            ServerConfig.this.builder.pop();
        }

        public int getItemTickInterval() {
            return (Integer)this.itemTickInterval.get();
        }

        public int getItemsToExtract() {
            return (Integer)this.itemsToExtract.get();
        }

        public int getFluidTickInterval() {
            return (Integer)this.fluidTickInterval.get();
        }

        public int getFluidsToExtract() {
            return (Integer)this.fluidsToExtract.get();
        }

        public int getFilterSlots() {
            return (Integer)this.filterSlots.get();
        }

        public boolean getCanSetRedstoneMode() {
            return (Boolean)this.canSetRedstoneMode.get();
        }

        public boolean getCanSetWhitelistBlacklist() {
            return (Boolean)this.canSetWhitelistBlacklist.get();
        }

        public boolean getCanSetRoutingMode() {
            return (Boolean)this.canSetRoutingMode.get();
        }

        public boolean getCanSetExactMode() {
            return (Boolean)this.canSetExactMode.get();
        }
    }
}

