/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network;

import com.refinedmods.refinedpipes.network.Network;
import com.refinedmods.refinedpipes.network.NetworkFactory;
import com.refinedmods.refinedpipes.network.NetworkRegistry;
import com.refinedmods.refinedpipes.network.graph.NetworkGraphScannerResult;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.network.pipe.PipeFactory;
import com.refinedmods.refinedpipes.network.pipe.PipeRegistry;
import com.refinedmods.refinedpipes.network.pipe.item.ItemPipe;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkManager
extends SavedData {
    private static final String NAME = "refinedpipes_networks";
    private static final Logger LOGGER = LogManager.getLogger(NetworkManager.class);
    private final Level level;
    private final Map<String, Network> networks = new HashMap<String, Network>();
    private final Map<BlockPos, Pipe> pipes = new HashMap<BlockPos, Pipe>();

    public NetworkManager(Level level) {
        this.level = level;
    }

    public static NetworkManager get(Level level) {
        return NetworkManager.get((ServerLevel)level);
    }

    public static NetworkManager get(ServerLevel level) {
        return (NetworkManager)level.m_8895_().m_164861_(tag -> {
            NetworkManager networkManager = new NetworkManager((Level)level);
            networkManager.load((CompoundTag)tag);
            return networkManager;
        }, () -> new NetworkManager((Level)level), NAME);
    }

    public void addNetwork(Network network) {
        if (this.networks.containsKey(network.getId())) {
            throw new RuntimeException("Duplicate network " + network.getId());
        }
        this.networks.put(network.getId(), network);
        LOGGER.debug("Network {} created", (Object)network.getId());
        this.m_77762_();
    }

    public void removeNetwork(String id) {
        if (!this.networks.containsKey(id)) {
            throw new RuntimeException("Network " + id + " not found");
        }
        this.networks.remove(id);
        LOGGER.debug("Network {} removed", (Object)id);
        this.m_77762_();
    }

    private void formNetworkAt(Level level, BlockPos pos, ResourceLocation type) {
        Network network = NetworkRegistry.INSTANCE.getFactory(type).create(pos);
        this.addNetwork(network);
        network.scanGraph(level, pos);
    }

    private void mergeNetworksIntoOne(Set<Pipe> candidates, Level level, BlockPos pos) {
        if (candidates.isEmpty()) {
            throw new RuntimeException("Cannot merge networks: no candidates");
        }
        HashSet<Network> networkCandidates = new HashSet<Network>();
        for (Pipe candidate : candidates) {
            if (candidate.getNetwork() == null) {
                throw new RuntimeException("Pipe network is null!");
            }
            networkCandidates.add(candidate.getNetwork());
        }
        Iterator networks = networkCandidates.iterator();
        Network mainNetwork = (Network)networks.next();
        HashSet<Network> mergedNetworks = new HashSet<Network>();
        while (networks.hasNext()) {
            Network otherNetwork = (Network)networks.next();
            boolean canMerge = mainNetwork.getType().equals((Object)otherNetwork.getType());
            if (!canMerge) continue;
            mergedNetworks.add(otherNetwork);
            this.removeNetwork(otherNetwork.getId());
        }
        mainNetwork.scanGraph(level, pos);
        mergedNetworks.forEach(n -> n.onMergedWith(mainNetwork));
    }

    public void addPipe(Pipe pipe) {
        if (this.pipes.containsKey(pipe.getPos())) {
            throw new RuntimeException("Pipe at " + pipe.getPos() + " already exists");
        }
        this.pipes.put(pipe.getPos(), pipe);
        LOGGER.debug("Pipe added at {}", (Object)pipe.getPos());
        this.m_77762_();
        Set<Pipe> adjacentPipes = this.findAdjacentPipes(pipe.getPos(), pipe.getNetworkType());
        if (adjacentPipes.isEmpty()) {
            this.formNetworkAt(pipe.getLevel(), pipe.getPos(), pipe.getNetworkType());
        } else {
            this.mergeNetworksIntoOne(adjacentPipes, pipe.getLevel(), pipe.getPos());
        }
    }

    public void removePipe(BlockPos pos) {
        Pipe pipe = this.getPipe(pos);
        if (pipe == null) {
            throw new RuntimeException("Pipe at " + pos + " was not found");
        }
        if (pipe.getNetwork() == null) {
            LOGGER.warn("Removed pipe at {} has no associated network", (Object)pipe.getPos());
        }
        this.pipes.remove(pipe.getPos());
        LOGGER.debug("Pipe removed at {}", (Object)pipe.getPos());
        this.m_77762_();
        if (pipe.getNetwork() != null) {
            this.splitNetworks(pipe);
        }
    }

    private void splitNetworks(Pipe originPipe) {
        for (Pipe adjacent : this.findAdjacentPipes(originPipe.getPos(), originPipe.getNetworkType())) {
            if (adjacent.getNetwork() == null) {
                throw new RuntimeException("Adjacent pipe has no network");
            }
            if (adjacent.getNetwork() == originPipe.getNetwork()) continue;
            throw new RuntimeException("The origin pipe network is different than the adjacent pipe network");
        }
        Pipe otherPipeInNetwork = this.findFirstAdjacentPipe(originPipe.getPos(), originPipe.getNetworkType());
        if (otherPipeInNetwork != null) {
            otherPipeInNetwork.getNetwork().setOriginPos(otherPipeInNetwork.getPos());
            this.m_77762_();
            NetworkGraphScannerResult result = otherPipeInNetwork.getNetwork().scanGraph(otherPipeInNetwork.getLevel(), otherPipeInNetwork.getPos());
            boolean foundRemovedPipe = false;
            for (Pipe removed : result.getRemovedPipes()) {
                if (removed.getPos().equals((Object)originPipe.getPos())) {
                    foundRemovedPipe = true;
                    continue;
                }
                if (removed.getNetwork() != null) continue;
                this.formNetworkAt(removed.getLevel(), removed.getPos(), removed.getNetworkType());
            }
            if (!foundRemovedPipe) {
                throw new RuntimeException("Didn't find removed pipe when splitting network");
            }
        } else {
            LOGGER.debug("Removing empty network {}", (Object)originPipe.getNetwork().getId());
            this.removeNetwork(originPipe.getNetwork().getId());
        }
    }

    private Set<Pipe> findAdjacentPipes(BlockPos pos, ResourceLocation networkType) {
        HashSet<Pipe> pipes = new HashSet<Pipe>();
        for (Direction dir : Direction.values()) {
            Pipe pipe = this.getPipe(pos.m_142300_(dir));
            if (pipe == null || !pipe.getNetworkType().equals((Object)networkType)) continue;
            pipes.add(pipe);
        }
        return pipes;
    }

    @Nullable
    private Pipe findFirstAdjacentPipe(BlockPos pos, ResourceLocation networkType) {
        for (Direction dir : Direction.values()) {
            Pipe pipe = this.getPipe(pos.m_142300_(dir));
            if (pipe == null || !pipe.getNetworkType().equals((Object)networkType)) continue;
            return pipe;
        }
        return null;
    }

    @Nullable
    public Pipe getPipe(BlockPos pos) {
        return this.pipes.get(pos);
    }

    public Collection<Network> getNetworks() {
        return this.networks.values();
    }

    public void load(CompoundTag tag) {
        ListTag pipes = tag.m_128437_("pipes", 10);
        for (Tag pipeTag : pipes) {
            CompoundTag pipeTagCompound = (CompoundTag)pipeTag;
            ResourceLocation factoryId = pipeTagCompound.m_128441_("id") ? new ResourceLocation(pipeTagCompound.m_128461_("id")) : ItemPipe.ID;
            PipeFactory factory = PipeRegistry.INSTANCE.getFactory(factoryId);
            if (factory == null) {
                LOGGER.warn("Pipe {} no longer exists", (Object)factoryId.toString());
                continue;
            }
            Pipe pipe = factory.createFromNbt(this.level, pipeTagCompound);
            this.pipes.put(pipe.getPos(), pipe);
        }
        ListTag nets = tag.m_128437_("networks", 10);
        for (Tag netTag : nets) {
            CompoundTag netTagCompound = (CompoundTag)netTag;
            if (!netTagCompound.m_128441_("type")) {
                LOGGER.warn("Skipping network without type");
                continue;
            }
            ResourceLocation type = new ResourceLocation(netTagCompound.m_128461_("type"));
            NetworkFactory factory = NetworkRegistry.INSTANCE.getFactory(type);
            if (factory == null) {
                LOGGER.warn("Unknown network type {}", (Object)type.toString());
                continue;
            }
            Network network = factory.create(netTagCompound);
            this.networks.put(network.getId(), network);
        }
        LOGGER.debug("Read {} pipes", (Object)pipes.size());
        LOGGER.debug("Read {} networks", (Object)this.networks.size());
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag pipes = new ListTag();
        this.pipes.values().forEach(p -> {
            CompoundTag pipeTag = new CompoundTag();
            pipeTag.m_128359_("id", p.getId().toString());
            pipes.add((Object)p.writeToNbt(pipeTag));
        });
        tag.m_128365_("pipes", (Tag)pipes);
        ListTag networks = new ListTag();
        this.networks.values().forEach(n -> {
            CompoundTag networkTag = new CompoundTag();
            networkTag.m_128359_("type", n.getType().toString());
            networks.add((Object)n.writeToNbt(networkTag));
        });
        tag.m_128365_("networks", (Tag)networks);
        return tag;
    }
}

