/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.item.routing;

import com.refinedmods.refinedpipes.network.item.routing.DestinationPathCache;
import com.refinedmods.refinedpipes.network.pipe.Destination;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.routing.DijkstraAlgorithm;
import com.refinedmods.refinedpipes.routing.Graph;
import com.refinedmods.refinedpipes.routing.Node;
import com.refinedmods.refinedpipes.routing.NodeIndex;
import com.refinedmods.refinedpipes.routing.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DestinationPathCacheFactory {
    private static final Logger LOGGER = LogManager.getLogger(DestinationPathCacheFactory.class);
    private final Graph<BlockPos> graph;
    private final NodeIndex<BlockPos> nodeIndex;
    private final List<Destination> destinations;

    public DestinationPathCacheFactory(Graph<BlockPos> graph, NodeIndex<BlockPos> nodeIndex, List<Destination> destinations) {
        this.graph = graph;
        this.nodeIndex = nodeIndex;
        this.destinations = destinations;
    }

    public DestinationPathCache create() {
        DestinationPathCache cache = new DestinationPathCache();
        for (Node<BlockPos> node : this.graph.getNodes()) {
            DijkstraAlgorithm<BlockPos> dijkstra = new DijkstraAlgorithm<BlockPos>(this.graph);
            dijkstra.execute(node);
            for (Destination destination : this.destinations) {
                if (destination.getConnectedPipe().getPos().equals((Object)node.getId())) {
                    ArrayList nodes = new ArrayList();
                    nodes.add(node);
                    cache.addPath(node.getId(), destination, new Path<BlockPos>(nodes));
                    continue;
                }
                Pipe connectedPipe = destination.getConnectedPipe();
                Node<BlockPos> connectedPipeNode = this.nodeIndex.getNode(connectedPipe.getPos());
                if (connectedPipeNode == null) {
                    LOGGER.error("Connected pipe has no node! At " + connectedPipe.getPos());
                    continue;
                }
                LinkedList path = dijkstra.getPath(connectedPipeNode);
                if (path != null) {
                    cache.addPath(node.getId(), destination, new Path<BlockPos>(path));
                    LOGGER.debug("Computed path from " + node.getId() + " to " + connectedPipeNode.getId() + " -> " + path.size() + " nodes");
                    continue;
                }
                LOGGER.error("Could not find path from " + node.getId() + " to " + connectedPipeNode.getId());
            }
        }
        return cache;
    }
}

