/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.attachment;

import com.refinedmods.refinedpipes.network.pipe.attachment.Attachment;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentManager;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ClientAttachmentManager
implements AttachmentManager {
    private final ResourceLocation[] attachmentState = new ResourceLocation[Direction.values().length];
    private final Map<Direction, ItemStack> pickBlocks = new HashMap<Direction, ItemStack>();

    @Override
    public ResourceLocation[] getState() {
        return this.attachmentState;
    }

    @Override
    public boolean hasAttachment(Direction dir) {
        return this.attachmentState[dir.ordinal()] != null;
    }

    @Override
    public void openAttachmentContainer(Direction dir, ServerPlayer player) {
        throw new RuntimeException("Server-side only");
    }

    @Override
    @Nonnull
    public ItemStack getPickBlock(Direction dir) {
        return this.pickBlocks.getOrDefault(dir, ItemStack.f_41583_);
    }

    @Override
    @Nullable
    public Attachment getAttachment(Direction dir) {
        throw new RuntimeException("Server-side only");
    }

    @Override
    public void writeUpdate(CompoundTag tag) {
        throw new RuntimeException("Server-side only");
    }

    @Override
    public void readUpdate(@Nullable CompoundTag tag) {
        this.pickBlocks.clear();
        for (Direction dir : Direction.values()) {
            String attachmentKey = "attch_" + dir.ordinal();
            String pickBlockKey = "pb_" + dir.ordinal();
            if (tag != null && (tag.m_128441_(attachmentKey) || tag.m_128441_(pickBlockKey))) {
                this.pickBlocks.put(dir, ItemStack.m_41712_((CompoundTag)tag.m_128469_(pickBlockKey)));
                this.attachmentState[dir.ordinal()] = new ResourceLocation(tag.m_128461_(attachmentKey));
                continue;
            }
            this.attachmentState[dir.ordinal()] = null;
        }
    }
}

