/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.attachment.extractor;

import com.refinedmods.refinedpipes.container.provider.ExtractorAttachmentMenuProvider;
import com.refinedmods.refinedpipes.inventory.fluid.FluidInventory;
import com.refinedmods.refinedpipes.network.Network;
import com.refinedmods.refinedpipes.network.NetworkManager;
import com.refinedmods.refinedpipes.network.fluid.FluidNetwork;
import com.refinedmods.refinedpipes.network.item.ItemNetwork;
import com.refinedmods.refinedpipes.network.pipe.Destination;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.network.pipe.attachment.Attachment;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.BlacklistWhitelist;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.ExtractorAttachmentType;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.ItemDestinationFinder;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RedstoneMode;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RoutingMode;
import com.refinedmods.refinedpipes.network.pipe.item.ItemPipe;
import com.refinedmods.refinedpipes.network.pipe.transport.ItemTransport;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.ItemBounceBackTransportCallback;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.ItemInsertTransportCallback;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.ItemPipeGoneTransportCallback;
import com.refinedmods.refinedpipes.routing.Path;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtractorAttachment
extends Attachment {
    public static final int MAX_FILTER_SLOTS = 15;
    private static final Logger LOGGER = LogManager.getLogger(ExtractorAttachment.class);
    private final ExtractorAttachmentType type;
    private final ItemStackHandler itemFilter;
    private final FluidInventory fluidFilter;
    private final ItemDestinationFinder itemDestinationFinder = new ItemDestinationFinder(this);
    private int ticks;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORED;
    private BlacklistWhitelist blacklistWhitelist = BlacklistWhitelist.BLACKLIST;
    private RoutingMode routingMode = RoutingMode.NEAREST;
    private int stackSize;
    private boolean exactMode = true;

    public ExtractorAttachment(Pipe pipe, Direction direction, ExtractorAttachmentType type) {
        super(pipe, direction);
        this.type = type;
        this.stackSize = type.getItemsToExtract();
        this.itemFilter = ExtractorAttachment.createItemFilterInventory(this);
        this.fluidFilter = ExtractorAttachment.createFluidFilterInventory(this);
    }

    public static ItemStackHandler createItemFilterInventory(final @Nullable ExtractorAttachment attachment) {
        return new ItemStackHandler(15){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (attachment != null) {
                    NetworkManager.get(attachment.pipe.getLevel()).m_77762_();
                }
            }
        };
    }

    public static FluidInventory createFluidFilterInventory(final @Nullable ExtractorAttachment attachment) {
        return new FluidInventory(15){

            @Override
            protected void onContentsChanged() {
                super.onContentsChanged();
                if (attachment != null) {
                    NetworkManager.get(attachment.pipe.getLevel()).m_77762_();
                }
            }
        };
    }

    public boolean isFluidMode() {
        return this.pipe.getNetwork() instanceof FluidNetwork;
    }

    @Override
    public void update() {
        Network network = this.pipe.getNetwork();
        int tickInterval = 0;
        if (network instanceof ItemNetwork) {
            tickInterval = this.type.getItemTickInterval();
        } else if (network instanceof FluidNetwork) {
            tickInterval = this.type.getFluidTickInterval();
        }
        if (tickInterval != 0 && this.ticks++ % tickInterval != 0) {
            return;
        }
        if (!this.redstoneMode.isEnabled(this.pipe.getLevel(), this.pipe.getPos())) {
            return;
        }
        BlockPos destinationPos = this.pipe.getPos().m_142300_(this.getDirection());
        BlockEntity blockEntity = this.pipe.getLevel().m_7702_(destinationPos);
        if (blockEntity == null) {
            return;
        }
        if (network instanceof ItemNetwork) {
            blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getDirection().m_122424_()).ifPresent(itemHandler -> this.update((ItemNetwork)network, destinationPos, (IItemHandler)itemHandler));
        } else if (network instanceof FluidNetwork) {
            blockEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getDirection().m_122424_()).ifPresent(fluidHandler -> this.update((FluidNetwork)network, (IFluidHandler)fluidHandler));
        }
    }

    private void update(ItemNetwork network, BlockPos sourcePos, IItemHandler source) {
        if (this.stackSize == 0) {
            return;
        }
        Pair<Destination, Integer> destinationAndSourceSlot = this.findDestinationAndSourceSlot(sourcePos, source);
        if (destinationAndSourceSlot == null) {
            return;
        }
        Destination destination = (Destination)destinationAndSourceSlot.getLeft();
        Path<BlockPos> path = network.getDestinationPathCache().getPath(this.pipe.getPos(), destination);
        if (path == null) {
            LOGGER.error("No path found from " + this.pipe.getPos() + " to " + destination);
            return;
        }
        ItemStack extracted = source.extractItem(((Integer)destinationAndSourceSlot.getRight()).intValue(), this.stackSize, false);
        if (extracted.m_41619_()) {
            return;
        }
        BlockPos fromPos = this.pipe.getPos().m_142300_(this.getDirection());
        ((ItemPipe)this.pipe).addTransport(new ItemTransport(extracted.m_41777_(), fromPos, destination.getReceiver(), path.toQueue(), new ItemInsertTransportCallback(destination.getReceiver(), destination.getIncomingDirection(), extracted), new ItemBounceBackTransportCallback(destination.getReceiver(), sourcePos, extracted), new ItemPipeGoneTransportCallback(extracted)));
    }

    private Pair<Destination, Integer> findDestinationAndSourceSlot(BlockPos sourcePos, IItemHandler source) {
        if (source.getSlots() <= 0) {
            return null;
        }
        int startIndex = 0;
        do {
            ItemStack slot;
            if ((slot = source.getStackInSlot(startIndex)).m_41619_() || !this.acceptsItem(slot)) {
                ++startIndex;
                continue;
            }
            ItemStack extracted = source.extractItem(startIndex, this.stackSize, true);
            if (extracted.m_41619_()) {
                ++startIndex;
                continue;
            }
            Destination destination = this.itemDestinationFinder.find(this.routingMode, sourcePos, extracted);
            if (destination == null) {
                ++startIndex;
                continue;
            }
            return Pair.of((Object)destination, (Object)startIndex);
        } while (startIndex < source.getSlots());
        return null;
    }

    private void update(FluidNetwork network, IFluidHandler source) {
        FluidStack drained = source.drain(this.type.getFluidsToExtract(), IFluidHandler.FluidAction.SIMULATE);
        if (drained.isEmpty()) {
            return;
        }
        if (!this.acceptsFluid(drained)) {
            return;
        }
        int filled = network.getFluidTank().fill(drained, IFluidHandler.FluidAction.SIMULATE);
        if (filled <= 0) {
            return;
        }
        int toDrain = Math.min(this.type.getFluidsToExtract(), filled);
        drained = source.drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
        network.getFluidTank().fill(drained, IFluidHandler.FluidAction.EXECUTE);
        NetworkManager.get(this.pipe.getLevel()).m_77762_();
    }

    private boolean acceptsItem(ItemStack stack) {
        if (this.blacklistWhitelist == BlacklistWhitelist.WHITELIST) {
            for (int i = 0; i < this.itemFilter.getSlots(); ++i) {
                ItemStack filtered = this.itemFilter.getStackInSlot(i);
                boolean equals = filtered.m_41656_(stack);
                if (this.exactMode) {
                    boolean bl = equals = equals && ItemStack.m_41658_((ItemStack)filtered, (ItemStack)stack);
                }
                if (!equals) continue;
                return true;
            }
            return false;
        }
        if (this.blacklistWhitelist == BlacklistWhitelist.BLACKLIST) {
            for (int i = 0; i < this.itemFilter.getSlots(); ++i) {
                ItemStack filtered = this.itemFilter.getStackInSlot(i);
                boolean equals = filtered.m_41656_(stack);
                if (this.exactMode) {
                    boolean bl = equals = equals && ItemStack.m_41658_((ItemStack)filtered, (ItemStack)stack);
                }
                if (!equals) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean acceptsFluid(FluidStack stack) {
        if (this.blacklistWhitelist == BlacklistWhitelist.WHITELIST) {
            for (int i = 0; i < this.fluidFilter.getSlots(); ++i) {
                boolean equals;
                FluidStack filtered = this.fluidFilter.getFluid(i);
                boolean bl = equals = filtered.getFluid() == stack.getFluid();
                if (this.exactMode) {
                    boolean bl2 = equals = equals && FluidStack.areFluidStackTagsEqual((FluidStack)filtered, (FluidStack)stack);
                }
                if (!equals) continue;
                return true;
            }
            return false;
        }
        if (this.blacklistWhitelist == BlacklistWhitelist.BLACKLIST) {
            for (int i = 0; i < this.fluidFilter.getSlots(); ++i) {
                boolean equals;
                FluidStack filtered = this.fluidFilter.getFluid(i);
                boolean bl = equals = filtered.getFluid() == stack.getFluid();
                if (this.exactMode) {
                    boolean bl3 = equals = equals && FluidStack.areFluidStackTagsEqual((FluidStack)filtered, (FluidStack)stack);
                }
                if (!equals) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void openContainer(ServerPlayer player) {
        super.openContainer(player);
        ExtractorAttachmentMenuProvider.open(this.pipe, this, player);
    }

    @Override
    public ResourceLocation getId() {
        return this.type.getId();
    }

    @Override
    public ItemStack getDrop() {
        return new ItemStack((ItemLike)this.type.getItem());
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        tag.m_128344_("rm", (byte)this.redstoneMode.ordinal());
        tag.m_128365_("itemfilter", (Tag)this.itemFilter.serializeNBT());
        tag.m_128344_("bw", (byte)this.blacklistWhitelist.ordinal());
        tag.m_128405_("rr", this.itemDestinationFinder.getRoundRobinIndex());
        tag.m_128344_("routingm", (byte)this.routingMode.ordinal());
        tag.m_128405_("stacksi", this.stackSize);
        tag.m_128379_("exa", this.exactMode);
        tag.m_128365_("fluidfilter", (Tag)this.fluidFilter.writeToNbt());
        return super.writeToNbt(tag);
    }

    public ExtractorAttachmentType getType() {
        return this.type;
    }

    public ItemStackHandler getItemFilter() {
        return this.itemFilter;
    }

    public FluidInventory getFluidFilter() {
        return this.fluidFilter;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        if (!this.type.getCanSetRedstoneMode()) {
            return;
        }
        this.redstoneMode = redstoneMode;
    }

    public BlacklistWhitelist getBlacklistWhitelist() {
        return this.blacklistWhitelist;
    }

    public void setBlacklistWhitelist(BlacklistWhitelist blacklistWhitelist) {
        if (!this.type.getCanSetWhitelistBlacklist()) {
            return;
        }
        this.blacklistWhitelist = blacklistWhitelist;
    }

    public RoutingMode getRoutingMode() {
        return this.routingMode;
    }

    public void setRoutingMode(RoutingMode routingMode) {
        if (!this.type.getCanSetRoutingMode()) {
            return;
        }
        this.routingMode = routingMode;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public void setStackSize(int stackSize) {
        if (stackSize < 0) {
            stackSize = 0;
        }
        if (stackSize > this.type.getItemsToExtract()) {
            stackSize = this.type.getItemsToExtract();
        }
        this.stackSize = stackSize;
    }

    public void setRoundRobinIndex(int roundRobinIndex) {
        this.itemDestinationFinder.setRoundRobinIndex(roundRobinIndex);
    }

    public boolean isExactMode() {
        return this.exactMode;
    }

    public void setExactMode(boolean exactMode) {
        if (!this.type.getCanSetExactMode()) {
            return;
        }
        this.exactMode = exactMode;
    }
}

