/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.fluid;

import com.refinedmods.refinedpipes.RefinedPipes;
import com.refinedmods.refinedpipes.message.FluidPipeMessage;
import com.refinedmods.refinedpipes.network.fluid.FluidNetwork;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.network.pipe.fluid.FluidPipeType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class FluidPipe
extends Pipe {
    public static final ResourceLocation ID = new ResourceLocation("refinedpipes", "fluid");
    private final FluidPipeType type;
    private float lastFullness = 0.0f;

    public FluidPipe(Level level, BlockPos pos, FluidPipeType type) {
        super(level, pos);
        this.type = type;
    }

    @Override
    public void update() {
        super.update();
        float f = this.getFullness();
        if ((double)Math.abs(this.lastFullness - f) >= 0.1) {
            this.lastFullness = f;
            this.sendFluidPipeUpdate();
        }
    }

    public void sendFluidPipeUpdate() {
        RefinedPipes.NETWORK.sendInArea(this.level, this.pos, 32, new FluidPipeMessage(this.pos, ((FluidNetwork)this.network).getFluidTank().getFluid(), this.getFullness()));
    }

    public float getFullness() {
        int cap = ((FluidNetwork)this.network).getFluidTank().getCapacity();
        int stored = ((FluidNetwork)this.network).getFluidTank().getFluidAmount();
        return (float)Math.round((float)stored / (float)cap * 10.0f) / 10.0f;
    }

    public FluidPipeType getType() {
        return this.type;
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        tag = super.writeToNbt(tag);
        tag.m_128405_("type", this.type.ordinal());
        return tag;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ResourceLocation getNetworkType() {
        return this.type.getNetworkType();
    }
}

