/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.item;

import com.refinedmods.refinedpipes.RefinedPipes;
import com.refinedmods.refinedpipes.message.ItemTransportMessage;
import com.refinedmods.refinedpipes.network.NetworkManager;
import com.refinedmods.refinedpipes.network.item.ItemNetwork;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.network.pipe.item.ItemPipeType;
import com.refinedmods.refinedpipes.network.pipe.transport.ItemTransport;
import com.refinedmods.refinedpipes.network.pipe.transport.ItemTransportProps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class ItemPipe
extends Pipe {
    public static final ResourceLocation ID = new ResourceLocation("refinedpipes", "item");
    private final List<ItemTransport> transports = new ArrayList<ItemTransport>();
    private final List<ItemTransport> transportsToAdd = new ArrayList<ItemTransport>();
    private final List<ItemTransport> transportsToRemove = new ArrayList<ItemTransport>();
    private final ItemPipeType type;

    public ItemPipe(Level level, BlockPos pos, ItemPipeType type) {
        super(level, pos);
        this.type = type;
    }

    @Override
    public void update() {
        super.update();
        this.transports.addAll(this.transportsToAdd);
        this.transports.removeAll(this.transportsToRemove);
        if (!this.transportsToAdd.isEmpty() || !this.transportsToRemove.isEmpty()) {
            NetworkManager.get(this.level).m_77762_();
            this.sendTransportUpdate();
        }
        if (!this.transports.isEmpty()) {
            NetworkManager.get(this.level).m_77762_();
        }
        this.transportsToAdd.clear();
        this.transportsToRemove.clear();
        if (this.transports.removeIf(t -> t.update(this.network, this))) {
            NetworkManager.get(this.level).m_77762_();
        }
    }

    public List<ItemTransport> getTransports() {
        return this.transports;
    }

    public void addTransport(ItemTransport transport) {
        this.transportsToAdd.add(transport);
    }

    public void removeTransport(ItemTransport transport) {
        this.transportsToRemove.add(transport);
    }

    public void sendTransportUpdate() {
        ArrayList<ItemTransportProps> props = new ArrayList<ItemTransportProps>();
        for (ItemTransport transport : this.transports) {
            props.add(transport.createProps(this));
        }
        RefinedPipes.NETWORK.sendInArea(this.level, this.pos, 32, new ItemTransportMessage(this.pos, props));
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        tag = super.writeToNbt(tag);
        tag.m_128405_("type", this.type.ordinal());
        ListTag transports = new ListTag();
        for (ItemTransport transport : this.transports) {
            transports.add((Object)transport.writeToNbt(new CompoundTag()));
        }
        tag.m_128365_("transports", (Tag)transports);
        return tag;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ResourceLocation getNetworkType() {
        return ItemNetwork.TYPE;
    }

    public int getMaxTicksInPipe() {
        return this.type.getMaxTicksInPipe();
    }
}

