/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.shape;

import com.refinedmods.refinedpipes.blockentity.PipeBlockEntity;
import com.refinedmods.refinedpipes.item.AttachmentItem;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentFactory;
import com.refinedmods.refinedpipes.network.pipe.shape.PipeShapeCacheEntry;
import com.refinedmods.refinedpipes.network.pipe.shape.PipeShapeFactory;
import com.refinedmods.refinedpipes.network.pipe.shape.PipeShapeProps;
import com.refinedmods.refinedpipes.util.Raytracer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class PipeShapeCache {
    private static final ResourceLocation[] NO_ATTACHMENT_STATE = new ResourceLocation[Direction.values().length];
    private final PipeShapeFactory shapeFactory;
    private final List<AABB> attachmentShapes = new ArrayList<AABB>();
    private final Map<PipeShapeCacheEntry, VoxelShape> cache = new HashMap<PipeShapeCacheEntry, VoxelShape>();

    public PipeShapeCache(PipeShapeFactory shapeFactory) {
        this.shapeFactory = shapeFactory;
        this.attachmentShapes.add(PipeShapeProps.NORTH_ATTACHMENT_SHAPE.m_83215_());
        this.attachmentShapes.add(PipeShapeProps.EAST_ATTACHMENT_SHAPE.m_83215_());
        this.attachmentShapes.add(PipeShapeProps.SOUTH_ATTACHMENT_SHAPE.m_83215_());
        this.attachmentShapes.add(PipeShapeProps.WEST_ATTACHMENT_SHAPE.m_83215_());
        this.attachmentShapes.add(PipeShapeProps.UP_ATTACHMENT_SHAPE.m_83215_());
        this.attachmentShapes.add(PipeShapeProps.DOWN_ATTACHMENT_SHAPE.m_83215_());
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        Player player;
        Item inHand;
        EntityCollisionContext entityCollisionContext;
        Entity entity;
        VoxelShape shape = this.createShapeIfNeeded(state, world, pos);
        if (ctx instanceof EntityCollisionContext && (entity = (entityCollisionContext = (EntityCollisionContext)ctx).m_193113_()) instanceof Player && (inHand = (player = (Player)entity).m_21205_().m_41720_()) instanceof AttachmentItem) {
            shape = this.addFakeAttachmentShape(state.m_60734_(), pos, (Entity)player, shape, ((AttachmentItem)inHand).getFactory());
        }
        return shape;
    }

    private VoxelShape addFakeAttachmentShape(Block block, BlockPos pos, Entity entity, VoxelShape shape, AttachmentFactory type) {
        if (!type.canPlaceOnPipe(block)) {
            return shape;
        }
        Pair<Vec3, Vec3> vec = Raytracer.getVectors(entity);
        Raytracer.AdvancedRayTraceResult<BlockHitResult> result = Raytracer.collisionRayTrace(pos, (Vec3)vec.getLeft(), (Vec3)vec.getRight(), this.attachmentShapes);
        if (result != null) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)result.bounds));
        }
        return shape;
    }

    private VoxelShape createShapeIfNeeded(BlockState state, BlockGetter world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        ResourceLocation[] attachmentState = blockEntity instanceof PipeBlockEntity ? ((PipeBlockEntity)blockEntity).getAttachmentManager().getState() : NO_ATTACHMENT_STATE;
        PipeShapeCacheEntry entry = new PipeShapeCacheEntry(state, attachmentState);
        return this.cache.computeIfAbsent(entry, e -> this.shapeFactory.createShape(e.getState(), e.getAttachmentState()));
    }
}

