/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.transport;

import com.refinedmods.refinedpipes.network.Network;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.network.pipe.item.ItemPipe;
import com.refinedmods.refinedpipes.network.pipe.transport.ItemTransportProps;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.TransportCallback;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.TransportCallbackFactory;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.TransportCallbackFactoryRegistry;
import com.refinedmods.refinedpipes.util.DirectionUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemTransport {
    private static final Logger LOGGER = LogManager.getLogger(ItemTransport.class);
    private final ItemStack value;
    private final BlockPos source;
    private final BlockPos destination;
    private final Deque<BlockPos> path;
    private final Direction initialDirection;
    private final TransportCallback finishedCallback;
    private final TransportCallback cancelCallback;
    private final TransportCallback pipeGoneCallback;
    private boolean firstPipe = true;
    private int progressInCurrentPipe;

    public ItemTransport(ItemStack value, BlockPos source, BlockPos destination, Deque<BlockPos> path, TransportCallback finishedCallback, TransportCallback cancelCallback, TransportCallback pipeGoneCallback) {
        this.value = value;
        this.source = source;
        this.destination = destination;
        this.path = path;
        this.initialDirection = ItemTransport.getDirection(source, path.peek());
        this.path.poll();
        this.finishedCallback = finishedCallback;
        this.cancelCallback = cancelCallback;
        this.pipeGoneCallback = pipeGoneCallback;
    }

    public ItemTransport(ItemStack value, BlockPos source, BlockPos destination, Deque<BlockPos> path, Direction initialDirection, TransportCallback finishedCallback, TransportCallback cancelCallback, TransportCallback pipeGoneCallback, boolean firstPipe, int progressInCurrentPipe) {
        this.value = value;
        this.source = source;
        this.destination = destination;
        this.path = path;
        this.initialDirection = initialDirection;
        this.finishedCallback = finishedCallback;
        this.cancelCallback = cancelCallback;
        this.pipeGoneCallback = pipeGoneCallback;
        this.firstPipe = firstPipe;
        this.progressInCurrentPipe = progressInCurrentPipe;
    }

    private static Direction getDirection(BlockPos a, BlockPos b) {
        if (a.m_142300_(Direction.NORTH).equals((Object)b)) {
            return Direction.NORTH;
        }
        if (a.m_142300_(Direction.EAST).equals((Object)b)) {
            return Direction.EAST;
        }
        if (a.m_142300_(Direction.SOUTH).equals((Object)b)) {
            return Direction.SOUTH;
        }
        if (a.m_142300_(Direction.WEST).equals((Object)b)) {
            return Direction.WEST;
        }
        if (a.m_142300_(Direction.UP).equals((Object)b)) {
            return Direction.UP;
        }
        if (a.m_142300_(Direction.DOWN).equals((Object)b)) {
            return Direction.DOWN;
        }
        return Direction.NORTH;
    }

    @Nullable
    public static ItemTransport of(CompoundTag tag) {
        ItemStack value = ItemStack.m_41712_((CompoundTag)tag.m_128469_("v"));
        if (value.m_41619_()) {
            LOGGER.warn("Item no longer exists");
            return null;
        }
        BlockPos source = BlockPos.m_122022_((long)tag.m_128454_("src"));
        BlockPos destination = BlockPos.m_122022_((long)tag.m_128454_("dst"));
        ListTag pathTag = tag.m_128437_("pth", 4);
        ArrayDeque<BlockPos> path = new ArrayDeque<BlockPos>();
        for (Tag pathItem : pathTag) {
            path.add(BlockPos.m_122022_((long)((LongTag)pathItem).m_7046_()));
        }
        Direction initialDirection = DirectionUtil.safeGet((byte)tag.m_128451_("initd"));
        ResourceLocation finishedCallbackId = new ResourceLocation(tag.m_128461_("fcid"));
        TransportCallbackFactory finishedCallbackFactory = TransportCallbackFactoryRegistry.INSTANCE.getFactory(finishedCallbackId);
        if (finishedCallbackFactory == null) {
            LOGGER.warn("Finished callback factory " + finishedCallbackId + " no longer exists");
            return null;
        }
        TransportCallback finishedCallback = finishedCallbackFactory.create(tag.m_128469_("fc"));
        if (finishedCallback == null) {
            LOGGER.warn("Finished callback factory " + finishedCallbackId + " returned null!");
            return null;
        }
        ResourceLocation cancelCallbackId = new ResourceLocation(tag.m_128461_("ccid"));
        TransportCallbackFactory cancelCallbackFactory = TransportCallbackFactoryRegistry.INSTANCE.getFactory(cancelCallbackId);
        if (cancelCallbackFactory == null) {
            LOGGER.warn("Cancel callback factory " + cancelCallbackId + " no longer exists");
            return null;
        }
        TransportCallback cancelCallback = cancelCallbackFactory.create(tag.m_128469_("cc"));
        if (cancelCallback == null) {
            LOGGER.warn("Cancel callback factory " + cancelCallbackId + " returned null!");
            return null;
        }
        ResourceLocation pipeGoneCallbackId = new ResourceLocation(tag.m_128461_("pgcid"));
        TransportCallbackFactory pipeGoneCallbackFactory = TransportCallbackFactoryRegistry.INSTANCE.getFactory(pipeGoneCallbackId);
        if (pipeGoneCallbackFactory == null) {
            LOGGER.warn("Pipe gone callback factory " + pipeGoneCallbackId + " no longer exists");
            return null;
        }
        TransportCallback pipeGoneCallback = pipeGoneCallbackFactory.create(tag.m_128469_("pgc"));
        if (pipeGoneCallback == null) {
            LOGGER.warn("Pipe gone callback factory " + pipeGoneCallbackId + " returned null!");
            return null;
        }
        boolean firstPipe = tag.m_128471_("fp");
        int progressInCurrentPipe = tag.m_128451_("p");
        return new ItemTransport(value, source, destination, path, initialDirection, finishedCallback, cancelCallback, pipeGoneCallback, firstPipe, progressInCurrentPipe);
    }

    public ItemStack getValue() {
        return this.value;
    }

    public Direction getDirection(ItemPipe currentPipe) {
        BlockPos nextPipe = this.path.peek();
        if (nextPipe == null) {
            return ItemTransport.getDirection(currentPipe.getPos(), this.destination);
        }
        return ItemTransport.getDirection(currentPipe.getPos(), nextPipe);
    }

    private boolean onDone(Network network, Level level, ItemPipe currentPipe) {
        this.finishedCallback.call(network, level, currentPipe.getPos(), this.cancelCallback);
        return true;
    }

    private boolean onPipeGone(Network network, Level level, BlockPos posWherePipeIsGone) {
        LOGGER.warn("Pipe on path is gone");
        this.pipeGoneCallback.call(network, level, posWherePipeIsGone, this.cancelCallback);
        return true;
    }

    public boolean update(Network network, ItemPipe currentPipe) {
        ++this.progressInCurrentPipe;
        double progress = (double)this.progressInCurrentPipe / (double)this.getMaxTicksInPipe(currentPipe);
        BlockPos nextPos = currentPipe.getPos().m_142300_(this.getDirection(currentPipe));
        if (progress > 0.25 && currentPipe.getLevel().m_46859_(nextPos)) {
            currentPipe.removeTransport(this);
            return this.onPipeGone(network, currentPipe.getLevel(), nextPos);
        }
        if (this.progressInCurrentPipe >= this.getMaxTicksInPipe(currentPipe)) {
            currentPipe.removeTransport(this);
            this.firstPipe = false;
            BlockPos nextPipePos = this.path.poll();
            if (nextPipePos == null) {
                return this.onDone(network, currentPipe.getLevel(), currentPipe);
            }
            Pipe nextPipe = network.getPipe(nextPipePos);
            if (nextPipe == null) {
                return this.onPipeGone(network, currentPipe.getLevel(), nextPipePos);
            }
            this.progressInCurrentPipe = 0;
            ((ItemPipe)nextPipe).addTransport(this);
        }
        return false;
    }

    private boolean isLastPipe() {
        return this.path.isEmpty();
    }

    private int getMaxTicksInPipe(ItemPipe currentPipe) {
        double mt = currentPipe.getMaxTicksInPipe();
        if (this.firstPipe) {
            mt *= 1.25;
        }
        if (this.isLastPipe()) {
            mt *= 0.25;
        }
        return (int)mt;
    }

    public ItemTransportProps createProps(ItemPipe currentPipe) {
        return new ItemTransportProps(this.value, currentPipe.getMaxTicksInPipe(), this.progressInCurrentPipe, this.getDirection(currentPipe), this.initialDirection, this.isLastPipe(), this.firstPipe);
    }

    public CompoundTag writeToNbt(CompoundTag tag) {
        tag.m_128365_("v", (Tag)this.value.m_41739_(new CompoundTag()));
        tag.m_128356_("src", this.source.m_121878_());
        tag.m_128356_("dst", this.destination.m_121878_());
        ListTag path = new ListTag();
        for (BlockPos pathItem : this.path) {
            path.add((Object)LongTag.m_128882_((long)pathItem.m_121878_()));
        }
        tag.m_128365_("pth", (Tag)path);
        tag.m_128405_("initiald", this.initialDirection.ordinal());
        tag.m_128365_("fc", (Tag)this.finishedCallback.writeToNbt(new CompoundTag()));
        tag.m_128359_("fcid", this.finishedCallback.getId().toString());
        tag.m_128365_("cc", (Tag)this.cancelCallback.writeToNbt(new CompoundTag()));
        tag.m_128359_("ccid", this.cancelCallback.getId().toString());
        tag.m_128365_("pgc", (Tag)this.pipeGoneCallback.writeToNbt(new CompoundTag()));
        tag.m_128359_("pgcid", this.pipeGoneCallback.getId().toString());
        tag.m_128379_("fp", this.firstPipe);
        tag.m_128405_("p", this.progressInCurrentPipe);
        return tag;
    }
}

