/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.transport;

import com.refinedmods.refinedpipes.util.DirectionUtil;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class ItemTransportProps {
    private final ItemStack stack;
    private final int maxTicksInPipe;
    private final Direction direction;
    private final Direction initialDirection;
    private final boolean lastPipe;
    private final boolean firstPipe;
    private int progress;

    public ItemTransportProps(ItemStack stack, int maxTicksInPipe, int progress, Direction direction, Direction initialDirection, boolean lastPipe, boolean firstPipe) {
        this.stack = stack;
        this.maxTicksInPipe = maxTicksInPipe;
        this.progress = progress;
        this.direction = direction;
        this.initialDirection = initialDirection;
        this.lastPipe = lastPipe;
        this.firstPipe = firstPipe;
    }

    public static ItemTransportProps create(FriendlyByteBuf buf) {
        return new ItemTransportProps(buf.m_130267_(), buf.readInt(), buf.readInt(), DirectionUtil.safeGet((byte)buf.readInt()), DirectionUtil.safeGet((byte)buf.readInt()), buf.readBoolean(), buf.readBoolean());
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_130055_(this.stack);
        buf.writeInt(this.maxTicksInPipe);
        buf.writeInt(this.progress);
        buf.writeInt(this.direction.ordinal());
        buf.writeInt(this.initialDirection.ordinal());
        buf.writeBoolean(this.lastPipe);
        buf.writeBoolean(this.firstPipe);
    }

    public void tick() {
        ++this.progress;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public int getMaxTicksInPipe() {
        return this.maxTicksInPipe;
    }

    public int getProgress() {
        return this.progress;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Direction getInitialDirection() {
        return this.initialDirection;
    }

    public boolean isLastPipe() {
        return this.lastPipe;
    }

    public boolean isFirstPipe() {
        return this.firstPipe;
    }
}

