/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.transport.callback;

import com.refinedmods.refinedpipes.network.Network;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.TransportCallback;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemBounceBackTransportCallback
implements TransportCallback {
    public static final ResourceLocation ID = new ResourceLocation("refinedpipes", "item_bounce_back");
    private static final Logger LOGGER = LogManager.getLogger(ItemBounceBackTransportCallback.class);
    private final BlockPos originalItemHandlerPosition;
    private final BlockPos bounceBackItemHandlerPosition;
    private final ItemStack toInsert;

    public ItemBounceBackTransportCallback(BlockPos originalItemHandlerPosition, BlockPos bounceBackItemHandlerPosition, ItemStack toInsert) {
        this.originalItemHandlerPosition = originalItemHandlerPosition;
        this.bounceBackItemHandlerPosition = bounceBackItemHandlerPosition;
        this.toInsert = toInsert;
    }

    @Nullable
    public static ItemBounceBackTransportCallback of(CompoundTag tag) {
        BlockPos originalItemHandlerPosition = BlockPos.m_122022_((long)tag.m_128454_("oihpos"));
        BlockPos bounceBackItemHandlerPosition = BlockPos.m_122022_((long)tag.m_128454_("bbihpos"));
        ItemStack toInsert = ItemStack.m_41712_((CompoundTag)tag.m_128469_("s"));
        if (toInsert.m_41619_()) {
            LOGGER.warn("Item no longer exists");
            return null;
        }
        return new ItemBounceBackTransportCallback(originalItemHandlerPosition, bounceBackItemHandlerPosition, toInsert);
    }

    @Override
    public void call(Network network, Level level, BlockPos currentPos, TransportCallback cancelCallback) {
        Containers.m_18992_((Level)level, (double)this.originalItemHandlerPosition.m_123341_(), (double)this.originalItemHandlerPosition.m_123342_(), (double)this.originalItemHandlerPosition.m_123343_(), (ItemStack)this.toInsert);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        tag.m_128356_("oihpos", this.originalItemHandlerPosition.m_121878_());
        tag.m_128356_("bbihpos", this.bounceBackItemHandlerPosition.m_121878_());
        tag.m_128365_("s", (Tag)this.toInsert.m_41739_(new CompoundTag()));
        return tag;
    }
}

