/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.refinedmods.refinedpipes.block.FluidPipeBlock;
import com.refinedmods.refinedpipes.blockentity.FluidPipeBlockEntity;
import com.refinedmods.refinedpipes.render.CubeBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class FluidPipeBlockEntityRenderer
implements BlockEntityRenderer<FluidPipeBlockEntity> {
    private static final float INSET = 0.001f;

    public void render(FluidPipeBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferType, int combinedLight, int combinedOverlay) {
        float shrinkage;
        float z2;
        float y2;
        float x2;
        float z1;
        float y1;
        float x1;
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        BlockState state = level.m_8055_(blockEntity.m_58899_());
        if (!(state.m_60734_() instanceof FluidPipeBlock)) {
            return;
        }
        FluidStack fluidStack = blockEntity.getFluid();
        if (fluidStack.isEmpty()) {
            blockEntity.updateAndGetRenderFullness(partialTicks);
            return;
        }
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        FluidAttributes attributes = fluidStack.getFluid().getAttributes();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(attributes.getStillTexture(fluidStack));
        int fluidColor = attributes.getColor(fluidStack);
        int r = fluidColor >> 16 & 0xFF;
        int g = fluidColor >> 8 & 0xFF;
        int b = fluidColor & 0xFF;
        int a = fluidColor >> 24 & 0xFF;
        VertexConsumer buffer = bufferType.m_6299_(RenderType.m_110497_((ResourceLocation)sprite.m_118414_().m_118330_()));
        float fullness = blockEntity.updateAndGetRenderFullness(partialTicks);
        if (fullness == 0.0f) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)FluidPipeBlock.NORTH)).booleanValue()) {
            x1 = 4.0f;
            y1 = 4.0f;
            z1 = 0.0f;
            x2 = 12.0f;
            y2 = 4.0f + fullness * 8.0f;
            z2 = 4.0f;
            CubeBuilder.INSTANCE.putCube(poseStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.SOUTH);
        }
        if (((Boolean)state.m_61143_((Property)FluidPipeBlock.EAST)).booleanValue()) {
            x1 = 12.0f;
            y1 = 4.0f;
            z1 = 4.0f;
            x2 = 16.0f;
            y2 = 4.0f + fullness * 8.0f;
            z2 = 12.0f;
            CubeBuilder.INSTANCE.putCube(poseStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.WEST);
        }
        if (((Boolean)state.m_61143_((Property)FluidPipeBlock.SOUTH)).booleanValue()) {
            x1 = 4.0f;
            y1 = 4.0f;
            z1 = 12.0f;
            x2 = 12.0f;
            y2 = 4.0f + fullness * 8.0f;
            z2 = 16.0f;
            CubeBuilder.INSTANCE.putCube(poseStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.NORTH);
        }
        if (((Boolean)state.m_61143_((Property)FluidPipeBlock.WEST)).booleanValue()) {
            x1 = 0.0f;
            y1 = 4.0f;
            z1 = 4.0f;
            x2 = 4.0f;
            y2 = 4.0f + fullness * 8.0f;
            z2 = 12.0f;
            CubeBuilder.INSTANCE.putCube(poseStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.EAST);
        }
        if (((Boolean)state.m_61143_((Property)FluidPipeBlock.UP)).booleanValue()) {
            x1 = 4.0f;
            y1 = 12.0f;
            z1 = 4.0f;
            x2 = 12.0f;
            y2 = 16.0f;
            z2 = 12.0f;
            shrinkage = (1.0f - fullness) * 4.0f;
            CubeBuilder.INSTANCE.putCube(poseStack, buffer, (x1 += shrinkage) / 16.0f + 0.001f, (y1 -= (1.0f - fullness) * 8.0f) / 16.0f + 0.001f, (z1 += shrinkage) / 16.0f + 0.001f, (x2 -= shrinkage) / 16.0f - 0.001f, y2 / 16.0f - 0.001f, (z2 -= shrinkage) / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.DOWN);
        }
        if (((Boolean)state.m_61143_((Property)FluidPipeBlock.DOWN)).booleanValue()) {
            x1 = 4.0f;
            y1 = 0.0f;
            z1 = 4.0f;
            x2 = 12.0f;
            y2 = 4.0f;
            z2 = 12.0f;
            shrinkage = (1.0f - fullness) * 4.0f;
            CubeBuilder.INSTANCE.putCube(poseStack, buffer, (x1 += shrinkage) / 16.0f + 0.001f, y1 / 16.0f + 0.001f, (z1 += shrinkage) / 16.0f + 0.001f, (x2 -= shrinkage) / 16.0f - 0.001f, y2 / 16.0f - 0.001f, (z2 -= shrinkage) / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.UP);
        }
        x1 = 4.0f;
        y1 = 4.0f;
        z1 = 4.0f;
        x2 = 12.0f;
        y2 = 4.0f + fullness * 8.0f;
        z2 = 12.0f;
        poseStack.m_85836_();
        CubeBuilder.INSTANCE.putFace(poseStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.UP);
        CubeBuilder.INSTANCE.putFace(poseStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.DOWN);
        if (!((Boolean)state.m_61143_((Property)FluidPipeBlock.NORTH)).booleanValue()) {
            CubeBuilder.INSTANCE.putFace(poseStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.NORTH);
        }
        if (!((Boolean)state.m_61143_((Property)FluidPipeBlock.EAST)).booleanValue()) {
            CubeBuilder.INSTANCE.putFace(poseStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.EAST);
        }
        if (!((Boolean)state.m_61143_((Property)FluidPipeBlock.SOUTH)).booleanValue()) {
            CubeBuilder.INSTANCE.putFace(poseStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.SOUTH);
        }
        if (!((Boolean)state.m_61143_((Property)FluidPipeBlock.WEST)).booleanValue()) {
            CubeBuilder.INSTANCE.putFace(poseStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.WEST);
        }
        poseStack.m_85849_();
    }
}

