/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.refinedmods.refinedpipes.blockentity.ItemPipeBlockEntity;
import com.refinedmods.refinedpipes.network.pipe.transport.ItemTransportProps;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;

public class ItemPipeBlockEntityRenderer
implements BlockEntityRenderer<ItemPipeBlockEntity> {
    public void render(ItemPipeBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferType, int combinedLight, int combinedOverlay) {
        for (ItemTransportProps prop : blockEntity.getProps()) {
            Direction dir = prop.getDirection();
            double pipeLength = 1.0;
            if (prop.isFirstPipe()) {
                pipeLength = 1.25;
            }
            if (prop.isLastPipe()) {
                pipeLength = 0.25;
            }
            double maxTicksInPipe = (double)prop.getMaxTicksInPipe() * pipeLength;
            double v = ((double)prop.getProgress() + (double)partialTicks) / maxTicksInPipe * pipeLength;
            if (prop.isFirstPipe() && v < 0.25) {
                dir = prop.getInitialDirection();
            }
            if (prop.isFirstPipe()) {
                v -= 0.25;
            }
            if (v > 0.25 && blockEntity.m_58904_().m_46859_(blockEntity.m_58899_().m_142300_(prop.getDirection()))) continue;
            v = Math.min(1.0, v);
            poseStack.m_85836_();
            poseStack.m_85837_(0.5 + (double)dir.m_122429_() * v, 0.5 + (double)dir.m_122430_() * v, 0.5 + (double)dir.m_122431_() * v);
            poseStack.m_85845_(new Quaternion(0.0f, (float)((double)Minecraft.m_91087_().f_91073_.m_46467_() / 25.0 % (Math.PI * 2) + (double)partialTicks / 25.0), 0.0f, false));
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            Minecraft.m_91087_().m_91291_().m_174269_(prop.getStack(), ItemTransforms.TransformType.FIXED, combinedLight, combinedOverlay, poseStack, bufferType, 0);
            poseStack.m_85849_();
        }
    }
}

