/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.render;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.refinedmods.refinedpipes.block.PipeBlock;
import com.refinedmods.refinedpipes.blockentity.PipeBlockEntity;
import com.refinedmods.refinedpipes.render.PipeState;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import net.minecraftforge.common.model.TransformationHelper;

public class PipeBakedModel
implements BakedModel {
    private static final Map<Direction, Transformation> SIDE_TRANSFORMS = new EnumMap<Direction, Transformation>(Direction.class);
    private final BakedModel core;
    private final BakedModel extension;
    private final BakedModel straight;
    private final BakedModel inventoryAttachment;
    private final Map<ResourceLocation, BakedModel> attachmentModels;
    private final Map<PipeState, List<BakedQuad>> cache = new ConcurrentHashMap<PipeState, List<BakedQuad>>();

    public PipeBakedModel(BakedModel core, BakedModel extension, BakedModel straight, BakedModel inventoryAttachment, Map<ResourceLocation, BakedModel> attachmentModels) {
        this.core = core;
        this.extension = extension;
        this.straight = straight;
        this.inventoryAttachment = inventoryAttachment;
        this.attachmentModels = attachmentModels;
    }

    private static List<BakedQuad> getTransformedQuads(BakedModel model, Direction facing, PipeState state) {
        Transformation transformation = SIDE_TRANSFORMS.computeIfAbsent(facing, face -> {
            Quaternion quaternion;
            if (face == Direction.UP) {
                quaternion = TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(90.0f, 0.0f, 0.0f), (boolean)true);
            } else if (face == Direction.DOWN) {
                quaternion = TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(270.0f, 0.0f, 0.0f), (boolean)true);
            } else {
                double r = Math.PI * (double)(360 - face.m_122424_().m_122416_() * 90) / 180.0;
                quaternion = TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(0.0f, (float)r, 0.0f), (boolean)false);
            }
            return new Transformation(null, quaternion, null, null).blockCenterToCorner();
        });
        ImmutableList.Builder quads = ImmutableList.builder();
        Direction side = state.getSide();
        if (side != null && side.m_122416_() > -1) {
            int faceOffset = 4 + Direction.NORTH.m_122416_() - facing.m_122416_();
            side = Direction.m_122407_((int)((side.m_122416_() + faceOffset) % 4));
        }
        for (BakedQuad quad : model.getQuads(state.getState(), side, state.getRand(), (IModelData)EmptyModelData.INSTANCE)) {
            BakedQuadBuilder builder = new BakedQuadBuilder(quad.m_173410_());
            TRSRTransformer transformer = new TRSRTransformer((IVertexConsumer)builder, transformation);
            quad.pipe((IVertexConsumer)transformer);
            quads.add((Object)builder.build());
        }
        return quads.build();
    }

    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        PipeState pipeState = new PipeState(state, (ResourceLocation[])extraData.getData(PipeBlockEntity.ATTACHMENTS_PROPERTY), side, rand);
        return this.cache.computeIfAbsent(pipeState, this::createQuads);
    }

    private List<BakedQuad> createQuads(PipeState state) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (state.getState() != null) {
            boolean north = (Boolean)state.getState().m_61143_((Property)PipeBlock.NORTH);
            int east = ((Boolean)state.getState().m_61143_((Property)PipeBlock.EAST)).booleanValue() ? 1 : 0;
            int south = ((Boolean)state.getState().m_61143_((Property)PipeBlock.SOUTH)).booleanValue() ? 1 : 0;
            boolean west = (Boolean)state.getState().m_61143_((Property)PipeBlock.WEST);
            boolean up = (Boolean)state.getState().m_61143_((Property)PipeBlock.UP);
            boolean down = (Boolean)state.getState().m_61143_((Property)PipeBlock.DOWN);
            if (north && south != 0 && east == 0 && !west && !up && !down) {
                quads.addAll(this.straight.getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
            } else if (!north && south == 0 && east != 0 && west && !up && !down) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.straight, Direction.EAST, state));
            } else if (!north && south == 0 && east == 0 && !west && up && down) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.straight, Direction.UP, state));
            } else if (!(north || south != 0 || east != 0 || west || up || down)) {
                quads.addAll(this.core.getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
            } else {
                quads.addAll(this.core.getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
                if (north) {
                    quads.addAll(this.extension.getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
                }
                if (east != 0) {
                    quads.addAll(PipeBakedModel.getTransformedQuads(this.extension, Direction.EAST, state));
                }
                if (south != 0) {
                    quads.addAll(PipeBakedModel.getTransformedQuads(this.extension, Direction.SOUTH, state));
                }
                if (west) {
                    quads.addAll(PipeBakedModel.getTransformedQuads(this.extension, Direction.WEST, state));
                }
                if (up) {
                    quads.addAll(PipeBakedModel.getTransformedQuads(this.extension, Direction.UP, state));
                }
                if (down) {
                    quads.addAll(PipeBakedModel.getTransformedQuads(this.extension, Direction.DOWN, state));
                }
            }
        }
        if (state.getAttachmentState() != null) {
            for (Direction dir : Direction.values()) {
                ResourceLocation attachmentId = state.getAttachmentState()[dir.ordinal()];
                if (attachmentId == null) continue;
                quads.addAll(PipeBakedModel.getTransformedQuads(this.attachmentModels.get(attachmentId), dir, state));
            }
        }
        if (state.getState() != null) {
            boolean invNorth = (Boolean)state.getState().m_61143_((Property)PipeBlock.INV_NORTH);
            boolean invEast = (Boolean)state.getState().m_61143_((Property)PipeBlock.INV_EAST);
            boolean invSouth = (Boolean)state.getState().m_61143_((Property)PipeBlock.INV_SOUTH);
            boolean invWest = (Boolean)state.getState().m_61143_((Property)PipeBlock.INV_WEST);
            boolean invUp = (Boolean)state.getState().m_61143_((Property)PipeBlock.INV_UP);
            boolean invDown = (Boolean)state.getState().m_61143_((Property)PipeBlock.INV_DOWN);
            if (invNorth && !state.hasAttachmentState(Direction.NORTH)) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.inventoryAttachment, Direction.NORTH, state));
            }
            if (invEast && !state.hasAttachmentState(Direction.EAST)) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.inventoryAttachment, Direction.EAST, state));
            }
            if (invSouth && !state.hasAttachmentState(Direction.SOUTH)) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.inventoryAttachment, Direction.SOUTH, state));
            }
            if (invWest && !state.hasAttachmentState(Direction.WEST)) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.inventoryAttachment, Direction.WEST, state));
            }
            if (invUp && !state.hasAttachmentState(Direction.UP)) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.inventoryAttachment, Direction.UP, state));
            }
            if (invDown && !state.hasAttachmentState(Direction.DOWN)) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.inventoryAttachment, Direction.DOWN, state));
            }
        }
        return quads;
    }

    public boolean m_7541_() {
        return this.core.m_7541_();
    }

    public boolean m_7539_() {
        return this.core.m_7539_();
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return this.core.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.core.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.core.m_7343_();
    }
}

