/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedpipes.container.ExtractorAttachmentContainerMenu;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.BlacklistWhitelist;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RedstoneMode;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RoutingMode;
import com.refinedmods.refinedpipes.screen.BaseScreen;
import com.refinedmods.refinedpipes.screen.widget.IconButton;
import com.refinedmods.refinedpipes.screen.widget.IconButtonPreset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ExtractorAttachmentScreen
extends BaseScreen<ExtractorAttachmentContainerMenu> {
    private static final ResourceLocation RESOURCE = new ResourceLocation("refinedpipes", "textures/gui/extractor_attachment.png");
    private final List<Component> tooltip = new ArrayList<Component>();
    private Button redstoneModeButton;
    private Button blacklistWhitelistButton;
    @Nullable
    private Button routingModeButton;
    @Nullable
    private Button exactModeButton;
    @Nullable
    private Button plusButton;
    @Nullable
    private Button minusButton;

    public ExtractorAttachmentScreen(ExtractorAttachmentContainerMenu container, Inventory inv, Component title) {
        super(container, inv, title);
        this.f_97726_ = 176;
        this.f_97727_ = 193;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.redstoneModeButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + 32, this.f_97736_ + 76, IconButtonPreset.NORMAL, this.getRedstoneModeX(((ExtractorAttachmentContainerMenu)this.f_97732_).getRedstoneMode()), 61, (Component)this.getRedstoneModeText(((ExtractorAttachmentContainerMenu)this.f_97732_).getRedstoneMode()), btn -> this.setRedstoneMode((IconButton)btn, ((ExtractorAttachmentContainerMenu)this.f_97732_).getRedstoneMode().next())));
        this.redstoneModeButton.f_93623_ = ((ExtractorAttachmentContainerMenu)this.f_97732_).getExtractorAttachmentType().getCanSetRedstoneMode();
        this.blacklistWhitelistButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + 55, this.f_97736_ + 76, IconButtonPreset.NORMAL, this.getBlacklistWhitelistX(((ExtractorAttachmentContainerMenu)this.f_97732_).getBlacklistWhitelist()), 82, (Component)this.getBlacklistWhitelistText(((ExtractorAttachmentContainerMenu)this.f_97732_).getBlacklistWhitelist()), btn -> this.setBlacklistWhitelist((IconButton)btn, ((ExtractorAttachmentContainerMenu)this.f_97732_).getBlacklistWhitelist().next())));
        this.blacklistWhitelistButton.f_93623_ = ((ExtractorAttachmentContainerMenu)this.f_97732_).getExtractorAttachmentType().getCanSetWhitelistBlacklist();
        this.exactModeButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + 78, this.f_97736_ + 76, IconButtonPreset.NORMAL, this.getExactModeX(((ExtractorAttachmentContainerMenu)this.f_97732_).isExactMode()), 103, (Component)this.getExactModeText(((ExtractorAttachmentContainerMenu)this.f_97732_).isExactMode()), btn -> this.setExactMode((IconButton)btn, !((ExtractorAttachmentContainerMenu)this.f_97732_).isExactMode())));
        this.exactModeButton.f_93623_ = ((ExtractorAttachmentContainerMenu)this.f_97732_).getExtractorAttachmentType().getCanSetExactMode();
        if (!((ExtractorAttachmentContainerMenu)this.f_97732_).isFluidMode()) {
            this.routingModeButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + 101, this.f_97736_ + 76, IconButtonPreset.NORMAL, this.getRoutingModeX(((ExtractorAttachmentContainerMenu)this.f_97732_).getRoutingMode()), 194, (Component)this.getRoutingModeText(((ExtractorAttachmentContainerMenu)this.f_97732_).getRoutingMode()), btn -> this.setRoutingMode((IconButton)btn, ((ExtractorAttachmentContainerMenu)this.f_97732_).getRoutingMode().next())));
            this.routingModeButton.f_93623_ = ((ExtractorAttachmentContainerMenu)this.f_97732_).getExtractorAttachmentType().getCanSetWhitelistBlacklist();
            this.plusButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + 125, this.f_97736_ + 76 - 3, IconButtonPreset.SMALL, 198, 19, (Component)new TextComponent("+"), btn -> this.updateStackSize(1)));
            this.minusButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + 125, this.f_97736_ + 76 + 14 - 3, IconButtonPreset.SMALL, 198, 34, (Component)new TextComponent("-"), btn -> this.updateStackSize(-1)));
            this.minusButton.f_93623_ = ((ExtractorAttachmentContainerMenu)this.f_97732_).getStackSize() > 0;
            this.plusButton.f_93623_ = ((ExtractorAttachmentContainerMenu)this.f_97732_).getStackSize() < ((ExtractorAttachmentContainerMenu)this.f_97732_).getExtractorAttachmentType().getItemsToExtract();
        }
    }

    private void updateStackSize(int amount) {
        int newAmount;
        if (ExtractorAttachmentScreen.m_96638_()) {
            amount *= 4;
        }
        if ((newAmount = ((ExtractorAttachmentContainerMenu)this.f_97732_).getStackSize() + amount) < 0) {
            newAmount = 0;
        }
        if (newAmount > ((ExtractorAttachmentContainerMenu)this.f_97732_).getExtractorAttachmentType().getItemsToExtract()) {
            newAmount = ((ExtractorAttachmentContainerMenu)this.f_97732_).getExtractorAttachmentType().getItemsToExtract();
        }
        this.minusButton.f_93623_ = newAmount > 0;
        this.plusButton.f_93623_ = newAmount < ((ExtractorAttachmentContainerMenu)this.f_97732_).getExtractorAttachmentType().getItemsToExtract();
        ((ExtractorAttachmentContainerMenu)this.f_97732_).setStackSize(newAmount);
    }

    private int getRedstoneModeX(RedstoneMode redstoneMode) {
        switch (redstoneMode) {
            case IGNORED: {
                return 219;
            }
            case HIGH: {
                return 177;
            }
            case LOW: {
                return 198;
            }
        }
        return 0;
    }

    private MutableComponent getRedstoneModeText(RedstoneMode redstoneMode) {
        return new TranslatableComponent("misc.refinedpipes.redstone_mode." + redstoneMode.toString().toLowerCase());
    }

    private void setRedstoneMode(IconButton button, RedstoneMode redstoneMode) {
        button.m_93666_((Component)this.getRedstoneModeText(redstoneMode));
        button.setOverlayTexX(this.getRedstoneModeX(redstoneMode));
        ((ExtractorAttachmentContainerMenu)this.f_97732_).setRedstoneMode(redstoneMode);
    }

    private int getBlacklistWhitelistX(BlacklistWhitelist blacklistWhitelist) {
        switch (blacklistWhitelist) {
            case BLACKLIST: {
                return 198;
            }
            case WHITELIST: {
                return 177;
            }
        }
        return 0;
    }

    private MutableComponent getBlacklistWhitelistText(BlacklistWhitelist blacklistWhitelist) {
        return new TranslatableComponent("misc.refinedpipes.mode." + blacklistWhitelist.toString().toLowerCase());
    }

    private void setBlacklistWhitelist(IconButton button, BlacklistWhitelist blacklistWhitelist) {
        button.m_93666_((Component)this.getBlacklistWhitelistText(blacklistWhitelist));
        button.setOverlayTexX(this.getBlacklistWhitelistX(blacklistWhitelist));
        ((ExtractorAttachmentContainerMenu)this.f_97732_).setBlacklistWhitelist(blacklistWhitelist);
    }

    private int getRoutingModeX(RoutingMode routingMode) {
        switch (routingMode) {
            case NEAREST: {
                return 0;
            }
            case FURTHEST: {
                return 21;
            }
            case RANDOM: {
                return 42;
            }
            case ROUND_ROBIN: {
                return 63;
            }
        }
        return 0;
    }

    private MutableComponent getRoutingModeText(RoutingMode routingMode) {
        return new TranslatableComponent("misc.refinedpipes.routing_mode." + routingMode.toString().toLowerCase());
    }

    private void setRoutingMode(IconButton button, RoutingMode routingMode) {
        button.m_93666_((Component)this.getRoutingModeText(routingMode));
        button.setOverlayTexX(this.getRoutingModeX(routingMode));
        ((ExtractorAttachmentContainerMenu)this.f_97732_).setRoutingMode(routingMode);
    }

    private int getExactModeX(boolean exactMode) {
        return exactMode ? 177 : 198;
    }

    private MutableComponent getExactModeText(boolean exactMode) {
        return new TranslatableComponent("misc.refinedpipes.exact_mode." + (exactMode ? "on" : "off"));
    }

    private void setExactMode(IconButton button, boolean exactMode) {
        button.m_93666_((Component)this.getExactModeText(exactMode));
        button.setOverlayTexX(this.getExactModeX(exactMode));
        ((ExtractorAttachmentContainerMenu)this.f_97732_).setExactMode(exactMode);
    }

    @Override
    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        this.f_96547_.m_92883_(poseStack, this.f_96539_.getString(), 7.0f, 7.0f, 0x404040);
        this.f_96547_.m_92883_(poseStack, I18n.m_118938_((String)"container.inventory", (Object[])new Object[0]), 7.0f, 99.0f, 0x404040);
        if (!((ExtractorAttachmentContainerMenu)this.f_97732_).isFluidMode()) {
            this.f_96547_.m_92883_(poseStack, "" + ((ExtractorAttachmentContainerMenu)this.f_97732_).getStackSize(), 143.0f, 83.0f, 0x404040);
        }
        this.m_7025_(poseStack, mouseX - this.f_97735_, mouseY - this.f_97736_);
        this.tooltip.clear();
        if (this.blacklistWhitelistButton.m_198029_()) {
            this.tooltip.add((Component)new TranslatableComponent("misc.refinedpipes.mode"));
            this.tooltip.add((Component)this.getBlacklistWhitelistText(((ExtractorAttachmentContainerMenu)this.f_97732_).getBlacklistWhitelist()).m_130940_(ChatFormatting.GRAY));
        } else if (this.redstoneModeButton.m_198029_()) {
            this.tooltip.add((Component)new TranslatableComponent("misc.refinedpipes.redstone_mode"));
            this.tooltip.add((Component)this.getRedstoneModeText(((ExtractorAttachmentContainerMenu)this.f_97732_).getRedstoneMode()).m_130940_(ChatFormatting.GRAY));
        } else if (this.routingModeButton != null && this.routingModeButton.m_198029_()) {
            this.tooltip.add((Component)new TranslatableComponent("misc.refinedpipes.routing_mode"));
            this.tooltip.add((Component)this.getRoutingModeText(((ExtractorAttachmentContainerMenu)this.f_97732_).getRoutingMode()).m_130940_(ChatFormatting.GRAY));
        } else if (this.exactModeButton.m_198029_()) {
            this.tooltip.add((Component)new TranslatableComponent("misc.refinedpipes.exact_mode"));
            this.tooltip.add((Component)this.getExactModeText(((ExtractorAttachmentContainerMenu)this.f_97732_).isExactMode()).m_130940_(ChatFormatting.GRAY));
        }
        if (!this.tooltip.isEmpty()) {
            this.m_96597_(poseStack, this.tooltip, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        super.m_7027_(poseStack, mouseX, mouseY);
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(poseStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)RESOURCE);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int x = 43;
        int y = 18;
        for (int filterSlotId = 1; filterSlotId <= 15; ++filterSlotId) {
            if (filterSlotId > ((ExtractorAttachmentContainerMenu)this.f_97732_).getExtractorAttachmentType().getFilterSlots()) {
                this.m_93228_(poseStack, i + x, j + y, 198, 0, 18, 18);
            }
            if (filterSlotId % 5 == 0) {
                x = 43;
                y += 18;
                continue;
            }
            x += 18;
        }
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
    }
}

