/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.setup;

import com.refinedmods.refinedpipes.RefinedPipesBlockEntities;
import com.refinedmods.refinedpipes.RefinedPipesBlocks;
import com.refinedmods.refinedpipes.RefinedPipesContainerMenus;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentFactory;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentRegistry;
import com.refinedmods.refinedpipes.network.pipe.energy.EnergyPipeType;
import com.refinedmods.refinedpipes.network.pipe.fluid.FluidPipeType;
import com.refinedmods.refinedpipes.network.pipe.item.ItemPipeType;
import com.refinedmods.refinedpipes.render.FluidPipeBlockEntityRenderer;
import com.refinedmods.refinedpipes.render.ItemPipeBlockEntityRenderer;
import com.refinedmods.refinedpipes.render.PipeBakedModel;
import com.refinedmods.refinedpipes.screen.ExtractorAttachmentScreen;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientSetup {
    private static final Logger LOGGER = LogManager.getLogger(ClientSetup.class);

    private ClientSetup() {
    }

    @SubscribeEvent
    public static void registerSpecialModels(ModelRegistryEvent ev) {
        for (AttachmentFactory factory : AttachmentRegistry.INSTANCE.all()) {
            LOGGER.debug("Registering attachment model {}", (Object)factory.getModelLocation());
            ForgeModelBakery.addSpecialModel((ResourceLocation)factory.getModelLocation());
        }
        for (String type : new String[]{"item", "fluid", "energy"}) {
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/basic/core"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/basic/extension"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/basic/straight"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/improved/core"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/improved/extension"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/improved/straight"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/advanced/core"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/advanced/extension"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/advanced/straight"));
            if (!type.equals("fluid") && !type.equals("energy")) continue;
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/elite/core"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/elite/extension"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/elite/straight"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/ultimate/core"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/ultimate/extension"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/ultimate/straight"));
        }
        ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment"));
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent e) {
        MenuScreens.m_96206_(RefinedPipesContainerMenus.EXTRACTOR_ATTACHMENT, ExtractorAttachmentScreen::new);
        ItemBlockRenderTypes.setRenderLayer((Block)RefinedPipesBlocks.BASIC_ITEM_PIPE, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)RefinedPipesBlocks.IMPROVED_ITEM_PIPE, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)RefinedPipesBlocks.ADVANCED_ITEM_PIPE, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)RefinedPipesBlocks.BASIC_FLUID_PIPE, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)RefinedPipesBlocks.IMPROVED_FLUID_PIPE, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)RefinedPipesBlocks.ADVANCED_FLUID_PIPE, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)RefinedPipesBlocks.ELITE_FLUID_PIPE, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)RefinedPipesBlocks.ULTIMATE_FLUID_PIPE, (RenderType)RenderType.m_110463_());
        BlockEntityRenderers.m_173590_(RefinedPipesBlockEntities.BASIC_ITEM_PIPE, ctx -> new ItemPipeBlockEntityRenderer());
        BlockEntityRenderers.m_173590_(RefinedPipesBlockEntities.IMPROVED_ITEM_PIPE, ctx -> new ItemPipeBlockEntityRenderer());
        BlockEntityRenderers.m_173590_(RefinedPipesBlockEntities.ADVANCED_ITEM_PIPE, ctx -> new ItemPipeBlockEntityRenderer());
        BlockEntityRenderers.m_173590_(RefinedPipesBlockEntities.BASIC_FLUID_PIPE, ctx -> new FluidPipeBlockEntityRenderer());
        BlockEntityRenderers.m_173590_(RefinedPipesBlockEntities.IMPROVED_FLUID_PIPE, ctx -> new FluidPipeBlockEntityRenderer());
        BlockEntityRenderers.m_173590_(RefinedPipesBlockEntities.ADVANCED_FLUID_PIPE, ctx -> new FluidPipeBlockEntityRenderer());
        BlockEntityRenderers.m_173590_(RefinedPipesBlockEntities.ELITE_FLUID_PIPE, ctx -> new FluidPipeBlockEntityRenderer());
        BlockEntityRenderers.m_173590_(RefinedPipesBlockEntities.ULTIMATE_FLUID_PIPE, ctx -> new FluidPipeBlockEntityRenderer());
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent e) {
        HashMap<ResourceLocation, BakedModel> attachmentModels = new HashMap<ResourceLocation, BakedModel>();
        for (AttachmentFactory factory : AttachmentRegistry.INSTANCE.all()) {
            attachmentModels.put(factory.getId(), (BakedModel)e.getModelRegistry().get(factory.getModelLocation()));
        }
        HashMap<ResourceLocation, PipeBakedModel> pipeModels = new HashMap<ResourceLocation, PipeBakedModel>();
        pipeModels.put(ItemPipeType.BASIC.getId(), new PipeBakedModel((BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/basic/core")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/basic/extension")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/basic/straight")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(ItemPipeType.IMPROVED.getId(), new PipeBakedModel((BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/improved/core")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/improved/extension")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/improved/straight")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(ItemPipeType.ADVANCED.getId(), new PipeBakedModel((BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/advanced/core")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/advanced/extension")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/advanced/straight")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(FluidPipeType.BASIC.getId(), new PipeBakedModel((BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/basic/core")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/basic/extension")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/basic/straight")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(FluidPipeType.IMPROVED.getId(), new PipeBakedModel((BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/improved/core")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/improved/extension")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/improved/straight")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(FluidPipeType.ADVANCED.getId(), new PipeBakedModel((BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/advanced/core")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/advanced/extension")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/advanced/straight")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(FluidPipeType.ELITE.getId(), new PipeBakedModel((BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/elite/core")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/elite/extension")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/elite/straight")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(FluidPipeType.ULTIMATE.getId(), new PipeBakedModel((BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/ultimate/core")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/ultimate/extension")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/ultimate/straight")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(EnergyPipeType.BASIC.getId(), new PipeBakedModel((BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/basic/core")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/basic/extension")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/basic/straight")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(EnergyPipeType.IMPROVED.getId(), new PipeBakedModel((BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/improved/core")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/improved/extension")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/improved/straight")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(EnergyPipeType.ADVANCED.getId(), new PipeBakedModel((BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/advanced/core")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/advanced/extension")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/advanced/straight")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(EnergyPipeType.ELITE.getId(), new PipeBakedModel((BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/elite/core")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/elite/extension")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/elite/straight")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(EnergyPipeType.ULTIMATE.getId(), new PipeBakedModel((BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/ultimate/core")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/ultimate/extension")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/ultimate/straight")), (BakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        block1: for (ResourceLocation id : e.getModelRegistry().keySet()) {
            for (Map.Entry entry : pipeModels.entrySet()) {
                if (!ClientSetup.isPipeModel(id, (ResourceLocation)entry.getKey())) continue;
                e.getModelRegistry().put(id, (BakedModel)entry.getValue());
                continue block1;
            }
        }
    }

    private static boolean isPipeModel(ResourceLocation modelId, ResourceLocation pipeId) {
        return modelId instanceof ModelResourceLocation && modelId.m_135827_().equals("refinedpipes") && modelId.m_135815_().equals(pipeId.m_135815_()) && !((ModelResourceLocation)modelId).m_119448_().equals("inventory");
    }
}

