/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.setup;

import com.refinedmods.refinedpipes.RefinedPipes;
import com.refinedmods.refinedpipes.RefinedPipesBlocks;
import com.refinedmods.refinedpipes.block.EnergyPipeBlock;
import com.refinedmods.refinedpipes.block.FluidPipeBlock;
import com.refinedmods.refinedpipes.block.ItemPipeBlock;
import com.refinedmods.refinedpipes.blockentity.EnergyPipeBlockEntity;
import com.refinedmods.refinedpipes.blockentity.FluidPipeBlockEntity;
import com.refinedmods.refinedpipes.blockentity.ItemPipeBlockEntity;
import com.refinedmods.refinedpipes.container.factory.ExtractorAttachmentContainerFactory;
import com.refinedmods.refinedpipes.item.AttachmentItem;
import com.refinedmods.refinedpipes.item.EnergyPipeBlockItem;
import com.refinedmods.refinedpipes.item.FluidPipeBlockItem;
import com.refinedmods.refinedpipes.item.ItemPipeBlockItem;
import com.refinedmods.refinedpipes.network.NetworkManager;
import com.refinedmods.refinedpipes.network.NetworkRegistry;
import com.refinedmods.refinedpipes.network.energy.EnergyNetworkFactory;
import com.refinedmods.refinedpipes.network.fluid.FluidNetworkFactory;
import com.refinedmods.refinedpipes.network.item.ItemNetwork;
import com.refinedmods.refinedpipes.network.item.ItemNetworkFactory;
import com.refinedmods.refinedpipes.network.pipe.PipeRegistry;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentFactory;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentRegistry;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.ExtractorAttachmentFactory;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.ExtractorAttachmentType;
import com.refinedmods.refinedpipes.network.pipe.energy.EnergyPipe;
import com.refinedmods.refinedpipes.network.pipe.energy.EnergyPipeFactory;
import com.refinedmods.refinedpipes.network.pipe.energy.EnergyPipeType;
import com.refinedmods.refinedpipes.network.pipe.fluid.FluidPipe;
import com.refinedmods.refinedpipes.network.pipe.fluid.FluidPipeFactory;
import com.refinedmods.refinedpipes.network.pipe.fluid.FluidPipeType;
import com.refinedmods.refinedpipes.network.pipe.item.ItemPipe;
import com.refinedmods.refinedpipes.network.pipe.item.ItemPipeFactory;
import com.refinedmods.refinedpipes.network.pipe.item.ItemPipeType;
import com.refinedmods.refinedpipes.network.pipe.shape.PipeShapeCache;
import com.refinedmods.refinedpipes.network.pipe.shape.PipeShapeFactory;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.ItemBounceBackTransportCallback;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.ItemInsertTransportCallback;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.ItemPipeGoneTransportCallback;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.TransportCallbackFactoryRegistry;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class CommonSetup {
    private static final PipeShapeCache PIPE_SHAPE_CACHE = new PipeShapeCache(new PipeShapeFactory());

    private CommonSetup() {
    }

    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent e) {
        NetworkRegistry.INSTANCE.addFactory(ItemNetwork.TYPE, new ItemNetworkFactory());
        for (FluidPipeType fluidPipeType : FluidPipeType.values()) {
            NetworkRegistry.INSTANCE.addFactory(fluidPipeType.getNetworkType(), new FluidNetworkFactory(fluidPipeType));
        }
        for (Enum enum_ : EnergyPipeType.values()) {
            NetworkRegistry.INSTANCE.addFactory(((EnergyPipeType)enum_).getNetworkType(), new EnergyNetworkFactory((EnergyPipeType)enum_));
        }
        PipeRegistry.INSTANCE.addFactory(ItemPipe.ID, new ItemPipeFactory());
        PipeRegistry.INSTANCE.addFactory(FluidPipe.ID, new FluidPipeFactory());
        PipeRegistry.INSTANCE.addFactory(EnergyPipe.ID, new EnergyPipeFactory());
        AttachmentRegistry.INSTANCE.addFactory(ExtractorAttachmentType.BASIC.getId(), new ExtractorAttachmentFactory(ExtractorAttachmentType.BASIC));
        AttachmentRegistry.INSTANCE.addFactory(ExtractorAttachmentType.IMPROVED.getId(), new ExtractorAttachmentFactory(ExtractorAttachmentType.IMPROVED));
        AttachmentRegistry.INSTANCE.addFactory(ExtractorAttachmentType.ADVANCED.getId(), new ExtractorAttachmentFactory(ExtractorAttachmentType.ADVANCED));
        AttachmentRegistry.INSTANCE.addFactory(ExtractorAttachmentType.ELITE.getId(), new ExtractorAttachmentFactory(ExtractorAttachmentType.ELITE));
        AttachmentRegistry.INSTANCE.addFactory(ExtractorAttachmentType.ULTIMATE.getId(), new ExtractorAttachmentFactory(ExtractorAttachmentType.ULTIMATE));
        TransportCallbackFactoryRegistry.INSTANCE.addFactory(ItemInsertTransportCallback.ID, ItemInsertTransportCallback::of);
        TransportCallbackFactoryRegistry.INSTANCE.addFactory(ItemBounceBackTransportCallback.ID, ItemBounceBackTransportCallback::of);
        TransportCallbackFactoryRegistry.INSTANCE.addFactory(ItemPipeGoneTransportCallback.ID, ItemPipeGoneTransportCallback::of);
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent e) {
        RefinedPipes.NETWORK.register();
    }

    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().register((IForgeRegistryEntry)new ItemPipeBlock(PIPE_SHAPE_CACHE, ItemPipeType.BASIC));
        e.getRegistry().register((IForgeRegistryEntry)new ItemPipeBlock(PIPE_SHAPE_CACHE, ItemPipeType.IMPROVED));
        e.getRegistry().register((IForgeRegistryEntry)new ItemPipeBlock(PIPE_SHAPE_CACHE, ItemPipeType.ADVANCED));
        e.getRegistry().register((IForgeRegistryEntry)new FluidPipeBlock(PIPE_SHAPE_CACHE, FluidPipeType.BASIC));
        e.getRegistry().register((IForgeRegistryEntry)new FluidPipeBlock(PIPE_SHAPE_CACHE, FluidPipeType.IMPROVED));
        e.getRegistry().register((IForgeRegistryEntry)new FluidPipeBlock(PIPE_SHAPE_CACHE, FluidPipeType.ADVANCED));
        e.getRegistry().register((IForgeRegistryEntry)new FluidPipeBlock(PIPE_SHAPE_CACHE, FluidPipeType.ELITE));
        e.getRegistry().register((IForgeRegistryEntry)new FluidPipeBlock(PIPE_SHAPE_CACHE, FluidPipeType.ULTIMATE));
        e.getRegistry().register((IForgeRegistryEntry)new EnergyPipeBlock(PIPE_SHAPE_CACHE, EnergyPipeType.BASIC));
        e.getRegistry().register((IForgeRegistryEntry)new EnergyPipeBlock(PIPE_SHAPE_CACHE, EnergyPipeType.IMPROVED));
        e.getRegistry().register((IForgeRegistryEntry)new EnergyPipeBlock(PIPE_SHAPE_CACHE, EnergyPipeType.ADVANCED));
        e.getRegistry().register((IForgeRegistryEntry)new EnergyPipeBlock(PIPE_SHAPE_CACHE, EnergyPipeType.ELITE));
        e.getRegistry().register((IForgeRegistryEntry)new EnergyPipeBlock(PIPE_SHAPE_CACHE, EnergyPipeType.ULTIMATE));
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> e) {
        e.getRegistry().register((IForgeRegistryEntry)new ItemPipeBlockItem(RefinedPipesBlocks.BASIC_ITEM_PIPE));
        e.getRegistry().register((IForgeRegistryEntry)new ItemPipeBlockItem(RefinedPipesBlocks.IMPROVED_ITEM_PIPE));
        e.getRegistry().register((IForgeRegistryEntry)new ItemPipeBlockItem(RefinedPipesBlocks.ADVANCED_ITEM_PIPE));
        e.getRegistry().register((IForgeRegistryEntry)new FluidPipeBlockItem(RefinedPipesBlocks.BASIC_FLUID_PIPE));
        e.getRegistry().register((IForgeRegistryEntry)new FluidPipeBlockItem(RefinedPipesBlocks.IMPROVED_FLUID_PIPE));
        e.getRegistry().register((IForgeRegistryEntry)new FluidPipeBlockItem(RefinedPipesBlocks.ADVANCED_FLUID_PIPE));
        e.getRegistry().register((IForgeRegistryEntry)new FluidPipeBlockItem(RefinedPipesBlocks.ELITE_FLUID_PIPE));
        e.getRegistry().register((IForgeRegistryEntry)new FluidPipeBlockItem(RefinedPipesBlocks.ULTIMATE_FLUID_PIPE));
        e.getRegistry().register((IForgeRegistryEntry)new EnergyPipeBlockItem(RefinedPipesBlocks.BASIC_ENERGY_PIPE));
        e.getRegistry().register((IForgeRegistryEntry)new EnergyPipeBlockItem(RefinedPipesBlocks.IMPROVED_ENERGY_PIPE));
        e.getRegistry().register((IForgeRegistryEntry)new EnergyPipeBlockItem(RefinedPipesBlocks.ADVANCED_ENERGY_PIPE));
        e.getRegistry().register((IForgeRegistryEntry)new EnergyPipeBlockItem(RefinedPipesBlocks.ELITE_ENERGY_PIPE));
        e.getRegistry().register((IForgeRegistryEntry)new EnergyPipeBlockItem(RefinedPipesBlocks.ULTIMATE_ENERGY_PIPE));
        for (AttachmentFactory factory : AttachmentRegistry.INSTANCE.all()) {
            e.getRegistry().register((IForgeRegistryEntry)new AttachmentItem(factory));
        }
    }

    @SubscribeEvent
    public static void onRegisterBlockEntities(RegistryEvent.Register<BlockEntityType<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new ItemPipeBlockEntity(pos, state, ItemPipeType.BASIC), (Block[])new Block[]{RefinedPipesBlocks.BASIC_ITEM_PIPE}).m_58966_(null).setRegistryName(ItemPipeType.BASIC.getId())));
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new ItemPipeBlockEntity(pos, state, ItemPipeType.IMPROVED), (Block[])new Block[]{RefinedPipesBlocks.IMPROVED_ITEM_PIPE}).m_58966_(null).setRegistryName(ItemPipeType.IMPROVED.getId())));
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new ItemPipeBlockEntity(pos, state, ItemPipeType.ADVANCED), (Block[])new Block[]{RefinedPipesBlocks.ADVANCED_ITEM_PIPE}).m_58966_(null).setRegistryName(ItemPipeType.ADVANCED.getId())));
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new FluidPipeBlockEntity(pos, state, FluidPipeType.BASIC), (Block[])new Block[]{RefinedPipesBlocks.BASIC_FLUID_PIPE}).m_58966_(null).setRegistryName(FluidPipeType.BASIC.getId())));
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new FluidPipeBlockEntity(pos, state, FluidPipeType.IMPROVED), (Block[])new Block[]{RefinedPipesBlocks.IMPROVED_FLUID_PIPE}).m_58966_(null).setRegistryName(FluidPipeType.IMPROVED.getId())));
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new FluidPipeBlockEntity(pos, state, FluidPipeType.ADVANCED), (Block[])new Block[]{RefinedPipesBlocks.ADVANCED_FLUID_PIPE}).m_58966_(null).setRegistryName(FluidPipeType.ADVANCED.getId())));
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new FluidPipeBlockEntity(pos, state, FluidPipeType.ELITE), (Block[])new Block[]{RefinedPipesBlocks.ELITE_FLUID_PIPE}).m_58966_(null).setRegistryName(FluidPipeType.ELITE.getId())));
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new FluidPipeBlockEntity(pos, state, FluidPipeType.ULTIMATE), (Block[])new Block[]{RefinedPipesBlocks.ULTIMATE_FLUID_PIPE}).m_58966_(null).setRegistryName(FluidPipeType.ULTIMATE.getId())));
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new EnergyPipeBlockEntity(pos, state, EnergyPipeType.BASIC), (Block[])new Block[]{RefinedPipesBlocks.BASIC_ENERGY_PIPE}).m_58966_(null).setRegistryName(EnergyPipeType.BASIC.getId())));
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new EnergyPipeBlockEntity(pos, state, EnergyPipeType.IMPROVED), (Block[])new Block[]{RefinedPipesBlocks.IMPROVED_ENERGY_PIPE}).m_58966_(null).setRegistryName(EnergyPipeType.IMPROVED.getId())));
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new EnergyPipeBlockEntity(pos, state, EnergyPipeType.ADVANCED), (Block[])new Block[]{RefinedPipesBlocks.ADVANCED_ENERGY_PIPE}).m_58966_(null).setRegistryName(EnergyPipeType.ADVANCED.getId())));
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new EnergyPipeBlockEntity(pos, state, EnergyPipeType.ELITE), (Block[])new Block[]{RefinedPipesBlocks.ELITE_ENERGY_PIPE}).m_58966_(null).setRegistryName(EnergyPipeType.ELITE.getId())));
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new EnergyPipeBlockEntity(pos, state, EnergyPipeType.ULTIMATE), (Block[])new Block[]{RefinedPipesBlocks.ULTIMATE_ENERGY_PIPE}).m_58966_(null).setRegistryName(EnergyPipeType.ULTIMATE.getId())));
    }

    @SubscribeEvent
    public static void onRegisterContainerMenus(RegistryEvent.Register<MenuType<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((MenuType)IForgeMenuType.create((IContainerFactory)new ExtractorAttachmentContainerFactory()).setRegistryName("refinedpipes", "extractor_attachment")));
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.WorldTickEvent e) {
        if (!e.world.f_46443_ && e.phase == TickEvent.Phase.END) {
            NetworkManager.get(e.world).getNetworks().forEach(n -> n.update(e.world));
        }
    }
}

