/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.config;

import com.google.common.base.Preconditions;
import mezz.jei.core.config.IServerConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.Nullable;

public final class ServerConfig
implements IServerConfig {
    @Nullable
    private static IServerConfig instance;
    private final ForgeConfigSpec.BooleanValue enableCheatModeForOp;
    private final ForgeConfigSpec.BooleanValue enableCheatModeForCreative;
    private final ForgeConfigSpec.BooleanValue enableCheatModeForGive;

    public static IServerConfig register(ModLoadingContext modLoadingContext) {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        instance = new ServerConfig(builder);
        ForgeConfigSpec config = builder.build();
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)config);
        return instance;
    }

    public ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("cheat mode");
        builder.comment("Enable Cheat Mode for Operators (/op)");
        this.enableCheatModeForOp = builder.define("enableCheatModeForOp", true);
        builder.comment("Enable Cheat Mode for users in Creative Mode");
        this.enableCheatModeForCreative = builder.define("enableCheatModeForCreative", true);
        builder.comment("Enable Cheat Mode for users who can use /give");
        this.enableCheatModeForGive = builder.define("enableCheatModeForGive", false);
        builder.pop();
    }

    public static IServerConfig getInstance() {
        Preconditions.checkNotNull((Object)instance);
        return instance;
    }

    @Override
    public boolean isCheatModeEnabledForOp() {
        return (Boolean)this.enableCheatModeForOp.get();
    }

    @Override
    public boolean isCheatModeEnabledForCreative() {
        return (Boolean)this.enableCheatModeForCreative.get();
    }

    @Override
    public boolean isCheatModeEnabledForGive() {
        return (Boolean)this.enableCheatModeForGive.get();
    }
}

