/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input.mouse.handlers;

import java.util.Optional;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.LimitedAreaInputHandler;
import mezz.jei.recipes.FocusFactory;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;

public class GuiAreaInputHandler
implements IUserInputHandler {
    private final FocusFactory focusFactory;
    private final GuiScreenHelper guiScreenHelper;
    private final RecipesGui recipesGui;

    public GuiAreaInputHandler(RegisteredIngredients registeredIngredients, GuiScreenHelper guiScreenHelper, RecipesGui recipesGui) {
        this.focusFactory = new FocusFactory(registeredIngredients);
        this.guiScreenHelper = guiScreenHelper;
        this.recipesGui = recipesGui;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input) {
        if (input.is(KeyBindings.leftClick) && screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen guiContainer = (AbstractContainerScreen)screen;
            double guiMouseX = input.getMouseX() - (double)guiContainer.getGuiLeft();
            double guiMouseY = input.getMouseY() - (double)guiContainer.getGuiTop();
            return this.guiScreenHelper.getGuiClickableArea(guiContainer, guiMouseX, guiMouseY).map(clickableArea -> {
                if (!input.isSimulate()) {
                    clickableArea.onClick(this.focusFactory, this.recipesGui);
                }
                ImmutableRect2i screenArea = new ImmutableRect2i(clickableArea.getArea()).addOffset(guiContainer.getGuiLeft(), guiContainer.getGuiTop());
                return LimitedAreaInputHandler.create(this, screenArea);
            });
        }
        return Optional.empty();
    }
}

