/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.debug;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.gui.textures.Textures;
import mezz.jei.plugins.debug.DebugRecipe;
import mezz.jei.plugins.debug.JeiDebugPlugin;
import mezz.jei.plugins.jei.ingredients.DebugIngredient;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.fluids.FluidStack;

public class LegacyDebugRecipeCategory
implements IRecipeCategory<DebugRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("jei", "legacy_debug");
    public static final int RECIPE_WIDTH = 160;
    public static final int RECIPE_HEIGHT = 60;
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable tankBackground;
    private final IDrawable tankOverlay;
    private final IDrawable item;
    private boolean hiddenRecipes;

    public LegacyDebugRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(160, 60);
        this.localizedName = new TextComponent("debug");
        ResourceLocation backgroundTexture = new ResourceLocation("jei", "textures/gui/debug.png");
        this.tankBackground = guiHelper.drawableBuilder(backgroundTexture, 220, 196, 18, 60).addPadding(-1, -1, -1, -1).build();
        this.tankOverlay = guiHelper.drawableBuilder(backgroundTexture, 238, 196, 18, 60).addPadding(-1, -1, -1, -1).build();
        this.item = guiHelper.createDrawableIngredient(VanillaTypes.ITEM_STACK, new ItemStack((ItemLike)Items.f_41900_));
    }

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public Class<? extends DebugRecipe> getRecipeClass() {
        return DebugRecipe.class;
    }

    @Override
    public Component getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        Textures textures = Internal.getTextures();
        return textures.getConfigButtonIcon();
    }

    @Override
    public void setIngredients(DebugRecipe recipe, IIngredients ingredients) {
        FluidStack water = new FluidStack((Fluid)Fluids.f_76193_, (int)((1.0 + Math.random()) * 1000.0));
        FluidStack lava = new FluidStack((Fluid)Fluids.f_76195_, (int)((1.0 + Math.random()) * 1000.0));
        ingredients.setInputs(ForgeTypes.FLUID_STACK, List.of(water, lava));
        ingredients.setInput(VanillaTypes.ITEM_STACK, new ItemStack((ItemLike)Items.f_42398_));
        ingredients.setInputLists(DebugIngredient.TYPE, List.of(List.of(new DebugIngredient(0), new DebugIngredient(1))));
        ingredients.setOutputs(DebugIngredient.TYPE, List.of(new DebugIngredient(2), new DebugIngredient(3)));
    }

    @Override
    public void draw(DebugRecipe recipe, PoseStack poseStack, double mouseX, double mouseY) {
        IJeiRuntime runtime = JeiDebugPlugin.jeiRuntime;
        if (runtime != null) {
            this.item.draw(poseStack, 50, 20);
            IIngredientFilter ingredientFilter = runtime.getIngredientFilter();
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.f_91062_.m_92883_(poseStack, ingredientFilter.getFilterText(), 20.0f, 52.0f, 0);
            IIngredientListOverlay ingredientListOverlay = runtime.getIngredientListOverlay();
            IIngredientManager ingredientManager = runtime.getIngredientManager();
            Collection<IIngredientType<?>> ingredientTypes = ingredientManager.getRegisteredIngredientTypes();
            for (IIngredientType<?> ingredientType : ingredientTypes) {
                Object ingredientUnderMouse = ingredientListOverlay.getIngredientUnderMouse(ingredientType);
                if (ingredientUnderMouse != null) {
                    LegacyDebugRecipeCategory.drawIngredientName(minecraft, poseStack, ingredientUnderMouse);
                    break;
                }
                IBookmarkOverlay bookmarkOverlay = runtime.getBookmarkOverlay();
                ingredientUnderMouse = bookmarkOverlay.getIngredientUnderMouse(ingredientType);
                if (ingredientUnderMouse == null) continue;
                LegacyDebugRecipeCategory.drawIngredientName(minecraft, poseStack, ingredientUnderMouse);
                break;
            }
        }
        ExtendedButton button = recipe.getButton();
        button.m_6305_(poseStack, (int)mouseX, (int)mouseY, 0.0f);
    }

    private static <T> void drawIngredientName(Minecraft minecraft, PoseStack poseStack, T ingredient) {
        IIngredientManager ingredientManager = JeiDebugPlugin.ingredientManager;
        if (ingredientManager != null) {
            IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredient);
            String jeiUid = ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
            minecraft.f_91062_.m_92883_(poseStack, jeiUid, 50.0f, 52.0f, 0);
        }
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, DebugRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                tooltip.add(new TextComponent(slotIndex + " Input itemStack"));
            } else {
                tooltip.add(new TextComponent(slotIndex + " Output itemStack"));
            }
        });
        guiItemStacks.init(0, false, 70, 0);
        guiItemStacks.init(1, true, 110, 0);
        guiItemStacks.set(0, new ItemStack((ItemLike)Items.f_42447_));
        guiItemStacks.set(1, Arrays.asList(new ItemStack((ItemLike)Items.f_42448_), null));
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiFluidStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                tooltip.add(new TextComponent(slotIndex + " Input fluidStack"));
            } else {
                tooltip.add(new TextComponent(slotIndex + " Output fluidStack"));
            }
        });
        guiFluidStacks.init(0, false, 90, 0, 16, 58, 16000, false, this.tankOverlay);
        guiFluidStacks.init(1, true, 24, 0, 12, 47, 2000, true, null);
        guiFluidStacks.setBackground(0, this.tankBackground);
        List fluidInputs = ingredients.getInputs(ForgeTypes.FLUID_STACK);
        guiFluidStacks.set(0, fluidInputs.get(0));
        guiFluidStacks.set(1, fluidInputs.get(1));
        IGuiIngredientGroup<DebugIngredient> debugIngredientsGroup = recipeLayout.getIngredientsGroup(DebugIngredient.TYPE);
        debugIngredientsGroup.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                tooltip.add(new TextComponent(slotIndex + " Input DebugIngredient"));
            } else {
                tooltip.add(new TextComponent(slotIndex + " Output DebugIngredient"));
            }
        });
        debugIngredientsGroup.init(0, true, 40, 0);
        debugIngredientsGroup.init(1, false, 40, 16);
        debugIngredientsGroup.init(2, false, 40, 32);
        debugIngredientsGroup.set(ingredients);
    }

    @Override
    public List<Component> getTooltipStrings(DebugRecipe recipe, double mouseX, double mouseY) {
        ArrayList<Component> tooltipStrings = new ArrayList<Component>();
        tooltipStrings.add((Component)new TextComponent("Debug Recipe Category Tooltip is very long and going to wrap").m_130940_(ChatFormatting.GOLD));
        if (recipe.checkHover(mouseX, mouseY)) {
            tooltipStrings.add((Component)new TextComponent("button tooltip!"));
        } else {
            TextComponent debug = new TextComponent("tooltip debug");
            tooltipStrings.add((Component)debug.m_130940_(ChatFormatting.BOLD));
        }
        tooltipStrings.add((Component)new TextComponent(mouseX + ", " + mouseY));
        return tooltipStrings;
    }

    @Override
    public boolean handleInput(DebugRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() != InputConstants.Type.MOUSE) {
            return false;
        }
        ExtendedButton button = recipe.getButton();
        int mouseButton = input.m_84873_();
        if (mouseButton == 0 && button.m_6375_(mouseX, mouseY, mouseButton)) {
            IJeiRuntime runtime;
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                InventoryScreen screen = new InventoryScreen((Player)player);
                minecraft.m_91152_((Screen)screen);
            }
            if ((runtime = JeiDebugPlugin.jeiRuntime) != null) {
                IIngredientFilter ingredientFilter = runtime.getIngredientFilter();
                String filterText = ingredientFilter.getFilterText();
                ingredientFilter.setFilterText(filterText + " test");
                IRecipeManager recipeManager = runtime.getRecipeManager();
                if (!this.hiddenRecipes) {
                    recipeManager.hideRecipeCategory(VanillaRecipeCategoryUid.CRAFTING);
                    this.hiddenRecipes = true;
                } else {
                    recipeManager.unhideRecipeCategory(VanillaRecipeCategoryUid.CRAFTING);
                    this.hiddenRecipes = false;
                }
            }
            return true;
        }
        return false;
    }
}

