/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.behaviors;

import appeng.api.behaviors.PickupSink;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.stacks.AEKeyType;
import appeng.parts.automation.StackWorldBehaviors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public interface PickupStrategy {
    public void reset();

    public boolean canPickUpEntity(Entity var1);

    public boolean pickUpEntity(IEnergySource var1, PickupSink var2, Entity var3);

    public Result tryStartPickup(IEnergySource var1, PickupSink var2);

    public void completePickup(IEnergySource var1, PickupSink var2);

    public static void register(AEKeyType type, Factory factory) {
        StackWorldBehaviors.registerPickupStrategy(type, factory);
    }

    @FunctionalInterface
    public static interface Factory {
        public PickupStrategy create(ServerLevel var1, BlockPos var2, Direction var3, BlockEntity var4, boolean var5);
    }

    public static enum Result {
        CANT_PICKUP,
        CANT_STORE,
        PICKED_UP;

    }
}

