/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.crafting;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.crafting.CraftingBlockEntity;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.crafting.CraftingCPUMenu;
import appeng.util.InteractionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractCraftingUnitBlock<T extends CraftingBlockEntity>
extends AEBaseEntityBlock<T> {
    public static final BooleanProperty FORMED = BooleanProperty.m_61465_((String)"formed");
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    public final CraftingUnitType type;

    public AbstractCraftingUnitBlock(BlockBehaviour.Properties props, CraftingUnitType type) {
        super(props);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FORMED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
        builder.m_61104_(new Property[]{FORMED});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockEntity te = level.m_7702_(currentPos);
        if (te != null) {
            te.requestModelDataUpdate();
        }
        return super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        CraftingBlockEntity cp = (CraftingBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (cp != null) {
            cp.updateMultiBlock(fromPos);
        }
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() == state.m_60734_()) {
            return;
        }
        CraftingBlockEntity cp = (CraftingBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (cp != null) {
            cp.breakCluster();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player p, InteractionHand hand, BlockHitResult hit) {
        CraftingBlockEntity tg = (CraftingBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (tg != null && !InteractionUtil.isInAlternateUseMode(p) && tg.isFormed() && tg.isActive()) {
            if (!level.m_5776_()) {
                hit.m_82434_();
                MenuOpener.open(CraftingCPUMenu.TYPE, p, MenuLocators.forBlockEntity(tg));
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, p, hand, hit);
    }

    public static enum CraftingUnitType {
        UNIT,
        ACCELERATOR,
        STORAGE_1K,
        STORAGE_4K,
        STORAGE_16K,
        STORAGE_64K,
        STORAGE_256K,
        MONITOR;

    }
}

