/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.items;

import appeng.api.config.ActionItems;
import appeng.api.stacks.GenericStack;
import appeng.client.Point;
import appeng.client.gui.Icon;
import appeng.client.gui.me.common.MEStorageScreen;
import appeng.client.gui.me.items.SetProcessingPatternAmountScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.IconButton;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.TabButton;
import appeng.client.gui.widgets.ToggleButton;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.SlotSemantics;
import appeng.menu.me.interaction.EmptyingAction;
import appeng.menu.me.interaction.StackInteractions;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.FakeSlot;
import appeng.parts.encoding.EncodingMode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class PatternEncodingTermScreen<C extends PatternEncodingTermMenu>
extends MEStorageScreen<C> {
    private static final String MODES_TEXTURE = "guis/pattern_modes.png";
    private static final Blitter CRAFTING_MODE_BG = Blitter.texture("guis/pattern_modes.png").src(0, 0, 126, 68);
    private static final Blitter PROCESSING_MODE_BG = Blitter.texture("guis/pattern_modes.png").src(0, 70, 126, 68);
    private final TabButton tabCraftButton;
    private final TabButton tabProcessButton;
    private final Multimap<EncodingMode, IconButton> buttonsByMode = ArrayListMultimap.create();
    private final ToggleButton craftingSubstitutionsBtn;
    private final ToggleButton craftingFluidSubstitutionsBtn;
    private final ActionButton processingCycleOutputBtn;
    private final Scrollbar processingScrollbar;

    public PatternEncodingTermScreen(C menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        ActionButton craftingClearBtn = new ActionButton(ActionItems.CLOSE, act -> menu.clear());
        craftingClearBtn.setHalfSize(true);
        this.widgets.add("craftingClearPattern", (AbstractWidget)craftingClearBtn);
        this.buttonsByMode.put((Object)EncodingMode.CRAFTING, (Object)craftingClearBtn);
        ActionButton processingClearBtn = new ActionButton(ActionItems.CLOSE, act -> menu.clear());
        processingClearBtn.setHalfSize(true);
        this.widgets.add("processingClearPattern", (AbstractWidget)processingClearBtn);
        this.buttonsByMode.put((Object)EncodingMode.PROCESSING, (Object)processingClearBtn);
        this.craftingSubstitutionsBtn = this.createCraftingSubstitutionButton();
        this.craftingFluidSubstitutionsBtn = this.createCraftingFluidSubstitutionButton();
        this.processingCycleOutputBtn = new ActionButton(ActionItems.CYCLE_PROCESSING_OUTPUT, act -> ((PatternEncodingTermMenu)this.m_6262_()).cycleProcessingOutput());
        this.processingCycleOutputBtn.setHalfSize(true);
        this.widgets.add("processingCycleOutput", (AbstractWidget)this.processingCycleOutputBtn);
        this.processingScrollbar = this.widgets.addScrollBar("processingPatternModeScrollbar", Scrollbar.SMALL);
        this.processingScrollbar.setRange(0, ((PatternEncodingTermMenu)menu).getProcessingInputSlots().length / 3 - 3, 3);
        this.processingScrollbar.setCaptureMouseWheel(false);
        ActionButton encodeBtn = new ActionButton(ActionItems.ENCODE, act -> menu.encode());
        this.widgets.add("encodePattern", (AbstractWidget)encodeBtn);
        this.tabCraftButton = new TabButton(new ItemStack((ItemLike)Blocks.f_50091_), (Component)GuiText.CraftingPattern.text(), this.f_96542_, btn -> ((PatternEncodingTermMenu)this.m_6262_()).setMode(EncodingMode.PROCESSING));
        this.widgets.add("craftingPatternMode", (AbstractWidget)this.tabCraftButton);
        this.tabProcessButton = new TabButton(new ItemStack((ItemLike)Blocks.f_50094_), (Component)GuiText.ProcessingPattern.text(), this.f_96542_, btn -> ((PatternEncodingTermMenu)this.m_6262_()).setMode(EncodingMode.CRAFTING));
        this.widgets.add("processingPatternMode", (AbstractWidget)this.tabProcessButton);
    }

    private ToggleButton createCraftingSubstitutionButton() {
        ToggleButton button = new ToggleButton(Icon.SUBSTITUTION_ENABLED, Icon.SUBSTITUTION_DISABLED, ((PatternEncodingTermMenu)this.m_6262_())::setSubstitute);
        button.setHalfSize(true);
        button.setTooltipOn(List.of(ButtonToolTips.Substitutions.text(), ButtonToolTips.SubstitutionsDescEnabled.text()));
        button.setTooltipOff(List.of(ButtonToolTips.Substitutions.text(), ButtonToolTips.SubstitutionsDescDisabled.text()));
        this.widgets.add("craftingSubstitutions", (AbstractWidget)button);
        this.buttonsByMode.put((Object)EncodingMode.CRAFTING, (Object)button);
        return button;
    }

    private ToggleButton createCraftingFluidSubstitutionButton() {
        ToggleButton button = new ToggleButton(Icon.FLUID_SUBSTITUTION_ENABLED, Icon.FLUID_SUBSTITUTION_DISABLED, ((PatternEncodingTermMenu)this.m_6262_())::setSubstituteFluids);
        button.setHalfSize(true);
        button.setTooltipOn(List.of(ButtonToolTips.FluidSubstitutions.text(), ButtonToolTips.FluidSubstitutionsDescEnabled.text()));
        button.setTooltipOff(List.of(ButtonToolTips.FluidSubstitutions.text(), ButtonToolTips.FluidSubstitutionsDescDisabled.text()));
        this.widgets.add("craftingFluidSubstitutions", (AbstractWidget)button);
        this.buttonsByMode.put((Object)EncodingMode.CRAFTING, (Object)button);
        return button;
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        for (Map.Entry entry : this.buttonsByMode.entries()) {
            ((IconButton)entry.getValue()).setVisibility(((PatternEncodingTermMenu)this.f_97732_).getMode() == entry.getKey());
        }
        EncodingMode mode = ((PatternEncodingTermMenu)this.f_97732_).getMode();
        this.processingScrollbar.setVisible(mode == EncodingMode.PROCESSING);
        this.processingCycleOutputBtn.setVisibility(((PatternEncodingTermMenu)this.f_97732_).canCycleProcessingOutputs());
        this.setSlotsHidden(SlotSemantics.CRAFTING_GRID, mode != EncodingMode.CRAFTING);
        this.setSlotsHidden(SlotSemantics.CRAFTING_RESULT, mode != EncodingMode.CRAFTING);
        this.setSlotsHidden(SlotSemantics.PROCESSING_INPUTS, mode != EncodingMode.PROCESSING);
        this.setSlotsHidden(SlotSemantics.PROCESSING_OUTPUTS, mode != EncodingMode.PROCESSING);
        if (mode == EncodingMode.CRAFTING) {
            this.tabCraftButton.f_93624_ = true;
            this.tabProcessButton.f_93624_ = false;
            this.craftingSubstitutionsBtn.setState(((PatternEncodingTermMenu)this.f_97732_).substitute);
            this.craftingFluidSubstitutionsBtn.setState(((PatternEncodingTermMenu)this.f_97732_).substituteFluids);
        } else {
            int effectiveRow;
            FakeSlot slot;
            int i;
            this.tabCraftButton.f_93624_ = false;
            this.tabProcessButton.f_93624_ = true;
            this.repositionSlots(SlotSemantics.PROCESSING_INPUTS);
            this.repositionSlots(SlotSemantics.PROCESSING_OUTPUTS);
            for (i = 0; i < ((PatternEncodingTermMenu)this.f_97732_).getProcessingInputSlots().length; ++i) {
                slot = ((PatternEncodingTermMenu)this.f_97732_).getProcessingInputSlots()[i];
                effectiveRow = i / 3 - this.processingScrollbar.getCurrentScroll();
                slot.setActive(effectiveRow >= 0 && effectiveRow < 3);
                slot.f_40221_ -= this.processingScrollbar.getCurrentScroll() * 18;
            }
            for (i = 0; i < ((PatternEncodingTermMenu)this.f_97732_).getProcessingOutputSlots().length; ++i) {
                slot = ((PatternEncodingTermMenu)this.f_97732_).getProcessingOutputSlots()[i];
                effectiveRow = i - this.processingScrollbar.getCurrentScroll();
                slot.setActive(effectiveRow >= 0 && effectiveRow < 3);
                slot.f_40221_ -= this.processingScrollbar.getCurrentScroll() * 18;
            }
        }
        this.widgets.setTooltipAreaEnabled("processing-primary-output", mode == EncodingMode.PROCESSING && this.processingScrollbar.getCurrentScroll() == 0);
        this.widgets.setTooltipAreaEnabled("processing-optional-output1", mode == EncodingMode.PROCESSING && this.processingScrollbar.getCurrentScroll() > 0);
        this.widgets.setTooltipAreaEnabled("processing-optional-output2", mode == EncodingMode.PROCESSING);
        this.widgets.setTooltipAreaEnabled("processing-optional-output3", mode == EncodingMode.PROCESSING);
    }

    @Override
    public void drawBG(PoseStack poseStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(poseStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        EncodingMode mode = ((PatternEncodingTermMenu)this.f_97732_).getMode();
        this.getModeBlitter(mode).blit(poseStack, this.m_93252_());
        if (mode == EncodingMode.CRAFTING && ((PatternEncodingTermMenu)this.f_97732_).substituteFluids && this.craftingFluidSubstitutionsBtn.m_5953_(mouseX, mouseY)) {
            for (Integer slotIndex : ((PatternEncodingTermMenu)this.f_97732_).slotsSupportingFluidSubstitution) {
                this.drawSlotGreenBG(poseStack, ((PatternEncodingTermMenu)this.f_97732_).getCraftingGridSlots()[slotIndex]);
            }
        }
    }

    protected Blitter getModeBlitter(EncodingMode mode) {
        Blitter modeBg = mode == EncodingMode.CRAFTING ? CRAFTING_MODE_BG : PROCESSING_MODE_BG;
        modeBg.dest(this.getGuiLeft() + 9, this.getGuiTop() + this.f_97727_ - 164);
        return modeBg;
    }

    private void drawSlotGreenBG(PoseStack poseStack, Slot slot) {
        int x = this.getGuiLeft() + slot.f_40220_;
        int y = this.getGuiTop() + slot.f_40221_;
        PatternEncodingTermScreen.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)0x7F00FF00);
    }

    @Override
    public boolean m_6375_(double xCoord, double yCoord, int btn) {
        GenericStack currentStack;
        Slot slot;
        if (this.f_96541_.f_91066_.f_92097_.m_90830_(btn) && ((PatternEncodingTermMenu)this.f_97732_).canModifyAmountForSlot(slot = this.m_97744_(xCoord, yCoord)) && (currentStack = GenericStack.fromItemStack(slot.m_7993_())) != null) {
            SetProcessingPatternAmountScreen screen = new SetProcessingPatternAmountScreen(this, currentStack, newStack -> NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, slot.f_40219_, GenericStack.wrapInItemStack(newStack))));
            this.switchToScreen(screen);
            return true;
        }
        return super.m_6375_(xCoord, yCoord, btn);
    }

    @Override
    protected void m_7025_(PoseStack poseStack, int x, int y) {
        if (((PatternEncodingTermMenu)this.f_97732_).m_142621_().m_41619_() && ((PatternEncodingTermMenu)this.f_97732_).canModifyAmountForSlot(this.f_97734_)) {
            ArrayList<Component> itemTooltip = new ArrayList<Component>(this.m_96555_(this.f_97734_.m_7993_()));
            GenericStack unwrapped = GenericStack.fromItemStack(this.f_97734_.m_7993_());
            if (unwrapped != null) {
                itemTooltip.add(Tooltips.getAmountTooltip(ButtonToolTips.Amount, unwrapped));
            }
            itemTooltip.add(Tooltips.getSetAmountTooltip());
            this.drawTooltip(poseStack, x, y, itemTooltip);
        } else {
            super.m_7025_(poseStack, x, y);
        }
    }

    @Override
    protected EmptyingAction getEmptyingAction(Slot slot, ItemStack carried) {
        EmptyingAction emptyingAction;
        if (((PatternEncodingTermMenu)this.f_97732_).isProcessingPatternSlot(slot) && (emptyingAction = StackInteractions.getEmptyingAction(carried)) != null) {
            return emptyingAction;
        }
        return super.getEmptyingAction(slot, carried);
    }

    @Override
    public boolean m_6050_(double x, double y, double wheelDelta) {
        Blitter modeBg;
        if (((PatternEncodingTermMenu)this.f_97732_).getMode() == EncodingMode.PROCESSING && (this.f_97734_ == null || ((PatternEncodingTermMenu)this.f_97732_).isProcessingPatternSlot(this.f_97734_)) && (modeBg = this.getModeBlitter(EncodingMode.PROCESSING)).getDestRect().m_110087_((int)x, (int)y) && this.processingScrollbar.onMouseWheel(new Point((int)x, (int)y), wheelDelta)) {
            return true;
        }
        return super.m_6050_(x, y, wheelDelta);
    }
}

