/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.api.implementations.blockentities.ICrystalGrowthAccelerator;
import appeng.api.implementations.items.IGrowableCrystal;
import appeng.client.EffectType;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.definitions.AEEntities;
import appeng.entity.AEBaseItemEntity;
import appeng.items.misc.CrystalSeedItem;
import java.time.Duration;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public final class GrowingCrystalEntity
extends AEBaseItemEntity {
    private static final Random CLIENT_EFFECTS_RNG = new Random();
    private static final int[] GROWTH_TICK_PROGRESS = new int[]{1, 10, 20, 30, 40, 50, 60};

    public static Duration getGrowthDuration(int accelerators) {
        int progressPerTick = GROWTH_TICK_PROGRESS[Math.min(GROWTH_TICK_PROGRESS.length - 1, accelerators)];
        int ticks = 24000 / progressPerTick;
        return Duration.ofMillis(ticks * 1000 / 20);
    }

    public GrowingCrystalEntity(EntityType<? extends GrowingCrystalEntity> type, Level level) {
        super(type, level);
    }

    public GrowingCrystalEntity(Level level, double x, double y, double z, ItemStack is) {
        super(AEEntities.GROWING_CRYSTAL, level, x, y, z, is);
        this.m_32064_();
    }

    public void m_8119_() {
        super.m_8119_();
        ItemStack is = this.m_32055_();
        Item gc = is.m_41720_();
        if (!(gc instanceof IGrowableCrystal)) {
            return;
        }
        this.applyGrowthTick((IGrowableCrystal)gc, is);
    }

    private void applyGrowthTick(IGrowableCrystal crystal, ItemStack is) {
        int z;
        int y;
        if (!AEConfig.instance().isInWorldCrystalGrowthEnabled()) {
            return;
        }
        int x = Mth.m_14107_((double)this.m_20185_());
        BlockPos pos = new BlockPos(x, y = Mth.m_14107_((double)((this.m_142469_().f_82289_ + this.m_142469_().f_82292_) / 2.0)), z = Mth.m_14107_((double)this.m_20189_()));
        BlockState state = this.f_19853_.m_8055_(pos);
        float multiplier = crystal.getMultiplier(state, this.f_19853_, pos);
        if (multiplier <= 0.0f) {
            return;
        }
        int progressPerTick = (int)Math.max(1.0f, (float)this.getSpeed(pos) * multiplier);
        if (this.f_19853_.m_5776_()) {
            int bound = GrowingCrystalEntity.getTicksBetweenParticleEffects(progressPerTick);
            if (CLIENT_EFFECTS_RNG.nextInt(bound) == 0) {
                AppEng.instance().spawnEffect(EffectType.Vibrant, this.f_19853_, this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), null);
            }
        } else {
            ItemStack newItem = is.m_41777_();
            int loopCounter = progressPerTick;
            do {
                newItem = crystal.triggerGrowth(newItem);
            } while (--loopCounter > 0 && newItem.m_41720_() == is.m_41720_());
            this.m_32045_(newItem);
            if (is.m_41720_() != newItem.m_41720_() && this.getPersistentData().m_128441_("PreventRemoteMovement")) {
                this.getPersistentData().m_128473_("PreventRemoteMovement");
            }
        }
    }

    private static int getTicksBetweenParticleEffects(int progressPerTick) {
        if (progressPerTick >= GROWTH_TICK_PROGRESS[6]) {
            return 1;
        }
        if (progressPerTick >= GROWTH_TICK_PROGRESS[5]) {
            return 3;
        }
        if (progressPerTick >= GROWTH_TICK_PROGRESS[4]) {
            return 7;
        }
        if (progressPerTick >= GROWTH_TICK_PROGRESS[3]) {
            return 10;
        }
        if (progressPerTick >= GROWTH_TICK_PROGRESS[2]) {
            return 15;
        }
        if (progressPerTick >= GROWTH_TICK_PROGRESS[1]) {
            return 20;
        }
        return 40;
    }

    private int getSpeed(BlockPos pos) {
        int acceleratorCount = this.getAcceleratorCount(pos);
        if (acceleratorCount < 0) {
            return GROWTH_TICK_PROGRESS[0];
        }
        if (acceleratorCount >= GROWTH_TICK_PROGRESS.length) {
            return GROWTH_TICK_PROGRESS[GROWTH_TICK_PROGRESS.length - 1];
        }
        return GROWTH_TICK_PROGRESS[acceleratorCount];
    }

    private int getAcceleratorCount(BlockPos pos) {
        int count = 0;
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            if (!this.isPoweredAccelerator((BlockPos)testPos.m_122159_((Vec3i)pos, direction))) continue;
            ++count;
        }
        return count;
    }

    private boolean isPoweredAccelerator(BlockPos pos) {
        BlockEntity te = this.f_19853_.m_7702_(pos);
        return te instanceof ICrystalGrowthAccelerator && ((ICrystalGrowthAccelerator)te).isPowered();
    }

    protected void m_32067_() {
        ItemStack item = this.m_32055_();
        if (item.m_41720_() instanceof CrystalSeedItem) {
            Vec3 v = this.m_20184_();
            double yAccel = this.m_20068_() ? 0.0 : -0.002;
            this.m_20334_(v.f_82479_ * 0.99, v.f_82480_ + yAccel, v.f_82481_ * 0.99);
            return;
        }
        super.m_32067_();
    }
}

