/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.SelectedPart;
import appeng.core.AEConfig;
import appeng.core.definitions.AEParts;
import appeng.facade.FacadePart;
import appeng.facade.IFacadeItem;
import appeng.items.parts.FacadeItem;
import appeng.parts.BusCollisionHelper;
import appeng.parts.PartPlacement;
import appeng.parts.misc.CableAnchorPart;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.common.MinecraftForge;

public class RenderBlockOutlineHook {
    private RenderBlockOutlineHook() {
    }

    public static void install() {
        MinecraftForge.EVENT_BUS.addListener(RenderBlockOutlineHook::handleEvent);
    }

    private static void handleEvent(DrawSelectionEvent.HighlightBlock evt) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        PoseStack poseStack = evt.getPoseStack();
        MultiBufferSource buffers = evt.getMultiBufferSource();
        Camera camera = evt.getCamera();
        if (level == null || buffers == null) {
            return;
        }
        BlockHitResult blockHitResult = evt.getTarget();
        if (blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        if (RenderBlockOutlineHook.replaceBlockOutline(level, poseStack, buffers, camera, blockHitResult)) {
            evt.setCanceled(true);
        }
    }

    private static boolean replaceBlockOutline(ClientLevel level, PoseStack poseStack, MultiBufferSource buffers, Camera camera, BlockHitResult hitResult) {
        BlockPos pos;
        BlockEntity blockEntity;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        if (AEConfig.instance().isPlacementPreviewEnabled()) {
            ItemStack itemInHand = player.m_21120_(InteractionHand.MAIN_HAND);
            RenderBlockOutlineHook.showPartPlacementPreview((Player)player, poseStack, buffers, camera, hitResult, itemInHand);
        }
        if ((blockEntity = level.m_7702_(pos = hitResult.m_82425_())) instanceof IPartHost) {
            IPartHost partHost = (IPartHost)blockEntity;
            if (AEConfig.instance().isPlacementPreviewEnabled()) {
                ItemStack itemInHand = player.m_21120_(InteractionHand.MAIN_HAND);
                RenderBlockOutlineHook.showFacadePlacementPreview(poseStack, buffers, camera, hitResult, partHost, itemInHand);
            }
            SelectedPart selectedPart = partHost.selectPartWorld(hitResult.m_82450_());
            if (selectedPart.facade != null) {
                RenderBlockOutlineHook.renderFacade(poseStack, buffers, camera, pos, selectedPart.facade, selectedPart.side, false);
                return true;
            }
            if (selectedPart.part != null) {
                RenderBlockOutlineHook.renderPart(poseStack, buffers, camera, pos, selectedPart.part, selectedPart.side, false);
                return true;
            }
        }
        return false;
    }

    private static boolean showFacadePlacementPreview(PoseStack poseStack, MultiBufferSource buffers, Camera camera, BlockHitResult blockHitResult, IPartHost partHost, ItemStack itemInHand) {
        Direction side;
        IFacadeItem facadeItem;
        FacadePart facade;
        BlockPos pos = blockHitResult.m_82425_();
        Item item = itemInHand.m_41720_();
        if (item instanceof IFacadeItem && (facade = (facadeItem = (IFacadeItem)item).createPartFromItemStack(itemInHand, side = blockHitResult.m_82434_())) != null && FacadeItem.canPlaceFacade(partHost, facade)) {
            if (partHost.getPart(side) == null) {
                CableAnchorPart cableAnchor = AEParts.CABLE_ANCHOR.m_5456_().createPart();
                RenderBlockOutlineHook.renderPart(poseStack, buffers, camera, pos, cableAnchor, side, true);
            }
            RenderBlockOutlineHook.renderFacade(poseStack, buffers, camera, pos, facade, side, true);
            return true;
        }
        return false;
    }

    private static void showPartPlacementPreview(Player player, PoseStack poseStack, MultiBufferSource buffers, Camera camera, BlockHitResult blockHitResult, ItemStack itemInHand) {
        Item item = itemInHand.m_41720_();
        if (item instanceof IPartItem) {
            IPartItem partItem = (IPartItem)item;
            PartPlacement.Placement placement = PartPlacement.getPartPlacement(player, player.f_19853_, itemInHand, blockHitResult.m_82425_(), blockHitResult.m_82434_());
            if (placement != null) {
                Object part = partItem.createPart();
                RenderBlockOutlineHook.renderPart(poseStack, buffers, camera, placement.pos(), part, placement.side(), true);
            }
        }
    }

    private static void renderPart(PoseStack poseStack, MultiBufferSource buffers, Camera camera, BlockPos pos, IPart part, Direction side, boolean preview) {
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        BusCollisionHelper helper = new BusCollisionHelper(boxes, side, true);
        part.getBoxes(helper);
        RenderBlockOutlineHook.renderBoxes(poseStack, buffers, camera, pos, boxes, preview);
    }

    private static void renderFacade(PoseStack poseStack, MultiBufferSource buffers, Camera camera, BlockPos pos, IFacadePart facade, Direction side, boolean preview) {
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        BusCollisionHelper helper = new BusCollisionHelper(boxes, side, true);
        facade.getBoxes(helper, false);
        RenderBlockOutlineHook.renderBoxes(poseStack, buffers, camera, pos, boxes, preview);
    }

    private static void renderBoxes(PoseStack poseStack, MultiBufferSource buffers, Camera camera, BlockPos pos, List<AABB> boxes, boolean preview) {
        for (AABB box : boxes) {
            VoxelShape shape = Shapes.m_83064_((AABB)box);
            LevelRenderer.m_109782_((PoseStack)poseStack, (VertexConsumer)buffers.m_6299_(RenderType.m_110504_()), (VoxelShape)shape, (double)((double)pos.m_123341_() - camera.m_90583_().f_82479_), (double)((double)pos.m_123342_() - camera.m_90583_().f_82480_), (double)((double)pos.m_123343_() - camera.m_90583_().f_82481_), (float)(preview ? 1.0f : 0.0f), (float)(preview ? 1.0f : 0.0f), (float)(preview ? 1.0f : 0.0f), (float)0.4f);
        }
    }
}

