/*
 * Decompiled with CFR 0.152.
 */
package appeng.init.client;

import appeng.api.client.AEStackRendering;
import appeng.api.client.IAEStackRenderHandler;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKeyType;
import appeng.client.gui.style.FluidBlitter;
import appeng.util.Platform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fluids.FluidStack;

public class InitStackRenderHandlers {
    private InitStackRenderHandlers() {
    }

    public static void init() {
        AEStackRendering.register(AEKeyType.items(), AEItemKey.class, new IAEStackRenderHandler<AEItemKey>(){

            @Override
            public void drawInGui(Minecraft minecraft, PoseStack poseStack, int x, int y, int zIndex, AEItemKey stack) {
                ItemStack displayStack = stack.toStack();
                PoseStack globalStack = RenderSystem.m_157191_();
                globalStack.m_85836_();
                globalStack.m_166854_(poseStack.m_85850_().m_85861_());
                ItemRenderer itemRenderer = minecraft.m_91291_();
                float oldBlitOffset = itemRenderer.f_115093_;
                itemRenderer.f_115093_ = zIndex;
                itemRenderer.m_115123_(displayStack, x, y);
                itemRenderer.m_115174_(minecraft.f_91062_, displayStack, x, y, "");
                itemRenderer.f_115093_ = oldBlitOffset;
                globalStack.m_85849_();
                RenderSystem.m_157182_();
            }

            @Override
            public void drawOnBlockFace(PoseStack poseStack, MultiBufferSource buffers, AEItemKey what, float scale, int combinedLight) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, (double)0.01f);
                poseStack.m_166854_(Matrix4f.m_27632_((float)scale, (float)scale, (float)0.001f));
                poseStack.m_85850_().m_85864_().m_8171_(Vector3f.f_122222_.m_122240_(45.0f));
                Minecraft.m_91087_().m_91291_().m_174269_(what.toStack(), ItemTransforms.TransformType.GUI, combinedLight, OverlayTexture.f_118083_, poseStack, buffers, 0);
                poseStack.m_85849_();
            }

            @Override
            public Component getDisplayName(AEItemKey stack) {
                return stack.toStack().m_41786_();
            }

            @Override
            public List<Component> getTooltip(AEItemKey stack) {
                return stack.toStack().m_41651_(null, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
            }
        });
        AEStackRendering.register(AEKeyType.fluids(), AEFluidKey.class, new IAEStackRenderHandler<AEFluidKey>(){

            @Override
            public void drawInGui(Minecraft minecraft, PoseStack poseStack, int x, int y, int zIndex, AEFluidKey what) {
                FluidBlitter.create(what).dest(x, y, 16, 16).blit(poseStack, 100 + zIndex);
            }

            @Override
            public void drawOnBlockFace(PoseStack poseStack, MultiBufferSource buffers, AEFluidKey what, float scale, int combinedLight) {
                FluidStack fluidStack = what.toStack(1);
                ResourceLocation texture = what.getFluid().getAttributes().getStillTexture(fluidStack);
                int color = what.getFluid().getAttributes().getColor(fluidStack);
                TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(texture);
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, (double)0.01f);
                VertexConsumer buffer = buffers.m_6299_(RenderType.m_110451_());
                float x0 = -(scale -= 0.05f) / 2.0f;
                float y0 = scale / 2.0f;
                float x1 = scale / 2.0f;
                float y1 = -scale / 2.0f;
                Matrix4f transform = poseStack.m_85850_().m_85861_();
                buffer.m_85982_(transform, x0, y1, 0.0f).m_193479_(color).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                buffer.m_85982_(transform, x1, y1, 0.0f).m_193479_(color).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                buffer.m_85982_(transform, x1, y0, 0.0f).m_193479_(color).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                buffer.m_85982_(transform, x0, y0, 0.0f).m_193479_(color).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                poseStack.m_85849_();
            }

            @Override
            public Component getDisplayName(AEFluidKey stack) {
                return stack.getDisplayName();
            }

            @Override
            public List<Component> getTooltip(AEFluidKey stack) {
                ArrayList<Component> tooltip = new ArrayList<Component>();
                tooltip.add(stack.toStack(1).getDisplayName());
                String modName = Platform.formatModName(stack.getModId());
                if (tooltip.isEmpty() || !((Component)tooltip.get(tooltip.size() - 1)).getString().equals(modName)) {
                    tooltip.add((Component)new TextComponent(modName));
                }
                return tooltip;
            }
        });
    }
}

