/*
 * Decompiled with CFR 0.152.
 */
package appeng.init.internal;

import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.items.storage.BasicStorageCell;
import appeng.items.tools.powered.PortableCellItem;
import java.util.List;

public final class InitUpgrades {
    private InitUpgrades() {
    }

    public static void init() {
        String interfaceGroup = GuiText.Interface.getTranslationKey();
        String itemIoBusGroup = GuiText.IOBuses.getTranslationKey();
        String storageCellGroup = GuiText.StorageCells.getTranslationKey();
        Upgrades.add(AEItems.CRAFTING_CARD, AEParts.INTERFACE, 1, interfaceGroup);
        Upgrades.add(AEItems.CRAFTING_CARD, AEBlocks.INTERFACE, 1, interfaceGroup);
        Upgrades.add(AEItems.FUZZY_CARD, AEParts.INTERFACE, 1, interfaceGroup);
        Upgrades.add(AEItems.FUZZY_CARD, AEBlocks.INTERFACE, 1, interfaceGroup);
        Upgrades.add(AEItems.SPEED_CARD, AEBlocks.IO_PORT, 3);
        Upgrades.add(AEItems.REDSTONE_CARD, AEBlocks.IO_PORT, 1);
        Upgrades.add(AEItems.FUZZY_CARD, AEParts.LEVEL_EMITTER, 1);
        Upgrades.add(AEItems.CRAFTING_CARD, AEParts.LEVEL_EMITTER, 1);
        Upgrades.add(AEItems.FUZZY_CARD, AEParts.IMPORT_BUS, 1, itemIoBusGroup);
        Upgrades.add(AEItems.REDSTONE_CARD, AEParts.IMPORT_BUS, 1, itemIoBusGroup);
        Upgrades.add(AEItems.CAPACITY_CARD, AEParts.IMPORT_BUS, 2, itemIoBusGroup);
        Upgrades.add(AEItems.SPEED_CARD, AEParts.IMPORT_BUS, 4, itemIoBusGroup);
        Upgrades.add(AEItems.INVERTER_CARD, AEParts.IMPORT_BUS, 1, itemIoBusGroup);
        Upgrades.add(AEItems.FUZZY_CARD, AEParts.EXPORT_BUS, 1, itemIoBusGroup);
        Upgrades.add(AEItems.REDSTONE_CARD, AEParts.EXPORT_BUS, 1, itemIoBusGroup);
        Upgrades.add(AEItems.CAPACITY_CARD, AEParts.EXPORT_BUS, 2, itemIoBusGroup);
        Upgrades.add(AEItems.SPEED_CARD, AEParts.EXPORT_BUS, 4, itemIoBusGroup);
        Upgrades.add(AEItems.CRAFTING_CARD, AEParts.EXPORT_BUS, 1, itemIoBusGroup);
        List<ItemDefinition<BasicStorageCell>> itemCells = List.of(AEItems.ITEM_CELL_1K, AEItems.ITEM_CELL_4K, AEItems.ITEM_CELL_16K, AEItems.ITEM_CELL_64K, AEItems.ITEM_CELL_256K);
        for (ItemDefinition<BasicStorageCell> itemCell : itemCells) {
            Upgrades.add(AEItems.FUZZY_CARD, itemCell, 1, storageCellGroup);
            Upgrades.add(AEItems.INVERTER_CARD, itemCell, 1, storageCellGroup);
            Upgrades.add(AEItems.EQUAL_DISTRIBUTION_CARD, itemCell, 1, storageCellGroup);
            Upgrades.add(AEItems.VOID_CARD, itemCell, 1, storageCellGroup);
        }
        List<ItemDefinition<PortableCellItem>> portableCells = List.of(AEItems.PORTABLE_ITEM_CELL1K, AEItems.PORTABLE_ITEM_CELL4K, AEItems.PORTABLE_ITEM_CELL16K, AEItems.PORTABLE_ITEM_CELL64K, AEItems.PORTABLE_ITEM_CELL256K, AEItems.PORTABLE_FLUID_CELL1K, AEItems.PORTABLE_FLUID_CELL4K, AEItems.PORTABLE_FLUID_CELL16K, AEItems.PORTABLE_FLUID_CELL64K, AEItems.PORTABLE_FLUID_CELL256K);
        for (ItemDefinition<PortableCellItem> portableCell : portableCells) {
            Upgrades.add(AEItems.FUZZY_CARD, portableCell, 1, GuiText.PortableCells.getTranslationKey());
            Upgrades.add(AEItems.INVERTER_CARD, portableCell, 1, GuiText.PortableCells.getTranslationKey());
            Upgrades.add(AEItems.ENERGY_CARD, portableCell, 2, GuiText.PortableCells.getTranslationKey());
        }
        Upgrades.add(AEItems.ENERGY_CARD, AEItems.WIRELESS_TERMINAL, 2, GuiText.WirelessTerminals.getTranslationKey());
        Upgrades.add(AEItems.ENERGY_CARD, AEItems.WIRELESS_CRAFTING_TERMINAL, 2, GuiText.WirelessTerminals.getTranslationKey());
        Upgrades.add(AEItems.ENERGY_CARD, AEItems.COLOR_APPLICATOR, 2);
        Upgrades.add(AEItems.ENERGY_CARD, AEItems.MATTER_CANNON, 2);
        Upgrades.add(AEItems.INVERTER_CARD, AEItems.FLUID_CELL_1K, 1, storageCellGroup);
        Upgrades.add(AEItems.INVERTER_CARD, AEItems.FLUID_CELL_4K, 1, storageCellGroup);
        Upgrades.add(AEItems.INVERTER_CARD, AEItems.FLUID_CELL_16K, 1, storageCellGroup);
        Upgrades.add(AEItems.INVERTER_CARD, AEItems.FLUID_CELL_64K, 1, storageCellGroup);
        Upgrades.add(AEItems.INVERTER_CARD, AEItems.FLUID_CELL_256K, 1, storageCellGroup);
        Upgrades.add(AEItems.FUZZY_CARD, AEItems.VIEW_CELL, 1);
        Upgrades.add(AEItems.INVERTER_CARD, AEItems.VIEW_CELL, 1);
        Upgrades.add(AEItems.FUZZY_CARD, AEParts.STORAGE_BUS, 1);
        Upgrades.add(AEItems.INVERTER_CARD, AEParts.STORAGE_BUS, 1);
        Upgrades.add(AEItems.CAPACITY_CARD, AEParts.STORAGE_BUS, 5);
        Upgrades.add(AEItems.FUZZY_CARD, AEParts.FORMATION_PLANE, 1);
        Upgrades.add(AEItems.INVERTER_CARD, AEParts.FORMATION_PLANE, 1);
        Upgrades.add(AEItems.CAPACITY_CARD, AEParts.FORMATION_PLANE, 5);
        Upgrades.add(AEItems.FUZZY_CARD, AEItems.MATTER_CANNON, 1);
        Upgrades.add(AEItems.INVERTER_CARD, AEItems.MATTER_CANNON, 1);
        Upgrades.add(AEItems.SPEED_CARD, AEItems.MATTER_CANNON, 4);
        Upgrades.add(AEItems.SPEED_CARD, AEBlocks.MOLECULAR_ASSEMBLER, 5);
        Upgrades.add(AEItems.SPEED_CARD, AEBlocks.INSCRIBER, 3);
    }
}

