/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.util.DimensionalBlockPos;
import appeng.api.util.INetworkToolAware;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import appeng.items.contents.NetworkToolMenuHost;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.networktool.NetworkStatusMenu;
import appeng.menu.me.networktool.NetworkToolMenu;
import appeng.util.Platform;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class NetworkToolItem
extends AEBaseItem
implements IMenuItem,
AEToolItem {
    public NetworkToolItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public NetworkToolMenuHost getMenuHost(Player player, int inventorySlot, ItemStack stack, BlockPos pos) {
        Level level = player.f_19853_;
        if (pos == null) {
            return new NetworkToolMenuHost(player, inventorySlot, stack, null);
        }
        IInWorldGridNodeHost host = GridHelper.getNodeHost((LevelAccessor)level, pos);
        return new NetworkToolMenuHost(player, inventorySlot, stack, host);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player p, InteractionHand hand) {
        if (!level.m_5776_()) {
            MenuOpener.open(NetworkToolMenu.TYPE, p, MenuLocators.forHand(p, hand));
        }
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.m_5776_()), (Object)p.m_21120_(hand));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        INetworkToolAware toolAgent;
        if (context.m_7078_()) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockEntity te = level.m_7702_(context.m_8083_());
        if (te instanceof IPartHost) {
            INetworkToolAware toolAgent2;
            IPart iPart;
            IPartHost partHost = (IPartHost)te;
            SelectedPart part = partHost.selectPartWorld(context.m_43720_());
            if ((part.part != null || part.facade != null) && (iPart = part.part) instanceof INetworkToolAware && !(toolAgent2 = (INetworkToolAware)((Object)iPart)).showNetworkInfo(context)) {
                return InteractionResult.PASS;
            }
        } else if (te instanceof INetworkToolAware && !(toolAgent = (INetworkToolAware)te).showNetworkInfo(context)) {
            return InteractionResult.PASS;
        }
        if (!level.m_5776_() && !this.showNetworkToolGui(context)) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private boolean showNetworkToolGui(UseOnContext useContext) {
        if (useContext.m_43723_() == null) {
            return false;
        }
        BlockPos pos = useContext.m_8083_();
        Player p = useContext.m_43723_();
        Level level = useContext.m_43725_();
        InteractionHand hand = useContext.m_43724_();
        if (!Platform.hasPermissions(new DimensionalBlockPos(level, pos), p)) {
            return false;
        }
        IInWorldGridNodeHost nodeHost = GridHelper.getNodeHost((LevelAccessor)level, pos);
        if (nodeHost != null) {
            MenuOpener.open(NetworkStatusMenu.TYPE, p, MenuLocators.forItemUseContext(useContext));
        } else {
            MenuOpener.open(NetworkToolMenu.TYPE, p, MenuLocators.forHand(p, hand));
        }
        return true;
    }
}

