/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.ids.AEItemIds;
import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.StorageHelper;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableItem;
import appeng.api.upgrades.UpgradeInventories;
import appeng.block.AEBaseBlockItemChargeable;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.FluidContainerHelper;
import appeng.hooks.AEToolItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.PortableCellMenuHost;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.helpers.PlayerSource;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.util.ConfigInventory;
import appeng.util.InteractionUtil;
import appeng.util.fluid.FluidSoundHelper;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PortableCellItem
extends AEBasePoweredItem
implements IBasicCellItem,
IMenuItem,
IUpgradeableItem,
AEToolItem {
    public static final StorageTier SIZE_1K = new StorageTier("1k", 512, 54, 8, () -> (Item)Registry.f_122827_.m_7745_(AEItemIds.CELL_COMPONENT_1K));
    public static final StorageTier SIZE_4K = new StorageTier("4k", 2048, 45, 32, () -> (Item)Registry.f_122827_.m_7745_(AEItemIds.CELL_COMPONENT_4K));
    public static final StorageTier SIZE_16K = new StorageTier("16k", 8192, 36, 128, () -> (Item)Registry.f_122827_.m_7745_(AEItemIds.CELL_COMPONENT_16K));
    public static final StorageTier SIZE_64K = new StorageTier("64k", 32768, 27, 512, () -> (Item)Registry.f_122827_.m_7745_(AEItemIds.CELL_COMPONENT_64K));
    public static final StorageTier SIZE_256K = new StorageTier("256k", 131072, 18, 2048, () -> (Item)Registry.f_122827_.m_7745_(AEItemIds.CELL_COMPONENT_256K));
    private final StorageTier tier;
    private final AEKeyType keyType;
    private final MenuType<?> menuType;

    public ResourceLocation getRecipeId() {
        return AppEng.makeId("tools/" + Objects.requireNonNull(this.getRegistryName()).m_135815_());
    }

    public PortableCellItem(AEKeyType keyType, MenuType<?> menuType, StorageTier tier, Item.Properties props) {
        super(AEConfig.instance().getPortableCellBattery(), props);
        this.menuType = menuType;
        this.tier = tier;
        this.keyType = keyType;
    }

    @Override
    public double getChargeRate(ItemStack stack) {
        return 80.0 + 80.0 * (double)this.getUpgrades(stack).getInstalledUpgrades(AEItems.ENERGY_CARD);
    }

    public boolean openFromInventory(Player player, int inventorySlot) {
        ItemStack is = player.m_150109_().m_8020_(inventorySlot);
        if (is.m_41720_() == this) {
            return MenuOpener.open(this.getMenuType(), player, MenuLocators.forInventorySlot(inventorySlot));
        }
        return false;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return context.m_7078_() && this.disassembleDrive(stack, context.m_43725_(), context.m_43723_()) ? InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_()) : InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!(InteractionUtil.isInAlternateUseMode(player) && this.disassembleDrive(player.m_21120_(hand), level, player) || level.m_5776_())) {
            MenuOpener.open(this.getMenuType(), player, MenuLocators.forHand(player, hand));
        }
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.m_5776_()), (Object)player.m_21120_(hand));
    }

    private boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (!AEConfig.instance().isPortableCellDisassemblyEnabled()) {
            return false;
        }
        Recipe recipe = level.m_7465_().m_44043_(this.getRecipeId()).orElse(null);
        if (!(recipe instanceof CraftingRecipe)) {
            AELog.debug("Cannot disassemble portable cell because it's crafting recipe doesn't exist: %s", this.getRecipeId());
            return false;
        }
        CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
        if (level.m_5776_()) {
            return true;
        }
        Inventory playerInventory = player.m_150109_();
        if (playerInventory.m_36056_() != stack) {
            return false;
        }
        StorageCell inv = StorageCells.getCellInventory(stack, null);
        if (inv == null) {
            return false;
        }
        if (inv.getAvailableStacks().isEmpty()) {
            playerInventory.m_6836_(playerInventory.f_35977_, ItemStack.f_41583_);
            double remainingEnergy = this.getAECurrentPower(stack);
            for (Ingredient ingredient : craftingRecipe.m_7527_()) {
                Item item;
                ItemStack ingredientStack = ingredient.m_43908_()[0].m_41777_();
                if (remainingEnergy > 0.0 && (item = ingredientStack.m_41720_()) instanceof AEBaseBlockItemChargeable) {
                    AEBaseBlockItemChargeable chargeable = (AEBaseBlockItemChargeable)item;
                    remainingEnergy = chargeable.injectAEPower(ingredientStack, remainingEnergy, Actionable.MODULATE);
                }
                playerInventory.m_150079_(ingredientStack);
            }
            for (ItemStack upgrade : this.getUpgrades(stack)) {
                playerInventory.m_150079_(upgrade);
            }
        } else {
            player.m_6352_((Component)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), Util.f_137441_);
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        super.m_7373_(stack, level, lines, advancedTooltips);
        this.addCellInformationToTooltip(stack, lines);
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return this.tier.bytes();
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return this.tier.bytesPerType();
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return this.tier.types();
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem(is, 2, this::onUpgradesChanged);
    }

    private void onUpgradesChanged(ItemStack stack, IUpgradeInventory upgrades) {
        int energyCards = upgrades.getInstalledUpgrades(AEItems.ENERGY_CARD);
        this.setAEMaxPowerMultiplier(stack, 1 + energyCards * 8);
    }

    @Override
    public ConfigInventory getConfigInventory(ItemStack is) {
        return CellConfig.create(this.keyType.filter(), is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = is.m_41784_().m_128461_("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        is.m_41784_().m_128359_("FuzzyMode", fzMode.name());
    }

    @Override
    public PortableCellMenuHost getMenuHost(Player player, int inventorySlot, ItemStack stack, BlockPos pos) {
        return new PortableCellMenuHost(player, inventorySlot, this, stack, (p, sm) -> this.openFromInventory((Player)p, inventorySlot));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public long insert(Player player, ItemStack itemStack, AEKey what, long amount, Actionable mode) {
        if (this.keyType.tryCast(what) == null) {
            return 0L;
        }
        PortableCellMenuHost host = this.getMenuHost(player, -1, itemStack, null);
        if (host == null) {
            return 0L;
        }
        MEStorage inv = host.getInventory();
        if (inv != null) {
            return StorageHelper.poweredInsert(host, inv, what, amount, new PlayerSource(player), mode);
        }
        return 0L;
    }

    @Override
    public AEKeyType getKeyType() {
        return this.keyType;
    }

    public MenuType<?> getMenuType() {
        return this.menuType;
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        long extracted;
        GenericStack fluidStack;
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        ItemStack other = slot.m_7993_();
        if (other.m_41619_()) {
            return true;
        }
        if (this.keyType == AEKeyType.items()) {
            AEItemKey key = AEItemKey.of(other);
            int inserted = (int)this.insert(player, stack, key, other.m_41613_(), Actionable.MODULATE);
            other.m_41774_(inserted);
        } else if (this.keyType == AEKeyType.fluids() && (fluidStack = FluidContainerHelper.getContainedStack(other)) != null && this.insert(player, stack, fluidStack.what(), fluidStack.amount(), Actionable.SIMULATE) == fluidStack.amount() && (extracted = FluidContainerHelper.extractFromPlayerInventory(player, (AEFluidKey)fluidStack.what(), fluidStack.amount(), other)) > 0L) {
            this.insert(player, stack, fluidStack.what(), extracted, Actionable.MODULATE);
            FluidSoundHelper.playEmptySound(player, (AEFluidKey)fluidStack.what());
        }
        return true;
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        long extracted;
        GenericStack fluidStack;
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (other.m_41619_()) {
            return false;
        }
        if (this.keyType == AEKeyType.items()) {
            AEItemKey key = AEItemKey.of(other);
            int inserted = (int)this.insert(player, stack, key, other.m_41613_(), Actionable.MODULATE);
            other.m_41774_(inserted);
        } else if (this.keyType == AEKeyType.fluids() && (fluidStack = FluidContainerHelper.getContainedStack(other)) != null && this.insert(player, stack, fluidStack.what(), fluidStack.amount(), Actionable.SIMULATE) == fluidStack.amount() && (extracted = FluidContainerHelper.extractFromCarried(player, (AEFluidKey)fluidStack.what(), fluidStack.amount(), other)) > 0L) {
            this.insert(player, stack, fluidStack.what(), extracted, Actionable.MODULATE);
            FluidSoundHelper.playEmptySound(player, (AEFluidKey)fluidStack.what());
        }
        return true;
    }

    public StorageTier getTier() {
        return this.tier;
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        Item item;
        if (tintIndex == 1 && (item = stack.m_41720_()) instanceof PortableCellItem) {
            PortableCellItem portableCellItem = (PortableCellItem)item;
            if (portableCellItem.getAECurrentPower(stack) <= 0.0) {
                return CellState.ABSENT.getStateColor();
            }
            StorageCell cellInv = StorageCells.getCellInventory(stack, null);
            CellState cellStatus = cellInv != null ? cellInv.getStatus() : CellState.EMPTY;
            return cellStatus.getStateColor();
        }
        return 0xFFFFFF;
    }

    public record StorageTier(String namePrefix, int bytes, int types, int bytesPerType, Supplier<Item> componentSupplier) {
    }
}

